/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.features;

import java.text.MessageFormat;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IRemoveFeature;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.IMultiDeleteInfo;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.context.impl.RemoveContext;
import org.eclipse.graphiti.features.impl.AbstractFeature;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.internal.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class DefaultDeleteFeature
extends AbstractFeature
implements IDeleteFeature {
    private boolean doneChanges = false;
    private static final String NAME = Messages.DefaultDeleteFeature_1_xfld;

    public DefaultDeleteFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canDelete(IDeleteContext context) {
        PictogramElement pictogramElement = context.getPictogramElement();
        RemoveContext rc = new RemoveContext(pictogramElement);
        IRemoveFeature removeFeature = this.getFeatureProvider().getRemoveFeature((IRemoveContext)rc);
        boolean ret = removeFeature != null && removeFeature.canRemove((IRemoveContext)rc);
        return ret;
    }

    public void delete(IDeleteContext context) {
        this.setDoneChanges(false);
        IMultiDeleteInfo multiDeleteInfo = context.getMultiDeleteInfo();
        if (multiDeleteInfo != null && multiDeleteInfo.isDeleteCanceled()) {
            return;
        }
        PictogramElement pe = context.getPictogramElement();
        Object[] businessObjectsForPictogramElement = this.getAllBusinessObjectsForPictogramElement(pe);
        if (businessObjectsForPictogramElement != null && businessObjectsForPictogramElement.length > 0) {
            if (multiDeleteInfo == null) {
                if (!this.getUserDecision(context)) {
                    return;
                }
            } else if (multiDeleteInfo.isShowDialog()) {
                boolean okPressed = this.getUserDecision(context);
                if (okPressed) {
                    multiDeleteInfo.setShowDialog(false);
                } else {
                    multiDeleteInfo.setDeleteCanceled(true);
                    return;
                }
            }
        }
        this.setDoneChanges(true);
        this.preDelete(context);
        RemoveContext rc = new RemoveContext(pe);
        IFeatureProvider featureProvider = this.getFeatureProvider();
        IRemoveFeature removeFeature = featureProvider.getRemoveFeature((IRemoveContext)rc);
        if (removeFeature != null) {
            removeFeature.remove((IRemoveContext)rc);
        }
        this.deleteBusinessObjects(businessObjectsForPictogramElement);
        this.postDelete(context);
    }

    protected void deleteBusinessObjects(Object[] businessObjects) {
        if (businessObjects != null) {
            Object[] objectArray = businessObjects;
            int n = businessObjects.length;
            int n2 = 0;
            while (n2 < n) {
                Object bo = objectArray[n2];
                this.deleteBusinessObject(bo);
                ++n2;
            }
        }
    }

    protected void deleteBusinessObject(Object bo) {
        if (bo instanceof EObject) {
            EcoreUtil.delete((EObject)((EObject)bo), (boolean)true);
        }
    }

    public void preDelete(IDeleteContext context) {
    }

    public void postDelete(IDeleteContext context) {
    }

    public boolean canExecute(IContext context) {
        boolean ret = false;
        if (context instanceof IDeleteContext) {
            ret = this.canDelete((IDeleteContext)context);
        }
        return ret;
    }

    public void execute(IContext context) {
        if (context instanceof IDeleteContext) {
            this.delete((IDeleteContext)context);
        }
    }

    public String getName() {
        return NAME;
    }

    public boolean hasDoneChanges() {
        return this.doneChanges;
    }

    private void setDoneChanges(boolean doneChanges) {
        this.doneChanges = doneChanges;
    }

    protected boolean getUserDecision(IDeleteContext context) {
        String deleteName;
        IMultiDeleteInfo multiDeleteInfo = context.getMultiDeleteInfo();
        String msg = multiDeleteInfo != null ? MessageFormat.format(Messages.DefaultDeleteFeature_2_xmsg, multiDeleteInfo.getNumber()) : ((deleteName = this.getDeleteName(context)) != null && deleteName.length() > 0 ? MessageFormat.format(Messages.DefaultDeleteFeature_3_xmsg, deleteName) : Messages.DefaultDeleteFeature_4_xmsg);
        return MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.DefaultDeleteFeature_5_xfld, (String)msg);
    }

    protected String getDeleteName(IDeleteContext context) {
        return null;
    }
}

