/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.services.impl;

import org.eclipse.graphiti.ui.internal.GraphitiUIPlugin;
import org.eclipse.graphiti.ui.internal.platform.ExtensionManager;
import org.eclipse.graphiti.ui.platform.IImageProvider;
import org.eclipse.graphiti.ui.services.IImageService;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ImageService
implements IImageService {
    @Override
    public ImageDescriptor getImageDescriptorForId(String imageId) {
        if (imageId == null) {
            return null;
        }
        ImageRegistry imageRegistry = GraphitiUIPlugin.getDefault().getImageRegistry();
        ImageDescriptor imageDescriptor = imageRegistry.getDescriptor(imageId);
        if (imageDescriptor != null) {
            return imageDescriptor;
        }
        imageDescriptor = this.createImageDescriptorForId(imageId);
        return imageDescriptor;
    }

    @Override
    public Image getImageForId(String imageId) {
        if (imageId == null) {
            return null;
        }
        ImageRegistry imageRegistry = GraphitiUIPlugin.getDefault().getImageRegistry();
        Image result = imageRegistry.get(imageId);
        if (result != null && !result.isDisposed()) {
            return result;
        }
        this.createImageDescriptorForId(imageId);
        Image image = imageRegistry.get(imageId);
        if (image == null) {
            throw new IllegalStateException("No image could be retrieved for imageId '" + imageId + "'");
        }
        return image;
    }

    @Override
    public void removeImageFromRegistry(String key) {
        ImageRegistry imageRegistry = GraphitiUIPlugin.getDefault().getImageRegistry();
        imageRegistry.remove(key);
    }

    private ImageDescriptor fixImageDescriptor(ImageDescriptor descriptor) {
        ImageData data = descriptor.getImageData();
        return ImageDescriptor.createFromImageData((ImageData)data);
    }

    private ImageDescriptor createImageDescriptorForId(String imageId) {
        if (imageId == null) {
            return null;
        }
        ImageRegistry imageRegistry = GraphitiUIPlugin.getDefault().getImageRegistry();
        ImageDescriptor imageDescriptor = imageRegistry.getDescriptor(imageId);
        if (imageDescriptor != null) {
            return imageDescriptor;
        }
        IImageProvider[] imageProviders = ExtensionManager.getSingleton().getImageProviders();
        int i = 0;
        while (i < imageProviders.length) {
            IImageProvider imageProvider = imageProviders[i];
            String imageFilePath = imageProvider.getImageFilePath(imageId);
            if (imageFilePath != null) {
                String pluginId = imageProvider.getPluginId();
                if (pluginId == null) break;
                imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)pluginId, (String)imageFilePath);
                break;
            }
            ++i;
        }
        if (imageDescriptor == null) {
            imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        imageDescriptor = this.fixImageDescriptor(imageDescriptor);
        imageRegistry.put(imageId, imageDescriptor);
        return imageDescriptor;
    }
}

