/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.services.impl;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.graphiti.internal.util.T;
import org.eclipse.graphiti.ui.internal.platform.ExtensionManager;
import org.eclipse.graphiti.ui.internal.services.GraphitiUiInternal;
import org.eclipse.graphiti.ui.internal.services.IUiService;
import org.eclipse.graphiti.ui.internal.util.ui.print.ExportDiagramDialog;
import org.eclipse.graphiti.ui.internal.util.ui.print.IDiagramsExporter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class UiService
implements IUiService {
    @Override
    public byte[] createImage(Image image, int format) throws Exception {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            ImageData imDat = null;
            if (format == 2) {
                imDat = this.create8BitIndexedPaletteImage(image);
            }
            if (imDat == null) {
                imDat = image.getImageData();
            }
            ImageLoader imageLoader = new ImageLoader();
            imageLoader.data = new ImageData[]{imDat};
            try {
                imageLoader.save((OutputStream)result, format);
            }
            catch (SWTException e) {
                String error = "Depth: " + Integer.toString(image.getImageData().depth) + "\n" + "X: " + Integer.toString(image.getImageData().x) + "\n" + "Y: " + Integer.toString(image.getImageData().y);
                throw new IllegalStateException(error, e);
            }
        }
        finally {
            image.dispose();
        }
        return result.toByteArray();
    }

    @Override
    public ImageData create8BitIndexedPaletteImage(Image image) throws Exception {
        int upperboundWidth = image.getBounds().width;
        int upperboundHeight = image.getBounds().height;
        ImageData imageData = image.getImageData();
        ArrayList<Integer> colors = new ArrayList<Integer>();
        int x = 0;
        while (x < upperboundWidth) {
            int y = 0;
            while (y < upperboundHeight) {
                int color = imageData.getPixel(x, y);
                Integer colorInteger = new Integer(color);
                if (!colors.contains(colorInteger)) {
                    colors.add(colorInteger);
                }
                ++y;
            }
            ++x;
        }
        if (colors.size() > 256) {
            throw new Exception("Image contains more than 256 colors. \n Automated color reduction is currently not supported.");
        }
        RGB[] rgbs = new RGB[256];
        int i = 0;
        while (i < 256) {
            rgbs[i] = new RGB(255, 255, 255);
            ++i;
        }
        i = 0;
        while (i < colors.size()) {
            int pixelValue = (Integer)colors.get(i);
            int red = (pixelValue & imageData.palette.redMask) >>> Math.abs(imageData.palette.redShift);
            int green = (pixelValue & imageData.palette.greenMask) >>> Math.abs(imageData.palette.greenShift);
            int blue = (pixelValue & imageData.palette.blueMask) >>> Math.abs(imageData.palette.blueShift);
            rgbs[i] = new RGB(red, green, blue);
            ++i;
        }
        PaletteData palette = new PaletteData(rgbs);
        ImageData newImageData = new ImageData(imageData.width, imageData.height, 8, palette);
        int x2 = 0;
        while (x2 < upperboundWidth) {
            int y = 0;
            while (y < upperboundHeight) {
                int color = imageData.getPixel(x2, y);
                newImageData.setPixel(x2, y, colors.indexOf(new Integer(color)));
                ++y;
            }
            ++x2;
        }
        return newImageData;
    }

    @Override
    public void startSaveAsImageDialog(GraphicalViewer graphicalViewer) {
        String METHOD = "startSaveAsImageDialog(graphicalViewer)";
        Map<String, Boolean> diagramExporterTypes = ExtensionManager.getSingleton().getDiagramExporterTypes();
        Shell shell = GraphitiUiInternal.getWorkbenchService().getShell();
        ExportDiagramDialog saveAsImageDialog = new ExportDiagramDialog(shell, graphicalViewer);
        saveAsImageDialog.addExporters(diagramExporterTypes);
        saveAsImageDialog.open();
        if (saveAsImageDialog.getReturnCode() == 1) {
            return;
        }
        FileDialog fileDialog = new FileDialog(shell, 8192);
        String[] fileExtensions = new String[]{"*." + saveAsImageDialog.getFormattedFileExtension()};
        fileDialog.setFilterExtensions(fileExtensions);
        String filename = fileDialog.open();
        if (filename != null) {
            try {
                IRunnableWithProgress operation;
                Path path = new Path(filename);
                if (path.getFileExtension() == null) {
                    filename = String.valueOf(filename) + "." + saveAsImageDialog.getFormattedFileExtension();
                }
                String file = filename;
                Image im = saveAsImageDialog.getScaledImage();
                String imageExtension = saveAsImageDialog.getFileExtension();
                if (diagramExporterTypes.containsKey(imageExtension)) {
                    IDiagramsExporter exporter = ExtensionManager.getSingleton().getDiagramExporterForType(imageExtension);
                    Assert.isNotNull((Object)exporter);
                    operation = this.getExportOp("startSaveAsImageDialog(graphicalViewer)", shell, saveAsImageDialog, file, im, exporter);
                    new ProgressMonitorDialog(shell).run(false, false, operation);
                } else {
                    int imageFormat = saveAsImageDialog.getImageFormat();
                    byte[] image = this.createImage(im, imageFormat);
                    operation = this.getSaveToFileOp(shell, file, image);
                }
                new ProgressMonitorDialog(shell).run(false, false, operation);
            }
            catch (Exception e) {
                String message = "Can not save image: ";
                MessageDialog.openError((Shell)shell, (String)"Can not save image", (String)(String.valueOf(message) + e.getMessage()));
                T.racer().error("startSaveAsImageDialog(graphicalViewer)", String.valueOf(message) + "\nDetails: " + GraphitiUiInternal.getTraceService().getStacktrace(e));
                e.printStackTrace();
            }
        }
    }

    private IRunnableWithProgress getExportOp(String METHOD, final Shell shell, final ExportDiagramDialog saveAsImageDialog, final String file, final Image im, final IDiagramsExporter exporter) {
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                try {
                    exporter.export(im, saveAsImageDialog.getFigure(), file, saveAsImageDialog.getImageScaleFactor());
                }
                catch (Exception e) {
                    UiService.this.handleException(shell, e);
                }
            }
        };
        return operation;
    }

    private void handleException(Shell shell, Exception e) {
        String message = "Can not export diagram: ";
        MessageDialog.openError((Shell)shell, (String)"Can not export diagram", (String)(String.valueOf(message) + e.getMessage()));
        e.printStackTrace();
    }

    private IRunnableWithProgress getSaveToFileOp(final Shell shell, final String filename, final byte[] contents) throws Exception {
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                FileOutputStream outputStream = null;
                try {
                    try {
                        outputStream = new FileOutputStream(filename);
                        outputStream.write(contents);
                    }
                    catch (Exception e) {
                        UiService.this.handleException(shell, e);
                        try {
                            outputStream.close();
                        }
                        catch (Exception x) {
                            T.racer().error("close output stream failed", (Throwable)x);
                        }
                    }
                }
                finally {
                    try {
                        outputStream.close();
                    }
                    catch (Exception x) {
                        T.racer().error("close output stream failed", (Throwable)x);
                    }
                }
            }
        };
        return operation;
    }
}

