/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.features.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IAddBendpointFeature;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IDirectEditingFeature;
import org.eclipse.graphiti.features.IDirectEditingInfo;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.ILayoutFeature;
import org.eclipse.graphiti.features.IMoveAnchorFeature;
import org.eclipse.graphiti.features.IMoveBendpointFeature;
import org.eclipse.graphiti.features.IMoveConnectionDecoratorFeature;
import org.eclipse.graphiti.features.IMoveShapeFeature;
import org.eclipse.graphiti.features.IPrintFeature;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.IReconnectionFeature;
import org.eclipse.graphiti.features.IRemoveBendpointFeature;
import org.eclipse.graphiti.features.IRemoveFeature;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.ISaveImageFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IAddBendpointContext;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.IDirectEditingContext;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.IMoveAnchorContext;
import org.eclipse.graphiti.features.context.IMoveBendpointContext;
import org.eclipse.graphiti.features.context.IMoveConnectionDecoratorContext;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.features.context.IPictogramElementContext;
import org.eclipse.graphiti.features.context.IReconnectionContext;
import org.eclipse.graphiti.features.context.IRemoveBendpointContext;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.features.impl.DefaultDirectEditingInfo;
import org.eclipse.graphiti.features.impl.DefaultPrintFeature;
import org.eclipse.graphiti.features.impl.DefaultReconnectionFeature;
import org.eclipse.graphiti.features.impl.DefaultSaveImageFeature;
import org.eclipse.graphiti.features.impl.IIndependenceSolver;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.internal.services.GraphitiInternal;
import org.eclipse.graphiti.internal.util.T;
import org.eclipse.graphiti.mm.Property;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.PictogramLink;
import org.eclipse.graphiti.mm.pictograms.PictogramsFactory;
import org.eclipse.graphiti.platform.IDiagramEditor;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.ILinkService;

public abstract class AbstractFeatureProvider
implements IFeatureProvider {
    private static final ICustomFeature[] ZERO_CUSTOM_FEATURES = new ICustomFeature[0];
    protected static final EObject[] NO_OBJECTS = new EObject[0];
    protected static final PictogramElement[] EMPTY_PICTOGRAM_ELEMENTS = new PictogramElement[0];
    private IDiagramTypeProvider dtp;
    private IDirectEditingInfo directEditingInfo = new DefaultDirectEditingInfo();
    private IIndependenceSolver independenceSolver = null;
    StringTransformer st = new StringTransformer();

    public AbstractFeatureProvider(IDiagramTypeProvider diagramTypeProvider) {
        this.dtp = diagramTypeProvider;
    }

    @Override
    public IAddFeature getAddFeature(IAddContext context) {
        return null;
    }

    @Override
    public ICreateConnectionFeature[] getCreateConnectionFeatures() {
        return new ICreateConnectionFeature[0];
    }

    @Override
    public ICreateFeature[] getCreateFeatures() {
        return new ICreateFeature[0];
    }

    @Override
    public ICustomFeature[] getCustomFeatures(ICustomContext context) {
        return ZERO_CUSTOM_FEATURES;
    }

    @Override
    public IDeleteFeature getDeleteFeature(IDeleteContext context) {
        return null;
    }

    @Override
    public IDiagramTypeProvider getDiagramTypeProvider() {
        return this.dtp;
    }

    @Override
    public IMoveAnchorFeature getMoveAnchorFeature(IMoveAnchorContext context) {
        return null;
    }

    @Override
    public IRemoveFeature getRemoveFeature(IRemoveContext context) {
        return null;
    }

    @Override
    public IUpdateFeature getUpdateFeature(IUpdateContext context) {
        return null;
    }

    @Override
    public ILayoutFeature getLayoutFeature(ILayoutContext context) {
        return null;
    }

    @Override
    public IMoveShapeFeature getMoveShapeFeature(IMoveShapeContext context) {
        return null;
    }

    @Override
    public IMoveConnectionDecoratorFeature getMoveConnectionDecoratorFeature(IMoveConnectionDecoratorContext context) {
        return null;
    }

    @Override
    public IMoveBendpointFeature getMoveBendpointFeature(IMoveBendpointContext context) {
        return null;
    }

    @Override
    public IResizeShapeFeature getResizeShapeFeature(IResizeShapeContext context) {
        return null;
    }

    @Override
    public IAddBendpointFeature getAddBendpointFeature(IAddBendpointContext context) {
        return null;
    }

    @Override
    public IRemoveBendpointFeature getRemoveBendpointFeature(IRemoveBendpointContext context) {
        return null;
    }

    @Override
    public IDirectEditingFeature getDirectEditingFeature(IDirectEditingContext context) {
        return null;
    }

    @Override
    public IReason canUpdate(IUpdateContext context) {
        String SIGNATURE = "canUpdate(IUpdateContext)";
        boolean info = T.racer().info();
        if (info) {
            T.racer().entering(AbstractFeatureProvider.class, "canUpdate(IUpdateContext)", context);
        }
        IReason ret = Reason.createFalseReason();
        IUpdateFeature updateFeature = this.getUpdateFeature(context);
        if (updateFeature != null) {
            boolean b = updateFeature.canUpdate(context);
            ret = new Reason(b);
        }
        if (info) {
            T.racer().exiting(AbstractFeatureProvider.class, "canUpdate(IUpdateContext)", ret);
        }
        return ret;
    }

    @Override
    public IReason canLayout(ILayoutContext context) {
        String SIGNATURE = "canLayout(ILayoutContext)";
        boolean info = T.racer().info();
        if (info) {
            T.racer().entering(AbstractFeatureProvider.class, "canLayout(ILayoutContext)", context);
        }
        IReason ret = Reason.createFalseReason();
        ILayoutFeature layoutFeature = this.getLayoutFeature(context);
        if (layoutFeature != null) {
            boolean b = layoutFeature.canLayout(context);
            ret = new Reason(b);
        }
        if (info) {
            T.racer().exiting(AbstractFeatureProvider.class, "canLayout(ILayoutContext)", ret);
        }
        return ret;
    }

    @Override
    public IReason updateIfPossible(IUpdateContext context) {
        String SIGNATURE = "updateIfPossible(IUpdateContext)";
        boolean info = T.racer().info();
        if (info) {
            T.racer().entering(AbstractFeatureProvider.class, "updateIfPossible(IUpdateContext)", context);
        }
        boolean b = false;
        IUpdateFeature updateFeature = this.getUpdateFeature(context);
        if (updateFeature != null) {
            IDiagramEditor diagramEditor = this.getDiagramTypeProvider().getDiagramEditor();
            try {
                diagramEditor.executeFeature(updateFeature, context);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }
        Reason reason = new Reason(b);
        if (info) {
            T.racer().exiting(AbstractFeatureProvider.class, "updateIfPossible(IUpdateContext)", reason);
        }
        return reason;
    }

    @Override
    public IReason layoutIfPossible(ILayoutContext context) {
        String SIGNATURE = "layoutIfPossible(ILayoutContext)";
        boolean info = T.racer().info();
        if (info) {
            T.racer().entering(AbstractFeatureProvider.class, "layoutIfPossible(ILayoutContext)", context);
        }
        boolean b = false;
        ILayoutFeature layoutSemanticsFeature = this.getLayoutFeature(context);
        if (layoutSemanticsFeature != null) {
            IDiagramEditor diagramEditor = this.getDiagramTypeProvider().getDiagramEditor();
            try {
                diagramEditor.executeFeature(layoutSemanticsFeature, context);
                b = true;
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }
        Reason res = new Reason(b);
        if (info) {
            T.racer().exiting(AbstractFeatureProvider.class, "layoutIfPossible(ILayoutContext)", res);
        }
        return res;
    }

    @Override
    public IReason updateNeeded(IUpdateContext context) {
        IUpdateFeature updateFeature;
        String SIGNATURE = "updateNeeded(IUpdateContext)";
        boolean info = T.racer().info();
        if (info) {
            T.racer().entering(AbstractFeatureProvider.class, "updateNeeded(IUpdateContext)", context);
        }
        IReason ret = Reason.createFalseReason();
        PictogramElement pe = context.getPictogramElement();
        if (pe != null && GraphitiInternal.getEmfService().isObjectAlive((EObject)pe) && (updateFeature = this.getUpdateFeature(context)) != null) {
            ret = updateFeature.updateNeeded(context);
        }
        if (info) {
            T.racer().exiting(AbstractFeatureProvider.class, "updateNeeded(IUpdateContext)", ret);
        }
        return ret;
    }

    @Override
    public IReason updateIfPossibleAndNeeded(IUpdateContext context) {
        IReason ret;
        String SIGNATURE = "updateIfPossibleAndNeeded(IUpdateContext)";
        boolean info = T.racer().info();
        if (info) {
            T.racer().entering(AbstractFeatureProvider.class, "updateIfPossibleAndNeeded(IUpdateContext)", context);
        }
        if ((ret = this.canUpdate(context)).toBoolean() && (ret = this.updateNeeded(context)).toBoolean()) {
            ret = this.updateIfPossible(context);
        }
        if (info) {
            T.racer().exiting(AbstractFeatureProvider.class, "updateIfPossibleAndNeeded(IUpdateContext)", ret);
        }
        return ret;
    }

    @Override
    public PictogramElement addIfPossible(IAddContext context) {
        String SIGNATURE = "addIfPossible(IAddContext)";
        boolean info = T.racer().info();
        if (info) {
            T.racer().entering(AbstractFeatureProvider.class, "addIfPossible(IAddContext)", context);
        }
        PictogramElement ret = null;
        if (this.canAdd(context).toBoolean()) {
            IAddFeature feature = this.getAddFeature(context);
            IDiagramEditor diagramEditor = this.getDiagramTypeProvider().getDiagramEditor();
            try {
                diagramEditor.executeFeature(feature, context);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }
        if (info) {
            T.racer().exiting(AbstractFeatureProvider.class, "addIfPossible(IAddContext)", ret);
        }
        return ret;
    }

    @Override
    public IReason canAdd(IAddContext context) {
        String SIGNATURE = "canAdd(IAddContext)";
        boolean info = T.racer().info();
        if (info) {
            T.racer().entering(AbstractFeatureProvider.class, "canAdd(IAddContext)", context);
        }
        IReason ret = Reason.createFalseReason();
        IAddFeature feature = this.getAddFeature(context);
        if (feature != null) {
            boolean b = feature.canAdd(context);
            ret = new Reason(b);
        }
        if (info) {
            T.racer().exiting(AbstractFeatureProvider.class, "canAdd(IAddContext)", ret);
        }
        return ret;
    }

    @Override
    public final IDirectEditingInfo getDirectEditingInfo() {
        return this.directEditingInfo;
    }

    @Override
    public IReconnectionFeature getReconnectionFeature(IReconnectionContext context) {
        return new DefaultReconnectionFeature(this);
    }

    @Override
    public IPrintFeature getPrintFeature() {
        return new DefaultPrintFeature(this);
    }

    @Override
    public ISaveImageFeature getSaveImageFeature() {
        return new DefaultSaveImageFeature(this);
    }

    @Override
    public IFeature[] getDragAndDropFeatures(IPictogramElementContext context) {
        return new IFeature[0];
    }

    @Override
    public Object[] getAllBusinessObjectsForPictogramElement(PictogramElement pictogramElement) {
        EObject[] allBusinessObjectsForLinkedPictogramElement;
        Property property;
        String SIGNATURE = "getAllBusinessObjectsForPictogramElement(PictogramElement)";
        boolean info = T.racer().info();
        if (info) {
            T.racer().entering(AbstractFeatureProvider.class, "getAllBusinessObjectsForPictogramElement(PictogramElement)", pictogramElement);
        }
        Object[] ret = new Object[]{};
        ArrayList<Object> retList = new ArrayList<Object>();
        if (this.getIndependenceSolver() != null && (property = Graphiti.getPeService().getProperty((PropertyContainer)pictogramElement, "independentObject")) != null && property.getValue() != null) {
            String[] values;
            String value = property.getValue();
            String[] stringArray = values = this.getValues(value);
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String v = stringArray[n2];
                retList.add(this.getIndependenceSolver().getBusinessObjectForKey(v));
                ++n2;
            }
        }
        EObject[] eObjectArray = allBusinessObjectsForLinkedPictogramElement = this.getLinkService().getAllBusinessObjectsForLinkedPictogramElement(pictogramElement);
        int n = allBusinessObjectsForLinkedPictogramElement.length;
        int n3 = 0;
        while (n3 < n) {
            EObject eObject = eObjectArray[n3];
            retList.add(eObject);
            ++n3;
        }
        if (info) {
            T.racer().exiting(AbstractFeatureProvider.class, "getAllBusinessObjectsForPictogramElement(PictogramElement)", ret);
        }
        return retList.toArray(ret);
    }

    private String[] getValues(String value) {
        if (value.isEmpty()) {
            return new String[0];
        }
        return this.st.decode(value);
    }

    @Override
    public Object getBusinessObjectForPictogramElement(PictogramElement pictogramElement) {
        Property property;
        String SIGNATURE = "getBusinessObjectForPictogramElement(PictogramElement)";
        boolean info = T.racer().info();
        if (info) {
            T.racer().entering(AbstractFeatureProvider.class, "getBusinessObjectForPictogramElement(PictogramElement)", pictogramElement);
        }
        Object ret = null;
        if (this.getIndependenceSolver() != null && (property = Graphiti.getPeService().getProperty((PropertyContainer)pictogramElement, "independentObject")) != null && property.getValue() != null) {
            String[] values = this.getValues(property.getValue());
            if (values.length > 0) {
                ret = this.getIndependenceSolver().getBusinessObjectForKey(values[0]);
            }
            if (ret != null) {
                if (info) {
                    T.racer().exiting(AbstractFeatureProvider.class, "getBusinessObjectForPictogramElement(PictogramElement)", ret);
                }
                return ret;
            }
        }
        ret = this.getLinkService().getBusinessObjectForLinkedPictogramElement(pictogramElement);
        if (info) {
            T.racer().exiting(AbstractFeatureProvider.class, "getBusinessObjectForPictogramElement(PictogramElement)", ret);
        }
        return ret;
    }

    @Override
    public PictogramElement[] getAllPictogramElementsForBusinessObject(Object businessObject) {
        Diagram diagram;
        String keyForBusinessObject;
        String SIGNATURE = "getAllPictogramElementsForBusinessObject(Object)";
        boolean info = T.racer().info();
        if (info) {
            T.racer().entering(AbstractFeatureProvider.class, "getAllPictogramElementsForBusinessObject(Object)", businessObject);
        }
        ArrayList<PictogramElement> retList = new ArrayList<PictogramElement>();
        IIndependenceSolver solver = this.getIndependenceSolver();
        if (solver != null && (keyForBusinessObject = solver.getKeyForBusinessObject(businessObject)) != null) {
            Collection<PictogramElement> allContainedPictogramElements = Graphiti.getPeService().getAllContainedPictogramElements((PictogramElement)this.getDiagramTypeProvider().getDiagram());
            for (PictogramElement pe : allContainedPictogramElements) {
                Property property = Graphiti.getPeService().getProperty((PropertyContainer)pe, "independentObject");
                if (property == null || !Arrays.asList(this.getValues(property.getValue())).contains(keyForBusinessObject)) continue;
                retList.add(pe);
            }
        }
        if (businessObject instanceof EObject && (diagram = this.getDiagramTypeProvider().getDiagram()) != null) {
            EList pictogramLinks = diagram.getPictogramLinks();
            block1: for (PictogramLink pictogramLink : pictogramLinks) {
                EList businessObjects = pictogramLink.getBusinessObjects();
                for (EObject obj : businessObjects) {
                    if (!this.getDiagramTypeProvider().getCurrentToolBehaviorProvider().equalsBusinessObjects(businessObject, obj)) continue;
                    PictogramElement pe = pictogramLink.getPictogramElement();
                    if (pe == null) continue block1;
                    retList.add(pe);
                    continue block1;
                }
            }
        }
        PictogramElement[] res = retList.toArray(new PictogramElement[0]);
        if (info) {
            T.racer().exiting(AbstractFeatureProvider.class, "getAllPictogramElementsForBusinessObject(Object)", res);
        }
        return res;
    }

    @Override
    public PictogramElement getPictogramElementForBusinessObject(Object businessObject) {
        String SIGNATURE = "getPictogramElementForBusinessObject(Object)";
        boolean info = T.racer().info();
        if (info) {
            T.racer().entering(AbstractFeatureProvider.class, "getPictogramElementForBusinessObject(Object)", businessObject);
        }
        PictogramElement result = null;
        if (businessObject instanceof EObject) {
            Diagram diagram = this.getDiagramTypeProvider().getDiagram();
            if (diagram != null) {
                EList pictogramLinks = diagram.getPictogramLinks();
                for (PictogramLink pictogramLink : pictogramLinks) {
                    EList businessObjects = pictogramLink.getBusinessObjects();
                    for (EObject obj : businessObjects) {
                        if (!this.getDiagramTypeProvider().getCurrentToolBehaviorProvider().equalsBusinessObjects(businessObject, obj)) continue;
                        PictogramElement pe = pictogramLink.getPictogramElement();
                        if (pe == null) break;
                        result = pe;
                        break;
                    }
                    if (result == null) {
                        continue;
                    }
                    break;
                }
            }
        } else {
            String keyForBusinessObject;
            IIndependenceSolver solver = this.getIndependenceSolver();
            if (solver != null && (keyForBusinessObject = solver.getKeyForBusinessObject(businessObject)) != null) {
                Collection<PictogramElement> allContainedPictogramElements = Graphiti.getPeService().getAllContainedPictogramElements((PictogramElement)this.getDiagramTypeProvider().getDiagram());
                for (PictogramElement pe : allContainedPictogramElements) {
                    Property property = Graphiti.getPeService().getProperty((PropertyContainer)pe, "independentObject");
                    if (property == null || !Arrays.asList(this.getValues(property.getValue())).contains(keyForBusinessObject)) continue;
                    result = pe;
                    break;
                }
            }
        }
        if (info) {
            T.racer().exiting(AbstractFeatureProvider.class, "getPictogramElementForBusinessObject(Object)", result);
        }
        return result;
    }

    @Override
    public boolean hasPictogramElementForBusinessObject(Object businessObject) {
        return this.getPictogramElementForBusinessObject(businessObject) != null;
    }

    @Override
    public void link(PictogramElement pictogramElement, Object businessObject) {
        this.link(pictogramElement, new Object[]{businessObject});
    }

    @Override
    public void link(PictogramElement pictogramElement, Object[] businessObjects) {
        IIndependenceSolver is;
        String SIGNATURE = "link(PictogramElement, Object[])";
        boolean info = T.racer().info();
        if (info) {
            T.racer().entering(AbstractFeatureProvider.class, "link(PictogramElement, Object[])", pictogramElement, businessObjects);
        }
        if ((is = this.getIndependenceSolver()) == null) {
            PictogramLink link = this.createOrGetPictogramLink(pictogramElement);
            if (link != null) {
                link.getBusinessObjects().clear();
                if (businessObjects != null) {
                    int i = 0;
                    while (i < businessObjects.length) {
                        EObject bo = (EObject)businessObjects[i];
                        Resource resource = bo.eResource();
                        Assert.isNotNull((Object)resource, (String)(" Business object " + bo + " is not contained in a resource"));
                        ResourceSet resourceSet = resource.getResourceSet();
                        Assert.isNotNull((Object)resourceSet, (String)(" Resource " + resource + " is not contained in a resource set"));
                        TransactionalEditingDomain editingDomain = this.getDiagramTypeProvider().getDiagramEditor().getEditingDomain();
                        ResourceSet editorResourceSet = editingDomain.getResourceSet();
                        if (!resourceSet.equals(editorResourceSet)) {
                            URI boUri = EcoreUtil.getURI((EObject)bo);
                            bo = editorResourceSet.getEObject(boUri, true);
                        }
                        if (bo != null) {
                            link.getBusinessObjects().add((Object)bo);
                        }
                        ++i;
                    }
                }
            }
        } else {
            ArrayList<String> values = new ArrayList<String>();
            Object[] objectArray = businessObjects;
            int n = businessObjects.length;
            int n2 = 0;
            while (n2 < n) {
                Object bo = objectArray[n2];
                String propertyValue = is.getKeyForBusinessObject(bo);
                if (propertyValue != null) {
                    values.add(propertyValue);
                }
                ++n2;
            }
            String encodedValues = this.st.encode(values.toArray(new String[0]));
            Graphiti.getPeService().setPropertyValue((PropertyContainer)pictogramElement, "independentObject", encodedValues);
        }
        if (info) {
            T.racer().exiting(AbstractFeatureProvider.class, "link(PictogramElement, Object[])");
        }
    }

    private PictogramLink createPictogramLink(PictogramElement pe) {
        PictogramLink ret = null;
        Diagram diagram = this.getDiagramTypeProvider().getDiagram();
        if (diagram != null) {
            ret = PictogramsFactory.eINSTANCE.createPictogramLink();
            ret.setPictogramElement(pe);
            diagram.getPictogramLinks().add((Object)ret);
        }
        return ret;
    }

    private PictogramLink createOrGetPictogramLink(PictogramElement pe) {
        PictogramLink link = pe.getLink();
        if (link == null) {
            link = this.createPictogramLink(pe);
        }
        return link;
    }

    protected final IIndependenceSolver getIndependenceSolver() {
        return this.independenceSolver;
    }

    protected final void setIndependenceSolver(IIndependenceSolver independenceSolver) {
        this.independenceSolver = independenceSolver;
    }

    @Override
    public void dispose() {
    }

    protected ILinkService getLinkService() {
        return Graphiti.getLinkService();
    }

    private class StringTransformer {
        private static final String marker = "__independentN";

        private StringTransformer() {
        }

        String[] decode(String value) {
            if (!value.startsWith(marker)) {
                return new String[]{value};
            }
            value = value.substring(marker.length(), value.length());
            return value.split(marker);
        }

        String encode(String[] segments) {
            if (segments.length == 1) {
                return segments[0];
            }
            StringBuffer sb = new StringBuffer();
            String[] stringArray = segments;
            int n = segments.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                sb.append(marker);
                sb.append(string);
                ++n2;
            }
            return sb.toString();
        }
    }
}

