/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.features.impl;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IRemoveFeature;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.context.impl.RemoveContext;
import org.eclipse.graphiti.features.impl.AbstractFeature;
import org.eclipse.graphiti.internal.Messages;
import org.eclipse.graphiti.internal.services.GraphitiInternal;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;

public class DefaultRemoveFeature
extends AbstractFeature
implements IRemoveFeature {
    private static final String NAME = Messages.DefaultRemoveFeature_0_xfld;

    public DefaultRemoveFeature(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    public boolean canRemove(IRemoveContext context) {
        return !(context.getPictogramElement() instanceof Diagram);
    }

    @Override
    public final void remove(IRemoveContext context) {
        if (!this.getUserDecision()) {
            return;
        }
        this.preRemove(context);
        PictogramElement pe = context.getPictogramElement();
        if (pe instanceof Shape) {
            Shape shape = (Shape)pe;
            this.removeAllConnections(shape);
        }
        Graphiti.getPeService().deletePictogramElement(pe);
        this.postRemove(context);
    }

    @Override
    public void preRemove(IRemoveContext context) {
    }

    protected void removeAllConnections(Shape shape) {
        IFeatureProvider featureProvider = this.getFeatureProvider();
        for (Anchor anchor : shape.getAnchors()) {
            for (Connection connection : Graphiti.getPeService().getAllConnections(anchor)) {
                ConnectionDecorator[] decorators;
                RemoveContext rc;
                IRemoveFeature removeFeature;
                if (!GraphitiInternal.getEmfService().isObjectAlive((EObject)connection) || (removeFeature = featureProvider.getRemoveFeature(rc = new RemoveContext((PictogramElement)connection))) == null) continue;
                ConnectionDecorator[] connectionDecoratorArray = decorators = (ConnectionDecorator[])connection.getConnectionDecorators().toArray((Object[])new ConnectionDecorator[0]);
                int n = decorators.length;
                int n2 = 0;
                while (n2 < n) {
                    ConnectionDecorator decorator = connectionDecoratorArray[n2];
                    if (decorator != null && GraphitiInternal.getEmfService().isObjectAlive((EObject)decorator)) {
                        EcoreUtil.delete((EObject)decorator, (boolean)true);
                    }
                    ++n2;
                }
                removeFeature.remove(rc);
            }
        }
    }

    @Override
    public void postRemove(IRemoveContext context) {
    }

    @Override
    public boolean canExecute(IContext context) {
        boolean ret = false;
        if (context instanceof IRemoveContext) {
            ret = this.canRemove((IRemoveContext)context);
        }
        return ret;
    }

    @Override
    public void execute(IContext context) {
        if (context instanceof IRemoveContext) {
            this.remove((IRemoveContext)context);
        }
    }

    @Override
    public String getName() {
        return NAME;
    }
}

