/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.tb;

import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.internal.util.T;
import org.eclipse.graphiti.platform.IDiagramEditor;
import org.eclipse.graphiti.tb.IContextEntry;

public class AbstractContextEntry
implements IContextEntry {
    private IContext context;
    private IFeature feature;
    private String iconId;
    private String text;
    private String description;

    public AbstractContextEntry(IFeature feature, IContext context) {
        this.setFeature(feature);
        this.setContext(context);
        if (feature instanceof ICustomFeature) {
            this.setIconId(((ICustomFeature)feature).getImageId());
        }
    }

    @Override
    public boolean canExecute() {
        if (this.getFeature() == null) {
            return false;
        }
        return this.getFeature().canExecute(this.getContext());
    }

    @Override
    public void execute() {
        IDiagramEditor diagramEditor = this.getFeature().getFeatureProvider().getDiagramTypeProvider().getDiagramEditor();
        try {
            diagramEditor.executeFeature(this.getFeature(), this.getContext());
        }
        catch (Exception e) {
            if (e instanceof RollbackException) {
                T.racer().log(1, "GFCommandStack.execute(Command) " + e, e);
            }
            T.racer().error("GFCommandStack.execute(Command) " + e, e);
        }
    }

    @Override
    public IContext getContext() {
        return this.context;
    }

    @Override
    public IFeature getFeature() {
        return this.feature;
    }

    @Override
    public String getIconId() {
        return this.iconId;
    }

    @Override
    public String getText() {
        IFeature f;
        String ret = this.text;
        if (ret == null && (f = this.getFeature()) instanceof ICustomFeature) {
            ICustomFeature customFeature = (ICustomFeature)f;
            ret = customFeature.getName();
        }
        return ret;
    }

    @Override
    public String getDescription() {
        IFeature f;
        String ret = this.description;
        if (ret == null && (f = this.getFeature()) instanceof ICustomFeature) {
            ICustomFeature customFeature = (ICustomFeature)f;
            ret = customFeature.getDescription();
        }
        return ret;
    }

    private void setContext(IContext context) {
        this.context = context;
    }

    private void setFeature(IFeature feature) {
        this.feature = feature;
    }

    @Override
    public void setIconId(String iconId) {
        this.iconId = iconId;
    }

    @Override
    public void setText(String text) {
        this.text = text;
    }

    @Override
    public void setDescription(String text) {
        this.description = text;
    }
}

