/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.tb;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.graphiti.DiagramScrollingBehavior;
import org.eclipse.graphiti.IExecutionInfo;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IDoubleClickContext;
import org.eclipse.graphiti.features.context.IPictogramElementContext;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.internal.Messages;
import org.eclipse.graphiti.internal.datatypes.impl.LocationImpl;
import org.eclipse.graphiti.internal.util.T;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.styles.LineStyle;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.palette.IPaletteCompartmentEntry;
import org.eclipse.graphiti.palette.impl.ConnectionCreationToolEntry;
import org.eclipse.graphiti.palette.impl.ObjectCreationToolEntry;
import org.eclipse.graphiti.palette.impl.PaletteCompartmentEntry;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.tb.ContextEntryHelper;
import org.eclipse.graphiti.tb.ContextMenuEntry;
import org.eclipse.graphiti.tb.DefaultContextButtonPadData;
import org.eclipse.graphiti.tb.IContextButtonEntry;
import org.eclipse.graphiti.tb.IContextButtonPadData;
import org.eclipse.graphiti.tb.IContextMenuEntry;
import org.eclipse.graphiti.tb.IDecorator;
import org.eclipse.graphiti.tb.ISelectionInfo;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;
import org.eclipse.graphiti.tb.SelectionInfoImpl;
import org.eclipse.graphiti.util.IColorConstant;
import org.eclipse.graphiti.util.ILocationInfo;

public class DefaultToolBehaviorProvider
implements IToolBehaviorProvider {
    protected int THRESHOLD_FOR_LONG_RUNNING_OPERATION = 20;
    private static final IDecorator[] NO_RENDERING_DECORATORS = new IDecorator[0];
    private static double[] ZOOM_LEVELS = new double[]{0.01, 0.1, 0.2, 0.5, 0.75, 1.0, 1.5, 2.0, 2.5, 3.0, 4.0, 10.0};
    private static final String DIAGRAM_PROPERTY_CONTRIBUTOR_SUFFIX = ".PropertyContributor";
    protected static int CONTEXT_BUTTON_UPDATE = 2;
    protected static int CONTEXT_BUTTON_REMOVE = 4;
    protected static int CONTEXT_BUTTON_DELETE = 8;
    protected static final IContextMenuEntry[] NO_CONTEXT_MENU_ENTRIES = new IContextMenuEntry[0];
    private IDiagramTypeProvider diagramTypeProvider;

    public DefaultToolBehaviorProvider(IDiagramTypeProvider diagramTypeProvider) {
        this.setDiagramTypeProvider(diagramTypeProvider);
    }

    @Override
    public void dispose() {
    }

    @Override
    public Object getAdapter(Class<?> type) {
        return null;
    }

    @Override
    public PictogramElement getSelection(PictogramElement originalPe, PictogramElement[] oldSelection) {
        return null;
    }

    @Override
    public ISelectionInfo getSelectionInfoForConnection(Connection connection) {
        SelectionInfoImpl si = new SelectionInfoImpl(IColorConstant.CONNECTION_SELECTION_FG, IColorConstant.HANDLE_FG, IColorConstant.HANDLE_BG, LineStyle.DASH);
        return si;
    }

    @Override
    public IContextButtonPadData getContextButtonPad(IPictogramElementContext context) {
        String SIGNATURE = "getContextButtonPadData(IPictogramElementContext)";
        boolean info = T.racer().info();
        if (info) {
            T.racer().entering(DefaultToolBehaviorProvider.class, "getContextButtonPadData(IPictogramElementContext)", context);
        }
        DefaultContextButtonPadData ret = new DefaultContextButtonPadData();
        PictogramElement pe = context.getPictogramElement();
        GraphicsAlgorithm ga = this.getSelectionBorder(pe);
        if (ga == null) {
            ga = pe.getGraphicsAlgorithm();
        }
        if (ga != null) {
            ILocation origin = this.getAbsoluteLocation(ga);
            ret.getPadLocation().setRectangle(origin.getX(), origin.getY(), ga.getWidth(), ga.getHeight());
        }
        this.setGenericContextButtons(ret, pe, CONTEXT_BUTTON_DELETE | CONTEXT_BUTTON_REMOVE | CONTEXT_BUTTON_UPDATE);
        if (info) {
            T.racer().exiting(DefaultToolBehaviorProvider.class, "getContextButtonPadData(IPictogramElementContext)", ret);
        }
        return ret;
    }

    protected void setGenericContextButtons(IContextButtonPadData data, PictogramElement pe, int identifiers) {
        IContextButtonEntry deleteButton;
        IContextButtonEntry removeButton;
        IContextButtonEntry updateButton;
        data.getGenericContextButtons().clear();
        if ((identifiers & CONTEXT_BUTTON_UPDATE) != 0 && (updateButton = ContextEntryHelper.createDefaultUpdateContextButton(this.getFeatureProvider(), pe)) != null) {
            data.getGenericContextButtons().add(updateButton);
        }
        if ((identifiers & CONTEXT_BUTTON_REMOVE) != 0 && (removeButton = ContextEntryHelper.createDefaultRemoveContextButton(this.getFeatureProvider(), pe)) != null) {
            data.getGenericContextButtons().add(removeButton);
        }
        if ((identifiers & CONTEXT_BUTTON_DELETE) != 0 && (deleteButton = ContextEntryHelper.createDefaultDeleteContextButton(this.getFeatureProvider(), pe)) != null) {
            data.getGenericContextButtons().add(deleteButton);
        }
    }

    protected ILocation getAbsoluteLocation(PictogramElement pe) {
        return this.getAbsoluteLocation(pe.getGraphicsAlgorithm());
    }

    protected ILocation getAbsoluteLocation(GraphicsAlgorithm ga) {
        LocationImpl ret = new LocationImpl(0, 0);
        while (ga != null) {
            ret.setX(ret.getX() + ga.getX());
            ret.setY(ret.getY() + ga.getY());
            PictogramElement pe = ga.getPictogramElement();
            if (pe != null) {
                PictogramElement parent = Graphiti.getPeService().getPictogramElementParent(pe);
                if (parent != null) {
                    ga = parent.getGraphicsAlgorithm();
                    continue;
                }
                ga = null;
                continue;
            }
            ga = ga.getParentGraphicsAlgorithm();
        }
        return ret;
    }

    @Override
    public IContextMenuEntry[] getContextMenu(ICustomContext context) {
        String SIGNATURE = "getContextMenu(IContext)";
        boolean info = T.racer().info();
        if (info) {
            T.racer().entering(DefaultToolBehaviorProvider.class, "getContextMenu(IContext)", context);
        }
        IContextMenuEntry[] ret = NO_CONTEXT_MENU_ENTRIES;
        ArrayList<ContextMenuEntry> retList = new ArrayList<ContextMenuEntry>();
        ICustomFeature[] customFeatures = this.getFeatureProvider().getCustomFeatures(context);
        int i = 0;
        while (i < customFeatures.length) {
            ICustomFeature customFeature = customFeatures[i];
            retList.add(new ContextMenuEntry(customFeature, context));
            ++i;
        }
        ret = retList.toArray(NO_CONTEXT_MENU_ENTRIES);
        if (info) {
            T.racer().exiting(DefaultToolBehaviorProvider.class, "getContextMenu(IContext)", ret);
        }
        return ret;
    }

    @Override
    public ILocationInfo getLocationInfo(PictogramElement pe, ILocationInfo locationInfo) {
        return locationInfo;
    }

    @Override
    public ICustomFeature getDoubleClickFeature(IDoubleClickContext context) {
        return null;
    }

    @Override
    public IPaletteCompartmentEntry[] getPalette() {
        ICreateFeature[] createFeatures;
        int n;
        String SIGNATURE = "getPaletteCompartments()";
        boolean info = T.racer().info();
        if (info) {
            T.racer().entering(DefaultToolBehaviorProvider.class, "getPaletteCompartments()", new Object[0]);
        }
        ArrayList<PaletteCompartmentEntry> compartments = new ArrayList<PaletteCompartmentEntry>();
        PaletteCompartmentEntry compartmentEntry = new PaletteCompartmentEntry(Messages.DefaultToolBehaviorProvider_0_xfld, null);
        compartments.add(compartmentEntry);
        IFeatureProvider featureProvider = this.getFeatureProvider();
        ICreateConnectionFeature[] createConnectionFeatures = featureProvider.getCreateConnectionFeatures();
        if (createConnectionFeatures.length > 0) {
            ICreateConnectionFeature[] iCreateConnectionFeatureArray = createConnectionFeatures;
            n = createConnectionFeatures.length;
            int n2 = 0;
            while (n2 < n) {
                ICreateConnectionFeature createConnectionFeature = iCreateConnectionFeatureArray[n2];
                ConnectionCreationToolEntry ccTool = new ConnectionCreationToolEntry(createConnectionFeature.getCreateName(), createConnectionFeature.getCreateDescription(), createConnectionFeature.getCreateImageId(), createConnectionFeature.getCreateLargeImageId());
                ccTool.addCreateConnectionFeature(createConnectionFeature);
                compartmentEntry.addToolEntry(ccTool);
                ++n2;
            }
        }
        compartmentEntry = new PaletteCompartmentEntry(Messages.DefaultToolBehaviorProvider_1_xfld, null);
        compartments.add(compartmentEntry);
        ICreateFeature[] iCreateFeatureArray = createFeatures = featureProvider.getCreateFeatures();
        int n3 = createFeatures.length;
        n = 0;
        while (n < n3) {
            ICreateFeature createFeature = iCreateFeatureArray[n];
            ObjectCreationToolEntry objectCreationToolEntry = new ObjectCreationToolEntry(createFeature.getCreateName(), createFeature.getCreateDescription(), createFeature.getCreateImageId(), createFeature.getCreateLargeImageId(), createFeature);
            compartmentEntry.addToolEntry(objectCreationToolEntry);
            ++n;
        }
        IPaletteCompartmentEntry[] res = compartments.toArray(new IPaletteCompartmentEntry[compartments.size()]);
        if (info) {
            T.racer().exiting(DefaultToolBehaviorProvider.class, "getPaletteCompartments()", res);
        }
        return res;
    }

    @Override
    public IDecorator[] getDecorators(PictogramElement pe) {
        return NO_RENDERING_DECORATORS;
    }

    @Override
    public ISelectionInfo getSelectionInfoForShape(Shape shape) {
        SelectionInfoImpl si = new SelectionInfoImpl(IColorConstant.SHAPE_SELECTION_FG, IColorConstant.HANDLE_FG, IColorConstant.HANDLE_BG, LineStyle.DASH);
        return si;
    }

    @Override
    public double[] getZoomLevels() {
        return ZOOM_LEVELS;
    }

    @Override
    @Deprecated
    public DiagramScrollingBehavior getDiagramScrollingBehavior() {
        return DiagramScrollingBehavior.GEF_DEFAULT;
    }

    private void setDiagramTypeProvider(IDiagramTypeProvider diagramTypeProvider) {
        this.diagramTypeProvider = diagramTypeProvider;
    }

    protected IDiagramTypeProvider getDiagramTypeProvider() {
        return this.diagramTypeProvider;
    }

    protected IFeatureProvider getFeatureProvider() {
        return this.getDiagramTypeProvider().getFeatureProvider();
    }

    @Override
    public void preExecute(IExecutionInfo executionInfo) {
    }

    @Override
    public void postExecute(IExecutionInfo executionInfo) {
    }

    @Override
    public String getToolTip(GraphicsAlgorithm ga) {
        return null;
    }

    @Override
    public GraphicsAlgorithm getSelectionBorder(PictogramElement pe) {
        return null;
    }

    @Override
    public GraphicsAlgorithm[] getClickArea(PictogramElement pe) {
        GraphicsAlgorithm graphicsAlgorithm = pe.getGraphicsAlgorithm();
        if (graphicsAlgorithm != null) {
            return new GraphicsAlgorithm[]{graphicsAlgorithm};
        }
        return new GraphicsAlgorithm[0];
    }

    @Override
    public GraphicsAlgorithm getChopboxAnchorArea(PictogramElement pe) {
        return pe.getGraphicsAlgorithm();
    }

    @Override
    public String getTitleToolTip() {
        return null;
    }

    @Override
    public boolean isShowGuides() {
        return true;
    }

    @Override
    public GraphicsAlgorithm getContentArea(ContainerShape cs) {
        return null;
    }

    @Override
    public String getContributorId() {
        String diagramTypeId = this.getDiagramTypeProvider().getDiagram().getDiagramTypeId();
        return String.valueOf(diagramTypeId) + DIAGRAM_PROPERTY_CONTRIBUTOR_SUFFIX;
    }

    public boolean isDefaultBendPointRenderingActive() {
        return true;
    }

    @Override
    public boolean isMultiSelectionEnabled() {
        return true;
    }

    @Override
    public boolean isConnectionSelectionEnabled() {
        return true;
    }

    @Override
    public boolean equalsBusinessObjects(Object o1, Object o2) {
        if (o1 instanceof EObject && o2 instanceof EObject) {
            return EcoreUtil.equals((EObject)((EObject)o1), (EObject)((EObject)o2));
        }
        return false;
    }

    @Override
    public boolean isShowFlyoutPalette() {
        return true;
    }
}

