/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.action;

import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.ui.actions.PrintAction;
import org.eclipse.graphiti.features.IPrintFeature;
import org.eclipse.graphiti.features.context.IPrintContext;
import org.eclipse.graphiti.features.context.impl.PrintContext;
import org.eclipse.graphiti.ui.internal.services.GraphitiUiInternal;
import org.eclipse.graphiti.ui.internal.util.ui.print.PrintFigureDialog;
import org.eclipse.graphiti.ui.internal.util.ui.print.PrintFigureScaleableOperation;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class PrintGraphicalViewerAction
extends PrintAction {
    private static IAction TEMPLATE_ACTION = ActionFactory.PRINT.create(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
    private IPrintFeature printFeature;
    private long lastPrinterCheckTime = 0L;
    private boolean cachedEnabled = true;

    public PrintGraphicalViewerAction(IWorkbenchPart part, IPrintFeature printFeature) {
        super(part);
        this.printFeature = printFeature;
        this.setId(TEMPLATE_ACTION.getId());
        this.setText(TEMPLATE_ACTION.getText());
        this.setToolTipText(TEMPLATE_ACTION.getToolTipText());
        this.setDescription(TEMPLATE_ACTION.getDescription());
        this.setAccelerator(TEMPLATE_ACTION.getAccelerator());
        this.setHelpListener(TEMPLATE_ACTION.getHelpListener());
        this.setImageDescriptor(TEMPLATE_ACTION.getImageDescriptor());
        this.setHoverImageDescriptor(TEMPLATE_ACTION.getHoverImageDescriptor());
        this.setDisabledImageDescriptor(TEMPLATE_ACTION.getDisabledImageDescriptor());
    }

    protected boolean calculateEnabled() {
        if (this.getWorkbenchPart().getAdapter(GraphicalViewer.class) == null) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        long diffTime = (currentTime - this.lastPrinterCheckTime) / 1000L;
        if (diffTime > 300L) {
            this.lastPrinterCheckTime = currentTime;
            this.cachedEnabled = super.calculateEnabled();
        }
        return this.cachedEnabled;
    }

    public void run() {
        PrintContext printContext = new PrintContext();
        this.printFeature.prePrint((IPrintContext)printContext);
        Shell shell = GraphitiUiInternal.getWorkbenchService().getShell();
        GraphicalViewer viewer = (GraphicalViewer)this.getWorkbenchPart().getAdapter(GraphicalViewer.class);
        PrinterData printerData = Printer.getDefaultPrinterData();
        if (printerData == null || printerData.name == null && printerData.driver == null) {
            printerData = Printer.getPrinterList()[0];
        }
        PrintFigureDialog printImageDialog = new PrintFigureDialog(shell, viewer, new Printer(printerData));
        printImageDialog.open();
        if (printImageDialog.getReturnCode() != 1) {
            PrintFigureScaleableOperation op = new PrintFigureScaleableOperation(printImageDialog.getPrinter(), printImageDialog.getFigure(), printImageDialog.getScaledImage(), printImageDialog.getPreferences());
            op.run(this.getWorkbenchPart().getTitle());
            printImageDialog.cleanUp();
        }
        this.printFeature.postPrint((IPrintContext)printContext);
    }
}

