/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.parts.directedit;

import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.ZoomListener;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.graphiti.features.IDirectEditingFeature;
import org.eclipse.graphiti.features.context.IDirectEditingContext;
import org.eclipse.graphiti.func.IProposal;
import org.eclipse.graphiti.func.Proposal;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.graphiti.ui.internal.figures.GFMultilineText;
import org.eclipse.graphiti.ui.internal.figures.GFText;
import org.eclipse.graphiti.ui.internal.parts.ShapeEditPart;
import org.eclipse.graphiti.ui.internal.parts.directedit.ContentProposalListener;
import org.eclipse.graphiti.ui.internal.parts.directedit.ContentProposalProvider;
import org.eclipse.graphiti.ui.internal.parts.directedit.GFCellEditorValidator;
import org.eclipse.graphiti.ui.internal.parts.directedit.IDirectEditHolder;
import org.eclipse.graphiti.ui.internal.parts.directedit.TextCellEditor;
import org.eclipse.graphiti.ui.internal.parts.directedit.TextCellLocator;
import org.eclipse.graphiti.ui.internal.requests.GFDirectEditRequest;
import org.eclipse.graphiti.ui.internal.services.GraphitiUiInternal;
import org.eclipse.graphiti.ui.platform.ICellEditorProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.CellEditorActionHandler;

public class GFDirectEditManager
extends DirectEditManager
implements IDirectEditHolder {
    private IDirectEditingContext directEditingContext;
    private IDirectEditingFeature directEditingFeature;
    private TextCellLocator locator;
    private DiagramEditor diagramEditor;
    private Font cellEditorFont = null;
    private IActionBars actionBars;
    private CellEditorActionHandler actionHandler;
    private IAction copy;
    private IAction cut;
    private IAction paste;
    private IAction undo;
    private IAction redo;
    private IAction find;
    private IAction selectAll;
    private IAction delete;
    private double cachedZoom = -1.0;
    private ZoomListener zoomListener = new ZoomListener(){

        public void zoomChanged(double newZoom) {
            GFDirectEditManager.this.updateScaledFont();
        }
    };

    public GFDirectEditManager(ShapeEditPart part, TextCellLocator cellEditorLocator) {
        super((GraphicalEditPart)part, null, (CellEditorLocator)cellEditorLocator);
        this.locator = cellEditorLocator;
        this.diagramEditor = part.getConfigurationProvider().getDiagramEditor();
    }

    public IDirectEditingContext getDirectEditingContext() {
        return this.directEditingContext;
    }

    public IDirectEditingFeature getDirectEditingFeature() {
        return this.directEditingFeature;
    }

    public void setDirectEditingContext(IDirectEditingContext directEditingContext) {
        this.directEditingContext = directEditingContext;
    }

    public void setDirectEditingFeature(IDirectEditingFeature directEditingFeature) {
        this.directEditingFeature = directEditingFeature;
    }

    public boolean isSimpleMode() {
        boolean ret = true;
        if (this.getDirectEditingFeature() != null && this.getDirectEditingFeature().getProposalSupport() != null) {
            ret = false;
        }
        return ret;
    }

    protected CellEditor createCellEditorOn(Composite composite) {
        TextCellEditor ret = null;
        IFigure locatorFigure = this.locator.getFigure();
        int editingType = this.directEditingFeature.getEditingType();
        if (editingType == 5) {
            int horizontalAlignment = 16384;
            if (locatorFigure instanceof GFMultilineText) {
                int textAlignment = ((GFMultilineText)locatorFigure).getHorizontalAligment();
                if (textAlignment == 2) {
                    horizontalAlignment = 0x1000000;
                } else if (textAlignment == 4) {
                    horizontalAlignment = 131072;
                }
            }
            ret = new TextCellEditor(composite, 0x42 | horizontalAlignment);
        } else if (editingType == 1) {
            int horizontalAlignment = 16384;
            if (locatorFigure instanceof GFText) {
                int textAlignment = ((GFText)locatorFigure).getLabelAlignment();
                if (textAlignment == 2) {
                    horizontalAlignment = 0x1000000;
                } else if (textAlignment == 4) {
                    horizontalAlignment = 131072;
                }
            }
            ret = new TextCellEditor(composite, horizontalAlignment);
        } else if (this.directEditingFeature.getEditingType() == 3 || this.directEditingFeature.getEditingType() == 6) {
            String[] possibleValues = this.getPossibleValues();
            ret = new ComboBoxCellEditor(composite, possibleValues);
        } else if (editingType == 9) {
            if (this.directEditingFeature instanceof ICellEditorProvider) {
                ret = ((ICellEditorProvider)this.directEditingFeature).createCellEditor(composite);
            } else {
                throw new UnsupportedOperationException("if custom type the feature must implement ICellEditorProvider");
            }
        }
        if (ret != null && editingType != 9) {
            ret.setValidator(new GFCellEditorValidator(this, (CellEditor)ret));
        }
        return ret;
    }

    private String[] getPossibleValues() {
        String[] possibleValues;
        if (this.isSimpleMode()) {
            possibleValues = this.directEditingFeature.getPossibleValues(this.directEditingContext);
        } else {
            IProposal[] proposals = this.directEditingFeature.getProposalSupport().getPossibleValues(this.directEditingContext);
            possibleValues = Proposal.proposalsToTexts((IProposal[])proposals);
        }
        return possibleValues;
    }

    private void disposeCellEditorFont() {
        if (this.cellEditorFont != null) {
            this.cellEditorFont.dispose();
            this.cellEditorFont = null;
        }
    }

    private void updateScaledFont() {
        if (this.getCellEditor().getControl() instanceof Text) {
            double zoom = 1.0;
            ZoomManager zoomMgr = (ZoomManager)this.getEditPart().getViewer().getProperty(ZoomManager.class.toString());
            if (zoomMgr != null) {
                zoom = zoomMgr.getZoom();
            }
            if (this.cachedZoom == zoom) {
                return;
            }
            this.cachedZoom = zoom;
            this.disposeCellEditorFont();
            Font lf = this.locator.getFigure().getFont();
            FontData fd = lf.getFontData()[0];
            fd.setHeight((int)((double)fd.getHeight() * zoom));
            this.cellEditorFont = new Font(lf.getDevice(), fd);
            Text text = (Text)this.getCellEditor().getControl();
            text.setForeground(this.locator.getFigure().getForegroundColor());
            text.setFont(this.cellEditorFont);
        }
    }

    protected DirectEditRequest createDirectEditRequest() {
        GFDirectEditRequest req = new GFDirectEditRequest();
        req.setCellEditor(this.getCellEditor());
        req.setDirectEditingContext(this);
        return req;
    }

    protected void initCellEditor() {
        String initialValue = this.directEditingFeature.getInitialValue(this.directEditingContext);
        if (this.directEditingFeature.getEditingType() == 5) {
            if (initialValue != null) {
                this.getCellEditor().setValue((Object)initialValue);
            }
        } else if (this.directEditingFeature.getEditingType() == 3 || this.directEditingFeature.getEditingType() == 6) {
            ComboBoxCellEditor comboBoxCellEditor = (ComboBoxCellEditor)this.getCellEditor();
            this.setDirty(true);
            if (this.directEditingFeature.getEditingType() == 6) {
                CCombo cc = (CCombo)comboBoxCellEditor.getControl();
                cc.setEditable(false);
            }
            String[] possibleValues = this.getPossibleValues();
            comboBoxCellEditor.setValue((Object)0);
            int x = 0;
            while (x < possibleValues.length) {
                if (possibleValues[x].equals(initialValue)) {
                    comboBoxCellEditor.setValue((Object)x);
                }
                ++x;
            }
        } else if (this.directEditingFeature.getEditingType() == 1) {
            if (initialValue != null) {
                this.getCellEditor().setValue((Object)initialValue);
            }
            if (this.directEditingFeature.isCompletionAvailable()) {
                String value = (String)this.getCellEditor().getValue();
                if (value == null) {
                    value = "";
                }
                TextContentAdapter controlContentAdapter = new TextContentAdapter();
                ContentProposalProvider contentProposalProvider = new ContentProposalProvider(this);
                KeyStroke keyStroke = this.directEditingFeature.isAutoCompletionEnabled() ? null : KeyStroke.getInstance((int)262144, (int)32);
                ContentProposalAdapter contentProposalAdapter = new ContentProposalAdapter(this.getCellEditor().getControl(), (IControlContentAdapter)controlContentAdapter, (IContentProposalProvider)contentProposalProvider, keyStroke, null);
                contentProposalAdapter.setProposalAcceptanceStyle(2);
                contentProposalAdapter.addContentProposalListener((IContentProposalListener)new ContentProposalListener((TextCellEditor)this.getCellEditor()));
            }
        } else if (this.directEditingFeature.getEditingType() == 9) {
            this.setDirty(true);
            this.getCellEditor().setValue((Object)initialValue);
        }
        this.cachedZoom = -1.0;
        this.updateScaledFont();
        ZoomManager zoomMgr = (ZoomManager)this.getEditPart().getViewer().getProperty(ZoomManager.class.toString());
        if (zoomMgr != null) {
            zoomMgr.addZoomListener(this.zoomListener);
        }
        this.locator.relocate(this.getCellEditor());
        this.actionBars = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorSite().getActionBars();
        this.saveCurrentActions(this.actionBars);
        this.actionHandler = new CellEditorActionHandler(this.actionBars);
        this.actionHandler.addCellEditor(this.getCellEditor());
        this.actionBars.updateActionBars();
    }

    protected void bringDown() {
        this.diagramEditor.setDirectEditingActive(false);
        ZoomManager zoomMgr = (ZoomManager)this.getEditPart().getViewer().getProperty(ZoomManager.class.toString());
        if (zoomMgr != null) {
            zoomMgr.removeZoomListener(this.zoomListener);
        }
        if (this.actionHandler != null) {
            this.actionHandler.dispose();
            this.actionHandler = null;
        }
        if (this.actionBars != null) {
            this.restoreSavedActions(this.actionBars);
            this.actionBars.updateActionBars();
            this.actionBars = null;
        }
        if (this.diagramEditor.isAlive()) {
            super.bringDown();
            this.disposeCellEditorFont();
            GraphitiUiInternal.getWorkbenchService().getActiveStatusLineManager().setErrorMessage(null);
        }
        ((ShapeEditPart)this.getEditPart()).delayDirectEditing();
    }

    public void show() {
        this.diagramEditor.setDirectEditingActive(true);
        super.show();
        this.locator.relocate(this.getCellEditor());
    }

    private void restoreSavedActions(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), this.copy);
        actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), this.paste);
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), this.delete);
        actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), this.selectAll);
        actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), this.cut);
        actionBars.setGlobalActionHandler(ActionFactory.FIND.getId(), this.find);
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), this.undo);
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), this.redo);
    }

    private void saveCurrentActions(IActionBars actionBars) {
        this.copy = actionBars.getGlobalActionHandler(ActionFactory.COPY.getId());
        this.paste = actionBars.getGlobalActionHandler(ActionFactory.PASTE.getId());
        this.delete = actionBars.getGlobalActionHandler(ActionFactory.DELETE.getId());
        this.selectAll = actionBars.getGlobalActionHandler(ActionFactory.SELECT_ALL.getId());
        this.cut = actionBars.getGlobalActionHandler(ActionFactory.CUT.getId());
        this.find = actionBars.getGlobalActionHandler(ActionFactory.FIND.getId());
        this.undo = actionBars.getGlobalActionHandler(ActionFactory.UNDO.getId());
        this.redo = actionBars.getGlobalActionHandler(ActionFactory.REDO.getId());
    }
}

