/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.util.draw2d;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.graphiti.internal.util.LookManager;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.styles.Color;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.graphiti.ui.internal.config.IConfigurationProvider;
import org.eclipse.graphiti.ui.internal.util.DataTypeTransformation;
import org.eclipse.graphiti.util.ILook;

public class GridLayer
extends org.eclipse.gef.editparts.GridLayer {
    private IConfigurationProvider cfgProvider;

    public GridLayer(IConfigurationProvider cfgProvider) {
        this.setCfgProvider(cfgProvider);
        this.updateFromDiagram();
    }

    protected void paintGrid(Graphics g) {
        int i;
        Rectangle clip = g.getClip(Rectangle.SINGLETON);
        Diagram diagram = this.getDiagram();
        if (diagram == null) {
            return;
        }
        GraphicsAlgorithm graphicsAlgorithm = diagram.getGraphicsAlgorithm();
        Color background = Graphiti.getGaService().getBackgroundColor(graphicsAlgorithm, true);
        if (background.getBlue() != this.getBackgroundColor().getBlue() || background.getRed() != this.getBackgroundColor().getRed() || background.getGreen() != this.getBackgroundColor().getGreen()) {
            this.updateFromDiagram();
        }
        org.eclipse.swt.graphics.Color majorLineColor = this.getMajorLineColor();
        org.eclipse.swt.graphics.Color minorLineColor = this.getMinorLineColor();
        this.gridX = diagram.getGridUnit();
        this.gridY = diagram.getVerticalGridUnit();
        if (this.gridY == -1) {
            this.gridY = this.gridX;
        }
        g.setBackgroundColor(this.getBackgroundColor());
        g.fillRectangle(clip);
        if (this.gridX > 0) {
            i = clip.x;
            while (i % this.gridX != 0) {
                ++i;
            }
            while (i < clip.x + clip.width) {
                this.prepareG(g, majorLineColor, minorLineColor, i, this.gridX);
                g.drawLine(i, clip.y, i, clip.y + clip.height);
                i += this.gridX;
            }
        }
        if (this.gridY > 0) {
            i = clip.y;
            while (i % this.gridY != 0) {
                ++i;
            }
            while (i < clip.y + clip.height) {
                this.prepareG(g, majorLineColor, minorLineColor, i, this.gridY);
                g.drawLine(clip.x, i, clip.x + clip.width, i);
                i += this.gridY;
            }
        }
    }

    private void prepareG(Graphics g, org.eclipse.swt.graphics.Color gridColor, org.eclipse.swt.graphics.Color gridColorLight, int gridPosition, int gridSize) {
        int p = this.getGridLineAlternation() * gridSize;
        if (gridPosition % p == 0) {
            g.setForegroundColor(gridColor);
        } else {
            g.setForegroundColor(gridColorLight);
        }
    }

    private Diagram getDiagram() {
        return this.getCfgProvider().getDiagram();
    }

    private void updateFromDiagram() {
        GraphicsAlgorithm diagramGa = this.getDiagram().getGraphicsAlgorithm();
        Color background = Graphiti.getGaService().getBackgroundColor(diagramGa, true);
        this.setBackgroundColor(DataTypeTransformation.toSwtColor(this.cfgProvider.getResourceRegistry(), background));
        Color foreground = Graphiti.getGaService().getForegroundColor(diagramGa, true);
        this.setForegroundColor(DataTypeTransformation.toSwtColor(this.cfgProvider.getResourceRegistry(), foreground));
    }

    private int getGridLineAlternation() {
        ILook look = LookManager.getLook();
        int i = look.getMajorGridLineDistance() / look.getMinorGridLineDistance();
        return Math.max(1, i);
    }

    private org.eclipse.swt.graphics.Color getMinorLineColor() {
        Color foregroundColor = null;
        Diagram diagram = this.getDiagram();
        if (diagram != null) {
            GraphicsAlgorithm diagramGa = diagram.getGraphicsAlgorithm();
            foregroundColor = Graphiti.getGaService().getForegroundColor(diagramGa, true);
        }
        if (foregroundColor == null) {
            return DataTypeTransformation.toSwtColor(this.cfgProvider.getResourceRegistry(), LookManager.getLook().getMinorGridLineColor());
        }
        return DataTypeTransformation.toSwtColor(this.cfgProvider.getResourceRegistry(), foregroundColor);
    }

    private org.eclipse.swt.graphics.Color getMajorLineColor() {
        return DataTypeTransformation.toSwtColor(this.cfgProvider.getResourceRegistry(), LookManager.getLook().getMajorGridLineColor());
    }

    private DiagramEditor getDiagramEditor() {
        return this.getCfgProvider().getDiagramEditor();
    }

    private IConfigurationProvider getCfgProvider() {
        return this.cfgProvider;
    }

    private void setCfgProvider(IConfigurationProvider cfgProvider) {
        this.cfgProvider = cfgProvider;
    }
}

