/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.editor;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.graphiti.ui.internal.T;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;

public final class ElementDeleteListener
extends AdapterImpl {
    private DiagramEditor diagramEditor;

    public ElementDeleteListener(DiagramEditor d) {
        this.diagramEditor = d;
    }

    public boolean isAdapterForType(Object type) {
        return type instanceof EObject;
    }

    public void notifyChanged(Notification msg) {
        IEditorInput in;
        if (T.racer().debug()) {
            String editorName = this.diagramEditor.getTitle();
            T.racer().debug("Delete listener called of editor " + editorName + " with events " + msg.toString());
        }
        if ((in = this.diagramEditor.getEditorInput()) != null) {
            final IEditorSite site = this.diagramEditor.getEditorSite();
            if (site == null) {
                return;
            }
            final Shell shell = site.getShell();
            shell.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (ElementDeleteListener.this.diagramEditor == null) {
                        return;
                    }
                    if (shell.isDisposed()) {
                        return;
                    }
                    Diagram diagram = null;
                    try {
                        diagram = (Diagram)ElementDeleteListener.this.diagramEditor.getAdapter(Diagram.class);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (diagram == null || EcoreUtil.getRootContainer(diagram) == null) {
                        IWorkbenchPage page = site.getPage();
                        if (T.racer().debug()) {
                            String editorName = ElementDeleteListener.this.diagramEditor.getTitle();
                            T.racer().debug("Closing editor " + editorName);
                        }
                        page.closeEditor((IEditorPart)ElementDeleteListener.this.diagramEditor, false);
                    }
                }
            });
        }
    }
}

