/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.action;

import org.eclipse.graphiti.features.ICopyFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ICopyContext;
import org.eclipse.graphiti.features.context.impl.CopyContext;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.internal.Messages;
import org.eclipse.graphiti.ui.internal.action.AbstractPreDefinedAction;
import org.eclipse.graphiti.ui.internal.config.IConfigurationProvider;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;

public class CopyAction
extends AbstractPreDefinedAction {
    private static final String TOOL_TIP = Messages.CopyAction_0_xmsg;
    private static final String TEXT = Messages.CopyAction_1_xfld;
    public static final String ACTION_ID = ActionFactory.COPY.getId();

    public CopyAction(IWorkbenchPart part, IConfigurationProvider configurationProvider) {
        super(part, configurationProvider);
        this.setId(ACTION_ID);
        this.setText(TEXT);
        this.setToolTipText(TOOL_TIP);
    }

    public boolean isAvailable() {
        PictogramElement[] pes = this.getSelectedPictogramElements();
        CopyContext context = new CopyContext(pes);
        ICopyFeature feature = this.getFeatureProvider().getCopyFeature((ICopyContext)context);
        return feature != null;
    }

    protected boolean calculateEnabled() {
        PictogramElement[] pes = this.getSelectedPictogramElements();
        if (pes.length == 0) {
            return false;
        }
        CopyContext context = new CopyContext(pes);
        IFeatureProvider featureProvider = this.getFeatureProvider();
        if (featureProvider == null) {
            return false;
        }
        ICopyFeature feature = featureProvider.getCopyFeature((ICopyContext)context);
        return feature != null && feature.canCopy((ICopyContext)context);
    }

    public void run() {
        PictogramElement[] pes = this.getSelectedPictogramElements();
        CopyContext context = new CopyContext(pes);
        ICopyFeature copyFeature = this.getFeatureProvider().getCopyFeature((ICopyContext)context);
        if (copyFeature != null) {
            copyFeature.copy((ICopyContext)context);
        }
    }
}

