/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.ScaledGraphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.internal.services.GraphitiInternal;
import org.eclipse.graphiti.mm.algorithms.AbstractText;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.internal.parts.IPictogramElementDelegate;
import org.eclipse.swt.graphics.Font;

public class GFText
extends Label {
    private GraphicsAlgorithm graphicsAlgorithm;
    private int labelAlignment = 2;
    private String subStringText;
    private Dimension myPrefSize;

    public GFText(IPictogramElementDelegate pictogramElementDelegate, GraphicsAlgorithm graphicsAlgorithm) {
        this.graphicsAlgorithm = graphicsAlgorithm;
    }

    public int getLabelAlignment() {
        return this.labelAlignment;
    }

    public void paintFigure(Graphics graphics) {
        if (this.graphicsAlgorithm != null && GraphitiInternal.getEmfService().isObjectAlive((EObject)this.graphicsAlgorithm)) {
            double transparency = Graphiti.getGaService().getTransparency(this.graphicsAlgorithm, true);
            int alpha = (int)((1.0 - transparency) * 255.0);
            graphics.setAlpha(alpha);
            if (graphics instanceof ScaledGraphics) {
                graphics.setTextAntialias(1);
            }
            int angle = 0;
            if (this.graphicsAlgorithm instanceof Text) {
                Text textGa = (Text)this.graphicsAlgorithm;
                angle = Graphiti.getGaService().getAngle((AbstractText)textGa, true);
            }
            if (angle != 0) {
                Rectangle rect = new Rectangle();
                graphics.getClip(rect);
                graphics.pushState();
                Rectangle bounds = this.getBounds();
                int w = bounds.width;
                int h = bounds.height;
                bounds.height = w;
                bounds.width = h;
                graphics.translate(bounds.x, bounds.y + h);
                graphics.rotate((float)angle);
                rect = new Rectangle(0, 0, 1000, 1000);
                graphics.setClip(rect);
                graphics.drawText(this.getSubStringText(), this.getTextLocation());
                bounds.height = h;
                bounds.width = w;
                graphics.popState();
                return;
            }
        }
        super.paintFigure(graphics);
    }

    public void setLabelAlignment(int align) {
        super.setLabelAlignment(align);
        this.labelAlignment = align;
    }

    public String getSubStringText() {
        if (this.subStringText != null) {
            return this.subStringText;
        }
        this.subStringText = this.getText();
        int widthShrink = this.getPreferredSizeWithoutChilds().width - this.getSize().width;
        if (widthShrink <= 0) {
            return this.subStringText;
        }
        Dimension effectiveSize = this.getTextSize().getExpanded(-widthShrink, 0);
        Font currentFont = this.getFont();
        int dotsWidth = this.getTextUtilities().getTextExtents((String)this.getTruncationString(), (Font)currentFont).width;
        if (effectiveSize.width < dotsWidth) {
            effectiveSize.width = dotsWidth;
        }
        int subStringLength = this.getTextUtilities().getLargestSubstringConfinedTo(this.getText(), currentFont, effectiveSize.width - dotsWidth);
        this.subStringText = new String(String.valueOf(this.getText().substring(0, subStringLength)) + this.getTruncationString());
        return this.subStringText;
    }

    protected Dimension getPreferredSizeWithoutChilds() {
        if (this.myPrefSize == null) {
            this.myPrefSize = this.calculateLabelSize(this.getTextSize());
            Insets insets = this.getInsets();
            this.myPrefSize.expand(insets.getWidth(), insets.getHeight());
        }
        return this.myPrefSize;
    }

    public void invalidate() {
        this.subStringText = null;
        this.myPrefSize = null;
        super.invalidate();
    }
}

