/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.graphiti.mm.algorithms.MultiText;

public class GFTextFlow
extends TextFlow {
    private MultiText multiText;

    public GFTextFlow(MultiText multiText) {
        this.multiText = multiText;
    }

    public void paint(Graphics graphics) {
        if (this.multiText.getAngle() != 0) {
            if (this.getLocalBackgroundColor() != null) {
                graphics.setBackgroundColor(this.getLocalBackgroundColor());
            }
            if (this.getLocalForegroundColor() != null) {
                graphics.setForegroundColor(this.getLocalForegroundColor());
            }
            if (this.getLocalFont() != null) {
                graphics.setFont(this.getLocalFont());
            }
            graphics.pushState();
            try {
                Rectangle flowPageFigureBounds = this.getParent().getBounds();
                Rectangle multiTextBounds = this.getParent().getParent().getBounds();
                Point clipLocation = new Point(multiTextBounds.x - flowPageFigureBounds.x, multiTextBounds.y - flowPageFigureBounds.y);
                Rectangle clip = new Rectangle(clipLocation, multiTextBounds.getSize());
                graphics.setClip(clip);
                this.paintFigure(graphics);
                graphics.restoreState();
                this.paintClientArea(graphics);
                this.paintBorder(graphics);
            }
            finally {
                graphics.popState();
            }
        } else {
            super.paint(graphics);
        }
    }

    protected void paintText(Graphics g, String draw, int x, int y, int bidiLevel) {
        if (bidiLevel == -1 && this.multiText.getAngle() != 0) {
            g.pushState();
            int xOff = this.getParent().getBounds().width() / 2;
            int yOff = this.getBounds().height() / 2;
            g.translate(xOff, yOff);
            g.rotate((float)this.multiText.getAngle().intValue());
            g.drawText(draw, x - xOff, y - yOff);
            g.popState();
        } else {
            super.paintText(g, draw, x, y, bidiLevel);
        }
    }
}

