/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.features.impl;

import org.eclipse.graphiti.datatypes.IDimension;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.ResizeShapeContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.features.impl.AbstractFeature;
import org.eclipse.graphiti.internal.Messages;
import org.eclipse.graphiti.internal.util.T;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;

public abstract class AbstractUpdateFeature
extends AbstractFeature
implements IUpdateFeature {
    private static final String NAME = Messages.AbstractUpdateFeature_2_xfld;

    public AbstractUpdateFeature(IFeatureProvider fp) {
        super(fp);
    }

    public final boolean canExecute(IContext context) {
        String SIGNATURE = Messages.AbstractUpdateFeature_0_xfld;
        boolean info = T.racer().info();
        if (info) {
            T.racer().entering(AbstractUpdateFeature.class, SIGNATURE, context);
        }
        boolean ret = false;
        if (context instanceof IUpdateContext) {
            IUpdateContext updateSemanticsContext = (IUpdateContext)context;
            ret = this.canUpdate(updateSemanticsContext);
        }
        if (info) {
            T.racer().exiting(AbstractUpdateFeature.class, SIGNATURE, ret);
        }
        return ret;
    }

    public void execute(IContext context) {
        String SIGNATURE = Messages.AbstractUpdateFeature_1_xfld;
        boolean info = T.racer().info();
        if (info) {
            T.racer().entering(AbstractUpdateFeature.class, SIGNATURE, context);
        }
        if (context instanceof IUpdateContext) {
            this.update((IUpdateContext)context);
        }
        if (info) {
            T.racer().exiting(AbstractUpdateFeature.class, SIGNATURE);
        }
    }

    protected boolean canUpdatePictogramElement(PictogramElement pe) {
        return this.getFeatureProvider().canUpdate(new UpdateContext(pe)).toBoolean();
    }

    protected IReason updatePictogramElementNeeded(PictogramElement pe) {
        return this.getFeatureProvider().updateNeeded(new UpdateContext(pe));
    }

    protected void updatePictogramElement(PictogramElement pe) {
        this.getFeatureProvider().updateIfPossible(new UpdateContext(pe));
    }

    protected void resizeShape(Shape shape) {
        ResizeShapeContext resizeShapeContext = new ResizeShapeContext(shape);
        GraphicsAlgorithm ga = shape.getGraphicsAlgorithm();
        IDimension gaSize = Graphiti.getGaService().calculateSize(ga, false);
        resizeShapeContext.setWidth(gaSize.getWidth());
        resizeShapeContext.setHeight(gaSize.getHeight());
        IResizeShapeFeature resizeShapeFeature = this.getFeatureProvider().getResizeShapeFeature(resizeShapeContext);
        if (resizeShapeFeature != null && resizeShapeFeature.canResizeShape(resizeShapeContext)) {
            resizeShapeFeature.resizeShape(resizeShapeContext);
        }
    }

    public String getName() {
        return NAME;
    }
}

