/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.features;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IPasteFeature;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.IPasteContext;
import org.eclipse.graphiti.features.impl.AbstractFeature;
import org.eclipse.graphiti.internal.Messages;
import org.eclipse.graphiti.ui.internal.util.clipboard.ModelClipboard;

public abstract class AbstractPasteFeature
extends AbstractFeature
implements IPasteFeature {
    private static final String NAME = Messages.AbstractPasteFeature_0_xfld;

    public AbstractPasteFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canExecute(IContext context) {
        boolean ret = false;
        if (context instanceof IPasteContext) {
            ret = this.canPaste((IPasteContext)context);
        }
        return ret;
    }

    public void execute(IContext context) {
        if (context instanceof IPasteContext) {
            this.paste((IPasteContext)context);
        }
    }

    public String getName() {
        return NAME;
    }

    protected Object[] getFromClipboard() {
        return ModelClipboard.getDefault().getContentAsEObjects(this.getDiagramEditor().getResourceSet());
    }

    protected Object[] getCopiesFromClipBoard(Object target) {
        return ModelClipboard.getDefault().duplicateAndPaste(target, this.getDiagramEditor().getEditingDomain()).toArray();
    }

    protected boolean isCompositionAllowed(EObject parent, EObject[] objects) {
        return ModelClipboard.getDefault().isCompositionAllowed(parent, objects);
    }

    protected boolean isResolvable(EObject object) {
        URI uri = EcoreUtil.getURI((EObject)object);
        EObject resolved = this.getDiagramEditor().getResourceSet().getEObject(uri, false);
        if (resolved == null) {
            resolved = this.getDiagramEditor().getResourceSet().getEObject(uri, true);
        }
        return resolved != null;
    }
}

