/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.editor;

import java.util.Map;
import java.util.Stack;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.workspace.impl.WorkspaceCommandStackImpl;
import org.eclipse.graphiti.IExecutionInfo;
import org.eclipse.graphiti.features.ICustomUndoableFeature;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureAndContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.internal.command.DefaultExecutionInfo;
import org.eclipse.graphiti.ui.internal.services.GraphitiUiInternal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GFWorkspaceCommandStackImpl
extends WorkspaceCommandStackImpl {
    private volatile boolean topLevelCommand = true;
    private Stack<IExecutionInfo> undoStackForExecutionInfo = new Stack();
    private Stack<IExecutionInfo> redoStackForExecutionInfo = new Stack();

    public GFWorkspaceCommandStackImpl(IOperationHistory history) {
        super(history);
    }

    public synchronized void execute(Command command, Map<?, ?> options) throws InterruptedException, RollbackException {
        Object object;
        IExecutionInfo executionInfo = null;
        if (options != null && (object = options.get("org.eclipse.graphiti.execution.info")) instanceof IExecutionInfo) {
            executionInfo = (IExecutionInfo)object;
            options.remove("org.eclipse.graphiti.execution.info");
        }
        if (this.topLevelCommand) {
            this.topLevelCommand = false;
            try {
                super.execute(command, options);
                if (executionInfo == null) {
                    executionInfo = new DefaultExecutionInfo();
                    GraphitiUiInternal.getCommandService().completeExecutionInfo((DefaultExecutionInfo)executionInfo, GraphitiUiInternal.getCommandService().transformFromEmfToGefCommand(command));
                }
                this.undoStackForExecutionInfo.push(executionInfo);
            }
            finally {
                this.topLevelCommand = true;
            }
        } else {
            command.execute();
            if (this.getMostRecentCommand() != null) {
                this.getMostRecentCommand().chain(command);
            }
        }
    }

    public void dispose() {
        super.dispose();
        this.redoStackForExecutionInfo.clear();
        this.redoStackForExecutionInfo = null;
        this.undoStackForExecutionInfo.clear();
        this.undoStackForExecutionInfo = null;
    }

    public void flush() {
        super.flush();
        this.undoStackForExecutionInfo.clear();
        this.redoStackForExecutionInfo.clear();
    }

    public void redo() {
        super.redo();
        if (!this.redoStackForExecutionInfo.isEmpty()) {
            IExecutionInfo ei = this.redoStackForExecutionInfo.pop();
            this.undoStackForExecutionInfo.push(ei);
            IFeatureAndContext[] executionList = ei.getExecutionList();
            int i = 0;
            while (i < executionList.length) {
                ICustomUndoableFeature undoableFeature;
                IFeature feature = executionList[i].getFeature();
                IContext context = executionList[i].getContext();
                if (feature instanceof ICustomUndoableFeature && (undoableFeature = (ICustomUndoableFeature)feature).canRedo(context)) {
                    undoableFeature.redo(context);
                }
                ++i;
            }
        }
    }

    public void undo() {
        super.undo();
        if (!this.undoStackForExecutionInfo.isEmpty()) {
            IExecutionInfo ei = this.undoStackForExecutionInfo.pop();
            this.redoStackForExecutionInfo.push(ei);
            IFeatureAndContext[] executionList = ei.getExecutionList();
            int i = executionList.length - 1;
            while (i >= 0) {
                ICustomUndoableFeature undoableFeature;
                IFeature feature = executionList[i].getFeature();
                IContext context = executionList[i].getContext();
                if (feature instanceof ICustomUndoableFeature && (undoableFeature = (ICustomUndoableFeature)feature).canUndo(context)) {
                    undoableFeature.undo(context);
                }
                --i;
            }
        }
    }
}

