/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.editor;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackEvent;
import org.eclipse.gef.commands.CommandStackEventListener;
import org.eclipse.gef.commands.CommandStackListener;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.editparts.GridLayer;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.AlignmentAction;
import org.eclipse.gef.ui.actions.DirectEditAction;
import org.eclipse.gef.ui.actions.MatchHeightAction;
import org.eclipse.gef.ui.actions.MatchWidthAction;
import org.eclipse.gef.ui.actions.ToggleGridAction;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.gef.ui.parts.GraphicalEditorWithFlyoutPalette;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.gef.ui.parts.SelectionSynchronizer;
import org.eclipse.graphiti.DiagramScrollingBehavior;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IPrintFeature;
import org.eclipse.graphiti.features.ISaveImageFeature;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ISaveImageContext;
import org.eclipse.graphiti.features.context.impl.SaveImageContext;
import org.eclipse.graphiti.internal.command.AddFeatureCommandWithContext;
import org.eclipse.graphiti.internal.command.GenericFeatureCommandWithContext;
import org.eclipse.graphiti.internal.command.ICommand;
import org.eclipse.graphiti.internal.services.GraphitiInternal;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.platform.IDiagramEditor;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;
import org.eclipse.graphiti.ui.editor.DefaultMarkerBehavior;
import org.eclipse.graphiti.ui.editor.DefaultPaletteBehavior;
import org.eclipse.graphiti.ui.editor.DefaultPersistencyBehavior;
import org.eclipse.graphiti.ui.editor.DefaultRefreshBehavior;
import org.eclipse.graphiti.ui.editor.DefaultUpdateBehavior;
import org.eclipse.graphiti.ui.editor.DiagramEditorContextMenuProvider;
import org.eclipse.graphiti.ui.editor.DiagramEditorInput;
import org.eclipse.graphiti.ui.editor.EditorInputAdapter;
import org.eclipse.graphiti.ui.editor.IDiagramEditorInput;
import org.eclipse.graphiti.ui.internal.action.CopyAction;
import org.eclipse.graphiti.ui.internal.action.DeleteAction;
import org.eclipse.graphiti.ui.internal.action.PasteAction;
import org.eclipse.graphiti.ui.internal.action.PrintGraphicalViewerAction;
import org.eclipse.graphiti.ui.internal.action.RemoveAction;
import org.eclipse.graphiti.ui.internal.action.SaveImageAction;
import org.eclipse.graphiti.ui.internal.action.ToggleContextButtonPadAction;
import org.eclipse.graphiti.ui.internal.action.UpdateAction;
import org.eclipse.graphiti.ui.internal.command.GefCommandWrapper;
import org.eclipse.graphiti.ui.internal.config.ConfigurationProvider;
import org.eclipse.graphiti.ui.internal.config.IConfigurationProvider;
import org.eclipse.graphiti.ui.internal.contextbuttons.ContextButtonManagerForPad;
import org.eclipse.graphiti.ui.internal.contextbuttons.IContextButtonManager;
import org.eclipse.graphiti.ui.internal.dnd.GFTemplateTransferDropTargetListener;
import org.eclipse.graphiti.ui.internal.dnd.ObjectsTransferDropTargetListener;
import org.eclipse.graphiti.ui.internal.editor.DiagramChangeListener;
import org.eclipse.graphiti.ui.internal.editor.DomainModelChangeListener;
import org.eclipse.graphiti.ui.internal.editor.GFCommandStack;
import org.eclipse.graphiti.ui.internal.editor.GFFigureCanvas;
import org.eclipse.graphiti.ui.internal.editor.GFScrollingGraphicalViewer;
import org.eclipse.graphiti.ui.internal.editor.GraphitiScrollingGraphicalViewer;
import org.eclipse.graphiti.ui.internal.parts.IConnectionEditPart;
import org.eclipse.graphiti.ui.internal.util.gef.ScalableRootEditPartAnimated;
import org.eclipse.graphiti.ui.services.GraphitiUi;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class DiagramEditor
extends GraphicalEditorWithFlyoutPalette
implements IDiagramEditor,
ITabbedPropertySheetPageContributor,
IEditingDomainProvider {
    public static final String DIAGRAM_EDITOR_ID = "org.eclipse.graphiti.ui.editor.DiagramEditor";
    private final DefaultUpdateBehavior updateBehavior;
    private final DefaultPaletteBehavior paletteBehaviour;
    private final DefaultPersistencyBehavior persistencyBehavior;
    private final DefaultMarkerBehavior markerBehavior = this.createMarkerBehavior();
    private final DefaultRefreshBehavior refreshBehavior;
    private CommandStackEventListener gefCommandStackListener;
    private DiagramChangeListener diagramChangeListener;
    private DomainModelChangeListener domainModelListener;
    private DiagramScrollingBehavior diagramScrollingBehavior;
    private PictogramElement[] pictogramElementsForSelection;
    private String contributorId;
    private IConfigurationProvider configurationProvider;
    private KeyHandler keyHandler;
    private Point mouseLocation;
    private boolean directEditingActive = false;
    private String editorInitializationError = null;

    public DiagramEditor() {
        this.updateBehavior = this.createUpdateBehavior();
        this.paletteBehaviour = this.createPaletteBehaviour();
        this.persistencyBehavior = this.createPersistencyBehavior();
        this.refreshBehavior = this.createRefreshBehavior();
    }

    protected DefaultMarkerBehavior createMarkerBehavior() {
        return new DefaultMarkerBehavior(this);
    }

    protected DefaultUpdateBehavior createUpdateBehavior() {
        return new DefaultUpdateBehavior(this);
    }

    public final DefaultUpdateBehavior getUpdateBehavior() {
        return this.updateBehavior;
    }

    protected DefaultPaletteBehavior createPaletteBehaviour() {
        return new DefaultPaletteBehavior(this);
    }

    protected DefaultPersistencyBehavior createPersistencyBehavior() {
        return new DefaultPersistencyBehavior(this);
    }

    protected DefaultRefreshBehavior createRefreshBehavior() {
        return new DefaultRefreshBehavior(this);
    }

    public final DefaultRefreshBehavior getRefreshBehavior() {
        return this.refreshBehavior;
    }

    public void editingDomainInitialized() {
        this.markerBehavior.initialize();
    }

    public void disableAdapters() {
        this.markerBehavior.disableProblemIndicationUpdate();
        this.updateBehavior.setAdapterActive(false);
    }

    public void enableAdapters() {
        this.markerBehavior.enableProblemIndicationUpdate();
        this.updateBehavior.setAdapterActive(true);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof IDiagramEditorInput) && (input = this.convertToDiagramEditorInput(input)) == null) {
            throw new PartInitException("No DiagramEditorInput instance is available but it is required. The method convertToDiagramEditorInput illegally returned null.");
        }
        this.getUpdateBehavior().createEditingDomain();
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        if (this.editorInitializationError != null) {
            return;
        }
        this.getCommandStack().addCommandStackListener((CommandStackListener)this);
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
        this.initializeActionRegistry();
        this.getUpdateBehavior().init();
        this.migrateDiagramModelIfNecessary();
    }

    protected DiagramEditorInput convertToDiagramEditorInput(IEditorInput input) throws PartInitException {
        DiagramEditorInput newInput = EditorInputAdapter.adaptToDiagramEditorInput(input);
        if (!(newInput instanceof IDiagramEditorInput)) {
            throw new PartInitException("Unknown editor input: " + input);
        }
        return newInput;
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        if (input == null) {
            throw new IllegalArgumentException("The IEditorInput must not be null");
        }
        if (!(input instanceof IDiagramEditorInput)) {
            throw new IllegalArgumentException("The IEditorInput has the wrong type: " + input.getClass());
        }
        IDiagramEditorInput diagramEditorInput = (IDiagramEditorInput)input;
        Diagram diagram = this.persistencyBehavior.loadDiagram(diagramEditorInput.getUri());
        if (diagram == null) {
            this.editorInitializationError = "No Diagram found for URI '" + diagramEditorInput.getUri().toString();
            return;
        }
        String providerId = diagramEditorInput.getProviderId();
        if (providerId == null) {
            providerId = GraphitiUi.getExtensionManager().getDiagramTypeProviderId(diagram.getDiagramTypeId());
            diagramEditorInput.setProviderId(providerId);
        }
        if (providerId == null) {
            this.editorInitializationError = "DiagramEditorInput does not convey a Provider ID '" + diagramEditorInput;
            return;
        }
        IDiagramTypeProvider diagramTypeProvider = GraphitiUi.getExtensionManager().createDiagramTypeProvider(providerId);
        if (diagramTypeProvider == null) {
            this.editorInitializationError = "Could not find diagram type provider for " + diagram.getDiagramTypeId();
            return;
        }
        diagramTypeProvider.init(diagram, (IDiagramEditor)this);
        ConfigurationProvider configurationProvider = new ConfigurationProvider(this, diagramTypeProvider);
        this.setConfigurationProvider(configurationProvider);
        this.refreshBehavior.handleAutoUpdateAtStartup();
        this.registerBusinessObjectsListener();
        this.registerDiagramResourceSetListener();
        this.refreshTitle();
    }

    protected void initActionRegistry(ZoomManager zoomManager) {
        ISaveImageFeature sf;
        ActionRegistry actionRegistry = this.getActionRegistry();
        List selectionActions = this.getSelectionActions();
        Object action = new UpdateAction((IWorkbenchPart)this, this.getConfigurationProvider());
        actionRegistry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        action = new RemoveAction((IWorkbenchPart)this, this.getConfigurationProvider());
        actionRegistry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        action = new DeleteAction((IWorkbenchPart)this, this.getConfigurationProvider());
        actionRegistry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        action = new CopyAction((IWorkbenchPart)this, this.getConfigurationProvider());
        actionRegistry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        action = new PasteAction((IWorkbenchPart)this, this.getConfigurationProvider());
        actionRegistry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        IFeatureProvider fp = this.getConfigurationProvider().getDiagramTypeProvider().getFeatureProvider();
        if (fp != null && (sf = fp.getSaveImageFeature()) != null) {
            SaveImageContext context = new SaveImageContext();
            action = new SaveImageAction(sf, (ISaveImageContext)context, this);
            actionRegistry.registerAction((IAction)action);
            selectionActions.add(action.getId());
        }
        this.registerAction((IAction)new ZoomInAction(zoomManager));
        this.registerAction((IAction)new ZoomOutAction(zoomManager));
        this.registerAction((IAction)new DirectEditAction((IWorkbenchPart)this));
        this.registerAction((IAction)new AlignmentAction((IWorkbenchPart)this, 1));
        this.registerAction((IAction)new AlignmentAction((IWorkbenchPart)this, 4));
        this.registerAction((IAction)new AlignmentAction((IWorkbenchPart)this, 8));
        this.registerAction((IAction)new AlignmentAction((IWorkbenchPart)this, 32));
        this.registerAction((IAction)new AlignmentAction((IWorkbenchPart)this, 2));
        this.registerAction((IAction)new AlignmentAction((IWorkbenchPart)this, 16));
        this.registerAction((IAction)new MatchWidthAction((IWorkbenchPart)this));
        this.registerAction((IAction)new MatchHeightAction((IWorkbenchPart)this));
        ToggleGridAction showGrid = new ToggleGridAction(this.getGraphicalViewer());
        this.getActionRegistry().registerAction((IAction)showGrid);
        ToggleContextButtonPadAction toggleContextButtonPad = new ToggleContextButtonPadAction(this);
        toggleContextButtonPad.setChecked(false);
        actionRegistry.registerAction((IAction)toggleContextButtonPad);
    }

    public void createPartControl(Composite parent) {
        if (this.editorInitializationError != null) {
            this.createErrorPartControl(parent);
            return;
        }
        super.createPartControl(parent);
        this.getDiagramTypeProvider().postInit();
        this.gefCommandStackListener = new CommandStackEventListener(){

            public void stackChanged(CommandStackEvent event) {
                if (Display.getCurrent() != null) {
                    DiagramEditor.this.firePropertyChange(257);
                    DiagramEditor.this.commandStackChanged((EventObject)event);
                }
            }
        };
        this.getEditDomain().getCommandStack().addCommandStackEventListener(this.gefCommandStackListener);
    }

    private void createErrorPartControl(Composite parent) {
        Color separatorColor;
        Color foregroundColor;
        Color backgroundColor;
        Display display = parent.getDisplay();
        if (display.getHighContrast()) {
            backgroundColor = display.getSystemColor(22);
            separatorColor = foregroundColor = display.getSystemColor(21);
        } else {
            backgroundColor = display.getSystemColor(1);
            foregroundColor = display.getSystemColor(10);
            separatorColor = new Color((Device)display, 152, 170, 203);
        }
        ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 768);
        scrolledComposite.setAlwaysShowScrollBars(false);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (separatorColor != foregroundColor) {
                    separatorColor.dispose();
                }
            }
        });
        Composite composite = new Composite((Composite)scrolledComposite, 0);
        composite.setBackground(backgroundColor);
        composite.setLayout((Layout)new GridLayout());
        Composite separator = new Composite(composite, 524288);
        separator.setBackground(separatorColor);
        GridData data = new GridData(768);
        data.heightHint = 2;
        data.verticalIndent = 50;
        separator.setLayoutData((Object)data);
        StyledText widget = new StyledText(composite, 10);
        widget.setLayoutData((Object)new GridData(768));
        widget.setText(this.editorInitializationError);
        widget.setBackground(backgroundColor);
        widget.setForeground(foregroundColor);
        widget.setCaret(null);
        scrolledComposite.setContent((Control)composite);
        scrolledComposite.setMinSize(composite.computeSize(-1, -1));
    }

    protected void createGraphicalViewer(Composite parent) {
        GraphitiScrollingGraphicalViewer viewer;
        if (this.getDiagramScrollingBehavior() == DiagramScrollingBehavior.SCROLLBARS_ALWAYS_VISIBLE) {
            viewer = new GFScrollingGraphicalViewer(this);
            ((GFScrollingGraphicalViewer)viewer).createGFControl(parent);
        } else {
            viewer = new GraphitiScrollingGraphicalViewer(this);
            viewer.createControl(parent);
        }
        this.setGraphicalViewer((GraphicalViewer)viewer);
        this.configureGraphicalViewer();
        this.hookGraphicalViewer();
        this.initializeGraphicalViewer();
    }

    protected void initializeGraphicalViewer() {
        ContextMenuProvider contextMenuProvider;
        IPrintFeature pf;
        super.initializeGraphicalViewer();
        IFeatureProvider featureProvider = this.getConfigurationProvider().getDiagramTypeProvider().getFeatureProvider();
        if (featureProvider != null && (pf = featureProvider.getPrintFeature()) != null) {
            this.registerAction((IAction)new PrintGraphicalViewerAction(this.getConfigurationProvider().getWorkbenchPart(), pf));
        }
        if (this.getEditorSite().getActionBarContributor() != null) {
            this.getEditorSite().getActionBarContributor().setActiveEditor((IEditorPart)this);
        }
        if ((contextMenuProvider = this.createContextMenuProvider()) != null) {
            this.getGraphicalViewer().setContextMenu((MenuManager)contextMenuProvider);
            if (this.shouldRegisterContextMenu()) {
                this.getSite().registerContextMenu((MenuManager)contextMenuProvider, (ISelectionProvider)this.getGraphicalViewer());
            }
        }
        this.getGraphicalViewer().setEditPartFactory((EditPartFactory)this.getConfigurationProvider().getEditPartFactory());
        this.getGraphicalViewer().setContents((Object)this.getConfigurationProvider().getDiagram());
        this.paletteBehaviour.initializeViewer();
        this.getGraphicalViewer().getControl().addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                DiagramEditor.this.setMouseLocation(e.x, e.y);
            }
        });
        this.getGraphicalViewer().addDropTargetListener((org.eclipse.jface.util.TransferDropTargetListener)new ObjectsTransferDropTargetListener((EditPartViewer)this.getGraphicalViewer()));
        this.getGraphicalViewer().addDropTargetListener((TransferDropTargetListener)new GFTemplateTransferDropTargetListener((EditPartViewer)this.getGraphicalViewer(), this));
    }

    protected void configureGraphicalViewer() {
        GFFigureCanvas figureCanvas;
        super.configureGraphicalViewer();
        ScrollingGraphicalViewer viewer = (ScrollingGraphicalViewer)this.getGraphicalViewer();
        ScalableRootEditPartAnimated rootEditPart = new ScalableRootEditPartAnimated(viewer){

            protected GridLayer createGridLayer() {
                return new org.eclipse.graphiti.ui.internal.util.draw2d.GridLayer(DiagramEditor.this.getConfigurationProvider());
            }
        };
        viewer.setRootEditPart((RootEditPart)rootEditPart);
        ZoomManager zoomManager = rootEditPart.getZoomManager();
        ArrayList<String> zoomLevels = new ArrayList<String>(3);
        zoomLevels.add(ZoomManager.FIT_ALL);
        zoomLevels.add(ZoomManager.FIT_WIDTH);
        zoomLevels.add(ZoomManager.FIT_HEIGHT);
        zoomManager.setZoomLevelContributions(zoomLevels);
        IToolBehaviorProvider toolBehaviorProvider = this.getConfigurationProvider().getDiagramTypeProvider().getCurrentToolBehaviorProvider();
        zoomManager.setZoomLevels(toolBehaviorProvider.getZoomLevels());
        this.initActionRegistry(zoomManager);
        viewer.setKeyHandler(new GraphicalViewerKeyHandler((GraphicalViewer)viewer).setParent(this.getCommonKeyHandler()));
        Diagram diagram = this.getConfigurationProvider().getDiagram();
        boolean snapToGrid = diagram.isSnapToGrid();
        int horizontalGridUnit = diagram.getGridUnit();
        int verticalGridUnit = diagram.getVerticalGridUnit();
        if (verticalGridUnit == -1) {
            verticalGridUnit = horizontalGridUnit;
        }
        boolean gridVisisble = horizontalGridUnit > 0 && verticalGridUnit > 0;
        viewer.setProperty("SnapToGrid.isVisible", (Object)new Boolean(gridVisisble));
        viewer.setProperty("SnapToGrid.isEnabled", (Object)new Boolean(snapToGrid));
        viewer.setProperty("SnapToGrid.GridSpacing", (Object)new Dimension(horizontalGridUnit, verticalGridUnit));
        viewer.setProperty("SnapToGeometry.isEnabled", (Object)toolBehaviorProvider.isShowGuides());
        this.configurationProvider.setContextButtonManager(new ContextButtonManagerForPad(this, this.configurationProvider.getResourceRegistry()));
        if (this.getDiagramScrollingBehavior() == DiagramScrollingBehavior.SCROLLBARS_ALWAYS_VISIBLE && (figureCanvas = this.getGFFigureCanvas()) != null) {
            figureCanvas.setScrollBarVisibility(FigureCanvas.ALWAYS);
        }
    }

    public void updateDirtyState() {
        this.firePropertyChange(257);
    }

    public void doSave(IProgressMonitor monitor) {
        this.persistencyBehavior.saveDiagram(monitor);
    }

    public boolean isDirty() {
        return this.persistencyBehavior.isDirty();
    }

    protected final PaletteViewerProvider createPaletteViewerProvider() {
        if (this.editorInitializationError != null) {
            return null;
        }
        return this.paletteBehaviour.createPaletteViewerProvider();
    }

    protected final FlyoutPaletteComposite.FlyoutPreferences getPalettePreferences() {
        return this.paletteBehaviour.getPalettePreferences();
    }

    protected final PaletteRoot getPaletteRoot() {
        return this.paletteBehaviour.getPaletteRoot();
    }

    public final void refreshPalette() {
        this.paletteBehaviour.refreshPalette();
    }

    protected ContextMenuProvider createContextMenuProvider() {
        return new DiagramEditorContextMenuProvider((EditPartViewer)this.getGraphicalViewer(), this.getActionRegistry(), this.getDiagramTypeProvider());
    }

    protected boolean shouldRegisterContextMenu() {
        return true;
    }

    protected void registerDiagramResourceSetListener() {
        this.diagramChangeListener = new DiagramChangeListener(this);
        TransactionalEditingDomain eDomain = this.getEditingDomain();
        eDomain.addResourceSetListener((ResourceSetListener)this.diagramChangeListener);
    }

    protected void registerBusinessObjectsListener() {
        this.domainModelListener = new DomainModelChangeListener(this);
        TransactionalEditingDomain eDomain = this.getEditingDomain();
        eDomain.addResourceSetListener((ResourceSetListener)this.domainModelListener);
    }

    protected void unregisterDiagramResourceSetListener() {
        if (this.diagramChangeListener != null) {
            this.diagramChangeListener.stopListening();
            TransactionalEditingDomain eDomain = this.getEditingDomain();
            eDomain.removeResourceSetListener((ResourceSetListener)this.diagramChangeListener);
        }
    }

    protected void unregisterBusinessObjectsListener() {
        if (this.domainModelListener != null) {
            TransactionalEditingDomain eDomain = this.getEditingDomain();
            eDomain.removeResourceSetListener((ResourceSetListener)this.domainModelListener);
        }
    }

    public void refreshTitle() {
        String name = this.getConfigurationProvider().getDiagramTypeProvider().getDiagramTitle();
        if (name == null || name.length() == 0) {
            name = this.getConfigurationElement().getAttribute("name");
        }
        if (name == null || name.length() == 0) {
            name = URI.decode((String)this.getDiagramTypeProvider().getDiagram().eResource().getURI().lastSegment());
        }
        this.setPartName(name);
    }

    public void refreshTitleToolTip() {
        this.setTitleToolTip(this.getTitleToolTip());
    }

    public void refresh() {
        this.refreshBehavior.refresh();
    }

    public void refreshContent() {
        Diagram currentDiagram = this.getDiagramTypeProvider().getDiagram();
        if (GraphitiInternal.getEmfService().isObjectAlive((EObject)currentDiagram)) {
            this.refresh();
        } else {
            IDiagramEditorInput diagramEditorInput = (IDiagramEditorInput)this.getEditorInput();
            Diagram diagram = this.persistencyBehavior.loadDiagram(diagramEditorInput.getUri());
            IDiagramTypeProvider diagramTypeProvider = this.getConfigurationProvider().getDiagramTypeProvider();
            diagramTypeProvider.resourceReloaded(diagram);
            this.refreshBehavior.initRefresh();
            this.setPictogramElementsForSelection(null);
            this.getGraphicalViewer().setContents((Object)diagram);
            this.refreshBehavior.handleAutoUpdateAtReset();
        }
    }

    public void refreshRenderingDecorators(PictogramElement pe) {
        this.refreshBehavior.refreshRenderingDecorators(pe);
    }

    public Object getAdapter(Class type) {
        Object ret;
        IToolBehaviorProvider tbp;
        IConfigurationProvider cfgProvider = this.getConfigurationProvider();
        if (cfgProvider != null && (tbp = cfgProvider.getDiagramTypeProvider().getCurrentToolBehaviorProvider()) != null && (ret = tbp.getAdapter(type)) != null) {
            return ret;
        }
        GraphicalViewer viewer = this.getGraphicalViewer();
        if (type == ZoomManager.class && viewer != null) {
            return viewer.getProperty(ZoomManager.class.toString());
        }
        if (type == IPropertySheetPage.class) {
            if (cfgProvider != null && this.getContributorId() != null) {
                return new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
            }
            return null;
        }
        if (type == Diagram.class) {
            IDiagramTypeProvider diagramTypeProvider = this.getDiagramTypeProvider();
            if (diagramTypeProvider != null) {
                return diagramTypeProvider.getDiagram();
            }
            return null;
        }
        if (type == KeyHandler.class) {
            return this.getCommonKeyHandler();
        }
        if (type == SelectionSynchronizer.class) {
            return this.getSelectionSynchronizer();
        }
        if (type == IContextButtonManager.class) {
            return this.getConfigurationProvider().getContextButtonManager();
        }
        return super.getAdapter(type);
    }

    public void dispose() {
        this.unregisterDiagramResourceSetListener();
        this.unregisterBusinessObjectsListener();
        if (this.getConfigurationProvider() != null) {
            this.getConfigurationProvider().dispose();
        }
        if (this.paletteBehaviour != null) {
            this.paletteBehaviour.dispose();
        }
        this.markerBehavior.dispose();
        if (this.getSite() != null && this.getSite().getPage() != null) {
            this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        }
        if (this.getEditDomain() != null && this.getEditDomain().getCommandStack() != null) {
            this.getEditDomain().getCommandStack().removeCommandStackEventListener(this.gefCommandStackListener);
            this.getEditDomain().getCommandStack().dispose();
        }
        DefaultUpdateBehavior behavior = this.getUpdateBehavior();
        behavior.dispose();
        RuntimeException exc = null;
        if (this.getEditDomain() != null) {
            try {
                super.dispose();
            }
            catch (RuntimeException e) {
                exc = e;
            }
        }
        if (this.getEditDomain() != null) {
            this.getEditDomain().setCommandStack(null);
        }
        if (exc != null) {
            throw exc;
        }
    }

    public void setFocus() {
        if (this.getGraphicalViewer() == null) {
            return;
        }
        super.setFocus();
        this.getUpdateBehavior().handleActivate();
    }

    public PictogramElement[] getSelectedPictogramElements() {
        ISelection s;
        PictogramElement[] pe = new PictogramElement[]{};
        ISelectionProvider selectionProvider = this.getSite().getSelectionProvider();
        if (selectionProvider != null && (s = selectionProvider.getSelection()) instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)s;
            ArrayList<PictogramElement> list = new ArrayList<PictogramElement>();
            for (Object o : sel) {
                EditPart editPart;
                if (!(o instanceof EditPart) || !((editPart = (EditPart)o).getModel() instanceof PictogramElement)) continue;
                list.add((PictogramElement)editPart.getModel());
            }
            pe = list.toArray(new PictogramElement[0]);
        }
        return pe;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        Object selectedPage;
        IEditorPart activeEditor;
        boolean editorIsActive = this.getSite().getPage().isPartVisible((IWorkbenchPart)this);
        if (!editorIsActive && (activeEditor = this.getSite().getPage().getActiveEditor()) != null && activeEditor instanceof MultiPageEditorPart && (selectedPage = ((MultiPageEditorPart)activeEditor).getAdapter(DiagramEditor.class)) instanceof DiagramEditor) {
            editorIsActive = true;
        }
        if (editorIsActive) {
            if (part instanceof CommonNavigator && !((CommonNavigator)part).isLinkingEnabled()) {
                return;
            }
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                ArrayList<PictogramElement> peList = new ArrayList<PictogramElement>();
                for (Object object : structuredSelection) {
                    if (object instanceof EObject) {
                        List referencingPes = Graphiti.getLinkService().getPictogramElements(this.getDiagramTypeProvider().getDiagram(), (EObject)object);
                        if (referencingPes.size() <= 0) continue;
                        peList.addAll(referencingPes);
                        continue;
                    }
                    PictogramElement[] relatedPictogramElements = this.getDiagramTypeProvider().getNotificationService().calculateRelatedPictogramElements(new Object[]{object});
                    int i = 0;
                    while (i < relatedPictogramElements.length) {
                        peList.add(relatedPictogramElements[i]);
                        ++i;
                    }
                }
                PictogramElement[] pes = null;
                if (peList.size() > 0) {
                    pes = peList.toArray(new PictogramElement[peList.size()]);
                }
                if (pes != null && pes.length > 0) {
                    this.selectPictogramElements(pes);
                }
            }
            this.updateActions(this.getSelectionActions());
        }
    }

    public void selectPictogramElements(PictogramElement[] pictogramElements) {
        ArrayList<EditPart> editParts = new ArrayList<EditPart>();
        Map editPartRegistry = this.getGraphicalViewer().getEditPartRegistry();
        if (editPartRegistry != null) {
            EditPart editpart;
            int i = 0;
            while (i < pictogramElements.length) {
                PictogramElement pe = pictogramElements[i];
                Object obj = editPartRegistry.get(pe);
                if (obj instanceof EditPart && ((EditPart)obj).isSelectable()) {
                    editParts.add((EditPart)obj);
                }
                ++i;
            }
            this.getSite().getSelectionProvider().setSelection((ISelection)new StructuredSelection(editParts));
            if (editParts.size() > 0 && !((editpart = (EditPart)editParts.get(0)) instanceof IConnectionEditPart)) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        DiagramEditor.this.getGraphicalViewer().reveal(editpart);
                    }
                });
            }
        }
    }

    protected PictogramElement[] getPictogramElementsForSelection() {
        return this.pictogramElementsForSelection;
    }

    public void setPictogramElementForSelection(PictogramElement pictogramElement) {
        this.pictogramElementsForSelection = pictogramElement == null ? null : new PictogramElement[]{pictogramElement};
    }

    public void setPictogramElementsForSelection(PictogramElement[] pictogramElements) {
        this.pictogramElementsForSelection = pictogramElements;
    }

    public void selectBufferedPictogramElements() {
        if (this.getPictogramElementsForSelection() != null) {
            this.selectPictogramElements(this.getPictogramElementsForSelection());
            this.setPictogramElementsForSelection(null);
        }
    }

    public Point getMouseLocation() {
        if (this.mouseLocation == null) {
            this.mouseLocation = new Point();
        }
        return this.mouseLocation;
    }

    public Point calculateRealMouseLocation(Point nativeLocation) {
        Point ret = new Point(nativeLocation);
        Point viewLocation = this.getDiagramScrollingBehavior() == DiagramScrollingBehavior.SCROLLBARS_ALWAYS_VISIBLE ? this.getGFFigureCanvas().getViewport().getViewLocation() : this.getFigureCanvas().getViewport().getViewLocation();
        ret.x += viewLocation.x;
        ret.y += viewLocation.y;
        ZoomManager zoomManager = (ZoomManager)this.getGraphicalViewer().getProperty(ZoomManager.class.toString());
        ret = ret.getScaled(1.0 / zoomManager.getZoom());
        return ret;
    }

    private void setMouseLocation(int x, int y) {
        this.getMouseLocation().setLocation(x, y);
    }

    protected KeyHandler getCommonKeyHandler() {
        if (this.keyHandler == null) {
            this.keyHandler = new KeyHandler();
            this.keyHandler.put(KeyStroke.getPressed((char)'\u007f', (int)127, (int)0), this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId()));
            this.keyHandler.put(KeyStroke.getPressed((char)'\u007f', (int)127, (int)131072), this.getActionRegistry().getAction((Object)"predefined remove action"));
            this.keyHandler.put(KeyStroke.getPressed((int)0x100000B, (int)0), this.getActionRegistry().getAction((Object)"org.eclipse.gef.direct_edit"));
            this.keyHandler.put(KeyStroke.getPressed((char)'c', (int)262144), this.getActionRegistry().getAction((Object)ActionFactory.COPY.getId()));
            this.keyHandler.put(KeyStroke.getPressed((char)'v', (int)262144), this.getActionRegistry().getAction((Object)ActionFactory.PASTE.getId()));
        }
        return this.keyHandler;
    }

    IConfigurationProvider getConfigurationProvider() {
        return this.configurationProvider;
    }

    public EditPart getContentEditPart() {
        if (this.getGraphicalViewer() != null) {
            return this.getGraphicalViewer().getContents();
        }
        return null;
    }

    public String getContributorId() {
        IToolBehaviorProvider tbp;
        if (this.contributorId == null && (tbp = this.getToolBehaviorProvider()) != null) {
            this.contributorId = tbp.getContributorId();
        }
        return this.contributorId;
    }

    @Deprecated
    private DiagramScrollingBehavior getDiagramScrollingBehavior() {
        if (this.diagramScrollingBehavior == null) {
            IToolBehaviorProvider tbp = this.getConfigurationProvider().getDiagramTypeProvider().getCurrentToolBehaviorProvider();
            this.diagramScrollingBehavior = tbp.getDiagramScrollingBehavior();
        }
        return this.diagramScrollingBehavior;
    }

    public IDiagramTypeProvider getDiagramTypeProvider() {
        IConfigurationProvider cfgProvider = this.getConfigurationProvider();
        if (cfgProvider != null) {
            return cfgProvider.getDiagramTypeProvider();
        }
        return null;
    }

    public DefaultEditDomain getEditDomain() {
        return super.getEditDomain();
    }

    public GraphicalEditPart getEditPartForPictogramElement(PictogramElement pe) {
        Object obj;
        Map editPartRegistry = this.getGraphicalViewer().getEditPartRegistry();
        if (editPartRegistry != null && (obj = editPartRegistry.get(pe)) instanceof GraphicalEditPart) {
            GraphicalEditPart ep = (GraphicalEditPart)obj;
            return ep;
        }
        return null;
    }

    public IFigure getFigureForPictogramElement(PictogramElement pe) {
        GraphicalEditPart ep = this.getEditPartForPictogramElement(pe);
        if (ep != null) {
            return ep.getFigure();
        }
        return null;
    }

    private FigureCanvas getFigureCanvas() {
        Control control;
        GraphicalViewer viewer = this.getGraphicalViewer();
        if (viewer != null && (control = viewer.getControl()) instanceof FigureCanvas) {
            return (FigureCanvas)control;
        }
        return null;
    }

    private GFFigureCanvas getGFFigureCanvas() {
        Control control;
        GraphicalViewer viewer = this.getGraphicalViewer();
        if (viewer != null && (control = viewer.getControl()) instanceof GFFigureCanvas) {
            return (GFFigureCanvas)control;
        }
        return null;
    }

    public GraphicalViewer getGraphicalViewer() {
        return super.getGraphicalViewer();
    }

    public String getTitleToolTip() {
        IToolBehaviorProvider tbp;
        String titleToolTip;
        if (this.getDiagramTypeProvider() != null && this.getDiagramTypeProvider().getCurrentToolBehaviorProvider() != null && (titleToolTip = (tbp = this.getDiagramTypeProvider().getCurrentToolBehaviorProvider()).getTitleToolTip()) != null) {
            return titleToolTip;
        }
        return super.getTitleToolTip();
    }

    private IToolBehaviorProvider getToolBehaviorProvider() {
        IDiagramTypeProvider dtp = this.getDiagramTypeProvider();
        if (dtp != null) {
            return dtp.getCurrentToolBehaviorProvider();
        }
        return null;
    }

    public double getZoomLevel() {
        ZoomManager zoomManager = (ZoomManager)this.getAdapter(ZoomManager.class);
        if (zoomManager == null) {
            return 1.0;
        }
        return Math.max(0.05, zoomManager.getZoom());
    }

    protected void migrateDiagramModelIfNecessary() {
        final Diagram diagram = this.getDiagramTypeProvider().getDiagram();
        if (Graphiti.getMigrationService().shouldMigrate080To090(diagram)) {
            this.getEditingDomain().getCommandStack().execute((Command)new RecordingCommand(this.getEditingDomain()){

                protected void doExecute() {
                    Graphiti.getMigrationService().migrate080To090(diagram);
                }
            });
        }
    }

    public boolean isAlive() {
        IConfigurationProvider cp = this.getConfigurationProvider();
        if (cp != null) {
            TransactionalEditingDomain editingDomain = this.getEditingDomain();
            Diagram diagram = cp.getDiagram();
            if (editingDomain != null && GraphitiInternal.getEmfService().isObjectAlive((EObject)diagram)) {
                return true;
            }
        }
        return false;
    }

    protected void registerAction(IAction action) {
        if (action == null) {
            return;
        }
        this.getActionRegistry().registerAction(action);
        if (action.getActionDefinitionId() != null) {
            IHandlerService hs = (IHandlerService)this.getSite().getService(IHandlerService.class);
            hs.activateHandler(action.getActionDefinitionId(), (IHandler)new ActionHandler(action));
        }
        List selectionActions = this.getSelectionActions();
        selectionActions.add(action.getId());
    }

    private void setConfigurationProvider(IConfigurationProvider configurationProvider) {
        this.configurationProvider = configurationProvider;
        this.configurationProvider.setWorkbenchPart((IWorkbenchPart)this);
        if (this.getGraphicalViewer() != null) {
            this.initializeGraphicalViewer();
        }
        DefaultEditDomain editDomain = new DefaultEditDomain((IEditorPart)this);
        GFCommandStack commandStack = new GFCommandStack(configurationProvider, this.getEditingDomain());
        editDomain.setCommandStack((CommandStack)commandStack);
        this.setEditDomain(editDomain);
    }

    public boolean isDirectEditingActive() {
        return this.directEditingActive;
    }

    public void setDirectEditingActive(boolean directEditingActive) {
        this.directEditingActive = directEditingActive;
        this.configurationProvider.getContextButtonManager().hideContextButtonsInstantly();
    }

    public TransactionalEditingDomain getEditingDomain() {
        return this.updateBehavior.getEditingDomain();
    }

    public Object executeFeature(IFeature feature, IContext context) {
        PictogramElement returnValue = null;
        DefaultEditDomain domain = this.getEditDomain();
        Assert.isNotNull((Object)domain);
        CommandStack commandStack = domain.getCommandStack();
        GenericFeatureCommandWithContext featureCommand = null;
        if (feature instanceof IAddFeature) {
            Assert.isTrue((boolean)(context instanceof IAddContext));
            featureCommand = new AddFeatureCommandWithContext(feature, context);
        } else {
            featureCommand = new GenericFeatureCommandWithContext(feature, context);
        }
        GefCommandWrapper commandWrapper = new GefCommandWrapper((ICommand)featureCommand, this.getEditingDomain());
        commandStack.execute((org.eclipse.gef.commands.Command)commandWrapper);
        if (featureCommand instanceof AddFeatureCommandWithContext) {
            PictogramElement addedPictogramElement = ((AddFeatureCommandWithContext)featureCommand).getAddedPictogramElements();
            if (addedPictogramElement != null) {
                this.setPictogramElementForSelection(addedPictogramElement);
            }
            returnValue = addedPictogramElement;
        }
        return returnValue;
    }

    public ResourceSet getResourceSet() {
        ResourceSet ret = null;
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        if (editingDomain != null) {
            ret = editingDomain.getResourceSet();
        }
        return ret;
    }
}

