/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.editor;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramsPackage;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.graphiti.ui.internal.GraphitiUIPlugin;
import org.eclipse.graphiti.ui.internal.T;
import org.eclipse.graphiti.ui.internal.services.GraphitiUiInternal;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPersistencyBehavior {
    protected final DiagramEditor diagramEditor;
    protected Command savedCommand = null;

    public DefaultPersistencyBehavior(DiagramEditor diagramEditor) {
        this.diagramEditor = diagramEditor;
    }

    public Diagram loadDiagram(URI uri) {
        TransactionalEditingDomain editingDomain;
        if (uri != null && (editingDomain = this.diagramEditor.getEditingDomain()) != null) {
            EObject modelElement = null;
            try {
                modelElement = editingDomain.getResourceSet().getEObject(uri, false);
                if (modelElement == null && (modelElement = editingDomain.getResourceSet().getEObject(uri, true)) == null) {
                    return null;
                }
            }
            catch (WrappedException e) {
                T.racer().debug("Diagram with URI '" + uri.toString() + "' could not be loaded", e);
                return null;
            }
            modelElement.eResource().setTrackingModification(true);
            return (Diagram)modelElement;
        }
        return null;
    }

    public void saveDiagram(IProgressMonitor monitor) {
        Diagram diagram = this.diagramEditor.getDiagramTypeProvider().getDiagram();
        this.setDiagramVersion(diagram);
        Map<Resource, Map<?, ?>> saveOptions = this.createSaveOptions();
        HashSet<Resource> savedResources = new HashSet<Resource>();
        IRunnableWithProgress operation = this.createOperation(savedResources, saveOptions);
        this.diagramEditor.disableAdapters();
        try {
            new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()).run(true, false, operation);
            BasicCommandStack commandStack = (BasicCommandStack)this.diagramEditor.getEditingDomain().getCommandStack();
            commandStack.saveIsDone();
            this.savedCommand = commandStack.getUndoCommand();
            this.diagramEditor.updateDirtyState();
        }
        catch (Exception exception) {
            T.racer().error(exception.getMessage(), exception);
        }
        this.diagramEditor.enableAdapters();
        Resource[] savedResourcesArray = savedResources.toArray(new Resource[savedResources.size()]);
        this.diagramEditor.commandStackChanged(null);
        IDiagramTypeProvider provider = this.diagramEditor.getConfigurationProvider().getDiagramTypeProvider();
        provider.resourcesSaved(this.diagramEditor.getDiagramTypeProvider().getDiagram(), savedResourcesArray);
    }

    public boolean isDirty() {
        BasicCommandStack commandStack = (BasicCommandStack)this.diagramEditor.getEditingDomain().getCommandStack();
        return this.savedCommand != commandStack.getUndoCommand();
    }

    protected Map<Resource, Map<?, ?>> createSaveOptions() {
        HashMap<String, String> saveOption = new HashMap<String, String>();
        saveOption.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        EList resources = this.diagramEditor.getEditingDomain().getResourceSet().getResources();
        HashMap saveOptions = new HashMap();
        for (Resource resource : resources) {
            saveOptions.put(resource, saveOption);
        }
        return saveOptions;
    }

    protected IRunnableWithProgress createOperation(final Set<Resource> savedResources, final Map<Resource, Map<?, ?>> saveOptions) {
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                try {
                    savedResources.addAll(DefaultPersistencyBehavior.this.save(DefaultPersistencyBehavior.this.diagramEditor.getEditingDomain(), saveOptions));
                }
                catch (WrappedException e) {
                    MultiStatus errorStatus = new MultiStatus("org.eclipse.graphiti.ui", 0, e.getMessage(), (Throwable)e.exception());
                    GraphitiUIPlugin.getDefault().getLog().log((IStatus)errorStatus);
                    T.racer().error(e.getMessage(), e.exception());
                }
            }
        };
        return operation;
    }

    protected Set<Resource> save(TransactionalEditingDomain editingDomain, Map<Resource, Map<?, ?>> saveOptions) {
        return GraphitiUiInternal.getEmfService().save(editingDomain, saveOptions);
    }

    protected void setDiagramVersion(final Diagram diagram) {
        if (!"0.10.0".equals(diagram.getVersion())) {
            CommandStack commandStack = this.diagramEditor.getEditingDomain().getCommandStack();
            commandStack.execute((Command)new RecordingCommand(this.diagramEditor.getEditingDomain()){

                protected void doExecute() {
                    diagram.eSet((EStructuralFeature)PictogramsPackage.eINSTANCE.getDiagram_Version(), (Object)"0.10.0");
                }
            });
        }
    }
}

