/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.editor;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.tools.ConnectionDragCreationTool;
import org.eclipse.graphiti.tb.ContextButtonEntry;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.graphiti.ui.internal.command.CreateConnectionCommand;
import org.eclipse.graphiti.ui.internal.requests.ContextButtonDragRequest;

public class GFDragConnectionTool
extends ConnectionDragCreationTool {
    private DiagramEditor diagramEditor;
    private ContextButtonEntry contextButtonEntry;

    protected boolean handleCreateConnection() {
        Command endCommand = this.getCommand();
        this.setCurrentCommand(endCommand);
        this.executeCurrentCommand();
        this.eraseSourceFeedback();
        return true;
    }

    protected boolean handleButtonUp(int button) {
        boolean b = super.handleButtonUp(button);
        this.setViewer((EditPartViewer)this.diagramEditor.getGraphicalViewer());
        this.diagramEditor.getEditDomain().setActiveTool(this.diagramEditor.getEditDomain().getDefaultTool());
        return b;
    }

    protected Request createTargetRequest() {
        ContextButtonDragRequest request = new ContextButtonDragRequest();
        request.setType(this.getCommandName());
        request.setContextButtonEntry(this.contextButtonEntry);
        return request;
    }

    public void startConnection(EditPart targetEditPart, DiagramEditor diagramEditor, ContextButtonEntry contextButtonEntry) {
        this.diagramEditor = diagramEditor;
        this.contextButtonEntry = contextButtonEntry;
        this.activate();
        this.setConnectionSource(targetEditPart);
        this.lockTargetEditPart(targetEditPart);
        ((CreateConnectionRequest)this.getTargetRequest()).setSourceEditPart(this.getTargetEditPart());
        Command command = this.getCommand();
        if (command != null) {
            this.setCurrentCommand(command);
            this.setState(64);
        }
        this.handleDrag();
        this.setViewer((EditPartViewer)diagramEditor.getGraphicalViewer());
        this.unlockTargetEditPart();
    }

    public void continueConnection(EditPart targetEditPart, DiagramEditor diagramEditor, ContextButtonEntry contextButtonEntry, EditPart targetTargetEditPart) {
        this.diagramEditor = diagramEditor;
        this.contextButtonEntry = contextButtonEntry;
        this.activate();
        this.setConnectionSource(targetEditPart);
        this.lockTargetEditPart(targetEditPart);
        CreateConnectionRequest createConnectionRequest = (CreateConnectionRequest)this.getTargetRequest();
        createConnectionRequest.setSourceEditPart(targetEditPart);
        createConnectionRequest.setTargetEditPart(targetTargetEditPart);
        Command command = this.getCommand();
        if (command != null) {
            this.setCurrentCommand(command);
            this.setState(64);
        }
        this.handleDrag();
        this.setViewer((EditPartViewer)diagramEditor.getGraphicalViewer());
        this.unlockTargetEditPart();
    }

    protected void updateTargetRequest() {
        this.updateTargetUnderMouse();
        CreateConnectionRequest request = (CreateConnectionRequest)this.getTargetRequest();
        request.setType((Object)this.getCommandName());
        Point absoluteMousePosition = this.diagramEditor.getMouseLocation();
        request.setLocation(absoluteMousePosition);
    }

    protected void setState(int state) {
        Command cmd;
        if (state == 64 && (cmd = this.getCurrentCommand()) instanceof CreateConnectionCommand) {
            ((CreateConnectionCommand)cmd).connectionStarted();
        }
        super.setState(state);
    }
}

