/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.util.draw2d;

import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.handles.AbstractHandle;
import org.eclipse.gef.tools.DragEditPartsTracker;
import org.eclipse.graphiti.ui.internal.config.IConfigurationProviderInternal;
import org.eclipse.graphiti.ui.internal.figures.GFFigureUtil;
import org.eclipse.graphiti.ui.internal.util.draw2d.GFHandleHelper;
import org.eclipse.graphiti.ui.internal.util.draw2d.ZoomingInsetsHandleLocator;
import org.eclipse.swt.graphics.Color;

public class GFSurroundingHandle
extends AbstractHandle {
    private static int LINE_WIDTH = 1;
    private static Insets HANDLE_INSETS = new Insets(LINE_WIDTH, LINE_WIDTH, LINE_WIDTH, LINE_WIDTH);
    private static int[] LINE_STYLE_RESIZABLE = new int[]{2, 2};
    private static int[] LINE_STYLE_NOT_RESIZABLE = new int[]{2, 2};
    private static Color FG_COLOR_RESIZABLE;
    private static Color FG_COLOR_NOT_RESIZABLE;
    private IConfigurationProviderInternal configurationProvider;
    private int supportedResizeDirections;
    private boolean movable;

    public Color getFG_COLOR_RESIZABLE() {
        if (FG_COLOR_RESIZABLE == null || FG_COLOR_RESIZABLE.isDisposed()) {
            FG_COLOR_RESIZABLE = this.configurationProvider.getResourceRegistry().getSwtColor("ff850f");
        }
        return FG_COLOR_RESIZABLE;
    }

    public Color getFG_COLOR_NOT_RESIZABLE() {
        if (FG_COLOR_NOT_RESIZABLE == null || FG_COLOR_NOT_RESIZABLE.isDisposed()) {
            FG_COLOR_NOT_RESIZABLE = this.configurationProvider.getResourceRegistry().getSwtColor("d9dadd");
        }
        return FG_COLOR_NOT_RESIZABLE;
    }

    public GFSurroundingHandle(GraphicalEditPart owner, IConfigurationProviderInternal configurationProvider, int supportedResizeDirections, boolean movable) {
        this.configurationProvider = configurationProvider;
        this.supportedResizeDirections = supportedResizeDirections;
        this.movable = movable;
        this.setOwner(owner);
        this.setLocator(new ZoomingInsetsHandleLocator(owner.getFigure(), configurationProvider, HANDLE_INSETS));
        this.setOpaque(false);
        if (movable) {
            this.setCursor(Cursors.SIZEALL);
        } else {
            this.setCursor(null);
        }
    }

    protected DragTracker createDragTracker() {
        if (this.movable) {
            DragEditPartsTracker tracker = new DragEditPartsTracker((EditPart)this.getOwner());
            tracker.setDefaultCursor(this.getCursor());
            return tracker;
        }
        return null;
    }

    public boolean containsPoint(int x, int y) {
        if (!this.getBounds().contains(x, y)) {
            return false;
        }
        Rectangle inner = GFFigureUtil.getAdjustedRectangle(this.getBounds(), 1.0, 2 * this.getLineWidth());
        return !inner.contains(x, y);
    }

    public Point getAccessibleLocation() {
        Point p = this.getBounds().getTopRight().translate(-1, this.getBounds().height / 4);
        this.translateToAbsolute((Translatable)p);
        return p;
    }

    public void paintFigure(Graphics g) {
        g.setAntialias(1);
        g.setLineWidth(this.getLineWidth());
        Rectangle r = GFFigureUtil.getAdjustedRectangle(this.getBounds(), 1.0, this.getLineWidth());
        this.prepareForDrawing(g, 1);
        g.drawLine(r.getTopLeft(), r.getTopRight());
        this.prepareForDrawing(g, 4);
        g.drawLine(r.getBottomLeft(), r.getBottomRight());
        this.prepareForDrawing(g, 16);
        g.drawLine(r.getTopRight(), r.getBottomRight());
        this.prepareForDrawing(g, 8);
        g.drawLine(r.getTopLeft(), r.getBottomLeft());
    }

    private void prepareForDrawing(Graphics g, int direction) {
        int[] dashZoomed;
        Color fg;
        int[] dash;
        boolean resizable;
        boolean bl = resizable = (this.supportedResizeDirections & direction) != 0;
        if (resizable) {
            dash = LINE_STYLE_RESIZABLE;
            fg = this.getFG_COLOR_RESIZABLE();
        } else {
            dash = LINE_STYLE_NOT_RESIZABLE;
            fg = this.getFG_COLOR_NOT_RESIZABLE();
        }
        double zoom = GFHandleHelper.getZoomLevel(this.configurationProvider);
        if (zoom == 1.0) {
            dashZoomed = dash;
        } else {
            dashZoomed = new int[dash.length];
            int i = 0;
            while (i < dashZoomed.length) {
                dashZoomed[i] = Math.max(1, (int)(zoom * (double)dash[i]));
                ++i;
            }
        }
        g.setLineStyle(6);
        g.setLineDash(dashZoomed);
        this.setForegroundColor(fg);
        g.setForegroundColor(this.getForegroundColor());
    }

    private int getLineWidth() {
        double zoom = GFHandleHelper.getZoomLevel(this.configurationProvider);
        return Math.max(1, (int)(zoom * (double)LINE_WIDTH));
    }
}

