/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.config;

import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.graphiti.ui.internal.IResourceRegistry;
import org.eclipse.graphiti.ui.internal.ResourceRegistry;
import org.eclipse.graphiti.ui.internal.config.IConfigurationProviderInternal;
import org.eclipse.graphiti.ui.internal.config.IEditPartFactory;
import org.eclipse.graphiti.ui.internal.contextbuttons.IContextButtonManager;
import org.eclipse.graphiti.ui.internal.partfactory.PictogramsEditPartFactory;
import org.eclipse.graphiti.ui.internal.policy.DefaultEditPolicyFactory;
import org.eclipse.graphiti.ui.internal.policy.IEditPolicyFactory;
import org.eclipse.ui.IWorkbenchPart;

public class ConfigurationProvider
implements IConfigurationProviderInternal {
    private boolean _isDisposed = false;
    private IEditPolicyFactory _editPolicyFactory;
    private IEditPartFactory _editPartFactory;
    private IWorkbenchPart _workbenchPart;
    private DiagramEditor diagramEditor;
    private IDiagramTypeProvider diagramTypeProvider;
    private IContextButtonManager contextButtonManager;
    private IResourceRegistry resourceRegistry = new ResourceRegistry();

    public ConfigurationProvider(DiagramEditor diagramEditor, IDiagramTypeProvider diagramTypeProvider) {
        this.diagramEditor = diagramEditor;
        this.setDiagramTypeProvider(diagramTypeProvider);
    }

    public void dispose() {
        this._editPolicyFactory = null;
        this._editPartFactory = null;
        this._isDisposed = true;
        if (this.resourceRegistry != null) {
            this.resourceRegistry.dispose();
        }
        this.getDiagramTypeProvider().dispose();
    }

    public boolean isDisposed() {
        return this._isDisposed;
    }

    public IContextButtonManager getContextButtonManager() {
        return this.contextButtonManager;
    }

    public void setContextButtonManager(IContextButtonManager contextButtonManager) {
        this.contextButtonManager = contextButtonManager;
    }

    public IEditPolicyFactory getEditPolicyFactory() {
        if (this._editPolicyFactory == null && !this._isDisposed) {
            this._editPolicyFactory = new DefaultEditPolicyFactory(this);
        }
        return this._editPolicyFactory;
    }

    public IEditPartFactory getEditPartFactory() {
        if (this._editPartFactory == null && !this._isDisposed) {
            this._editPartFactory = new PictogramsEditPartFactory(this);
        }
        return this._editPartFactory;
    }

    public void setWorkbenchPart(IWorkbenchPart workbenchPart) {
        if (this._workbenchPart != null && !this._workbenchPart.equals(workbenchPart)) {
            throw new RuntimeException("The IWorbenchPart must not be changed after setting it initially.");
        }
        this._workbenchPart = workbenchPart;
    }

    public IWorkbenchPart getWorkbenchPart() {
        return this._workbenchPart;
    }

    public DiagramEditor getDiagramEditor() {
        return this.diagramEditor;
    }

    public Diagram getDiagram() {
        return this.getDiagramTypeProvider().getDiagram();
    }

    private void setDiagramTypeProvider(IDiagramTypeProvider diagramTypeProvider) {
        this.diagramTypeProvider = diagramTypeProvider;
    }

    public IDiagramTypeProvider getDiagramTypeProvider() {
        return this.diagramTypeProvider;
    }

    public IFeatureProvider getFeatureProvider() {
        return this.getDiagramTypeProvider().getFeatureProvider();
    }

    public IResourceRegistry getResourceRegistry() {
        return this.resourceRegistry;
    }
}

