/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.contextbuttons;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.graphiti.internal.contextbuttons.IContextButtonPadDeclaration;
import org.eclipse.graphiti.internal.contextbuttons.PositionedContextButton;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.graphiti.ui.internal.IResourceRegistry;
import org.eclipse.graphiti.ui.internal.contextbuttons.ContextButton;
import org.eclipse.graphiti.ui.internal.contextbuttons.ContextButtonManagerForPad;
import org.eclipse.graphiti.ui.internal.contextbuttons.ITransparencyProvider;
import org.eclipse.graphiti.ui.internal.figures.GFFigureUtil;
import org.eclipse.graphiti.ui.internal.util.DataTypeTransformation;
import org.eclipse.graphiti.util.IColorConstant;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class ContextButtonPad
extends Shape
implements ITransparencyProvider {
    private static final int DEFAULT_ANIMATION_DURATION = 200;
    private static final double ANIMATION_START_TRANSPARENCY = 0.0;
    private static final double ANIMATION_END_TRANSPARENCY = 1.0;
    private IContextButtonPadDeclaration declaration;
    private double zoomLevel;
    private DiagramEditor editor;
    private EditPart editPart;
    private Path pathOuterLine;
    private Path pathMiddleLine;
    private Path pathInnerLine;
    private Path pathFill;
    private List<Rectangle> containmentRectangles;
    private List<Rectangle> overlappingContainmentRectangles;
    private double currentTransparency = 1.0;
    private long animationDuration = 200L;
    private MouseMoveListener mouseMoveListener = new MouseMoveListener(){

        public void mouseMove(MouseEvent e) {
            if (!ContextButtonPad.this.isMouseInOverlappingArea()) {
                ContextButtonPad.this.getContextButtonManagerForPad().hideContextButtonsInstantly();
            }
        }
    };
    private MouseTrackListener mouseTrackListener = new MouseTrackAdapter(){

        public void mouseExit(MouseEvent e) {
        }
    };
    private IResourceRegistry resourceRegistry;
    private ContextButtonManagerForPad contextButtonManagerForPad;

    public ContextButtonPad(ContextButtonManagerForPad contextButtonManagerForPad, IContextButtonPadDeclaration declaration, double zoomLevel, DiagramEditor editor, EditPart editPart, IResourceRegistry resourceRegistry) {
        this.declaration = declaration;
        this.zoomLevel = zoomLevel;
        this.editor = editor;
        this.editPart = editPart;
        this.resourceRegistry = resourceRegistry;
        this.contextButtonManagerForPad = contextButtonManagerForPad;
        this.initialize();
    }

    public final IContextButtonPadDeclaration getDeclaration() {
        return this.declaration;
    }

    public final double getZoomLevel() {
        return this.zoomLevel;
    }

    public final DiagramEditor getEditor() {
        return this.editor;
    }

    public final EditPart getEditPart() {
        return this.editPart;
    }

    private void initialize() {
        this.initializeContainments();
        this.createContextButtons();
    }

    private void initializeContainments() {
        Rectangle transformedRectangle;
        this.containmentRectangles = new ArrayList<Rectangle>();
        this.overlappingContainmentRectangles = new ArrayList<Rectangle>();
        for (java.awt.Rectangle rectangle : this.getDeclaration().getContainmentRectangles()) {
            transformedRectangle = this.transformGenericRectangle(rectangle, 0);
            this.containmentRectangles.add(transformedRectangle);
        }
        for (java.awt.Rectangle rectangle : this.getDeclaration().getOverlappingContainmentRectangles()) {
            transformedRectangle = this.transformGenericRectangle(rectangle, 0);
            this.overlappingContainmentRectangles.add(transformedRectangle);
        }
        if (this.overlappingContainmentRectangles.size() > 0) {
            Rectangle unionRectangle = this.overlappingContainmentRectangles.get(0).getCopy();
            for (Rectangle containmentRectangle : this.overlappingContainmentRectangles) {
                unionRectangle.union(containmentRectangle);
            }
            unionRectangle.expand(2, 2);
            this.setBounds(unionRectangle);
        }
    }

    private void createContextButtons() {
        List positionedButtons = this.getDeclaration().getPositionedContextButtons();
        this.setLayoutManager((LayoutManager)new XYLayout());
        for (PositionedContextButton positionedButton : positionedButtons) {
            Rectangle position = this.transformGenericRectangle(positionedButton.getPosition(), 0);
            position.translate(-this.getBounds().getTopLeft().x, -this.getBounds().getTopLeft().y);
            ContextButton cb = new ContextButton(this.editor.getDiagramTypeProvider().getProviderId(), positionedButton, this);
            this.add((IFigure)cb, position);
        }
    }

    IResourceRegistry getResourceRegistry() {
        return this.resourceRegistry;
    }

    private void createPathes() {
        this.pathOuterLine = this.createPath(0);
        this.pathMiddleLine = this.createPath(1);
        this.pathInnerLine = this.createPath(2);
        this.pathFill = this.createPath(3);
    }

    private void disposePathes() {
        this.pathOuterLine.dispose();
        this.pathMiddleLine.dispose();
        this.pathInnerLine.dispose();
        this.pathFill.dispose();
        this.pathOuterLine = null;
        this.pathMiddleLine = null;
        this.pathInnerLine = null;
        this.pathFill = null;
    }

    private Path createPath(int shrinkLines) {
        double zoom = this.getZoomLevel();
        int lw = shrinkLines * (int)((double)this.getDeclaration().getPadLineWidth() * zoom);
        double corner = (double)this.getDeclaration().getPadCornerRadius() * zoom;
        corner = Math.max(1.0, corner - ((double)lw + corner / 64.0));
        Rectangle topAdjusted = this.transformGenericRectangle(this.getDeclaration().getTopPad(), shrinkLines);
        Rectangle rightAdjusted = this.transformGenericRectangle(this.getDeclaration().getRightPad(), shrinkLines);
        Rectangle bottomAdjusted = this.transformGenericRectangle(this.getDeclaration().getBottomPad(), shrinkLines);
        Path path = this.createPath(topAdjusted, rightAdjusted, bottomAdjusted, (int)corner);
        return path;
    }

    private Path createPath(Rectangle topOutside, Rectangle rightOutside, Rectangle bottomOutside, int corner) {
        int appendageCorner;
        boolean hasAppendageRight;
        Path path = new Path(null);
        int innerCorner = corner / 2;
        Rectangle top = GFFigureUtil.getAdjustedRectangle(topOutside, 1.0, (int)((double)this.getDeclaration().getPadLineWidth() * this.getZoomLevel()));
        Rectangle right = GFFigureUtil.getAdjustedRectangle(rightOutside, 1.0, (int)((double)this.getDeclaration().getPadLineWidth() * this.getZoomLevel()));
        Rectangle bottom = GFFigureUtil.getAdjustedRectangle(bottomOutside, 1.0, (int)((double)this.getDeclaration().getPadLineWidth() * this.getZoomLevel()));
        boolean hasTop = top != null;
        boolean hasRight = right != null;
        boolean hasStandardTop = hasTop && this.getDeclaration().getTopPadStyle().equals((Object)IContextButtonPadDeclaration.PadStyle.STANDARD);
        boolean hasStandardRight = hasRight && this.getDeclaration().getRightPadStyle().equals((Object)IContextButtonPadDeclaration.PadStyle.STANDARD);
        boolean hasAppendageTop = hasTop && this.getDeclaration().getTopPadStyle().equals((Object)IContextButtonPadDeclaration.PadStyle.APPENDAGE);
        boolean bl = hasAppendageRight = hasRight && this.getDeclaration().getRightPadStyle().equals((Object)IContextButtonPadDeclaration.PadStyle.APPENDAGE);
        if (hasStandardTop) {
            path.addArc((float)(top.getTopRight().x - corner), (float)top.getTopRight().y, (float)corner, (float)corner, 0.0f, 90.0f);
            path.addArc((float)top.getTopLeft().x, (float)top.getTopLeft().y, (float)corner, (float)corner, 90.0f, 90.0f);
            path.addArc((float)top.getBottomLeft().x, (float)(top.getBottomLeft().y - corner), (float)corner, (float)corner, 180.0f, 90.0f);
        } else if (hasAppendageTop) {
            appendageCorner = Math.min(corner, top.height * 2);
            path.addArc((float)top.getTopLeft().x, (float)top.getTopLeft().y, (float)appendageCorner, (float)appendageCorner, 90.0f, 90.0f);
            path.lineTo((float)top.getBottomLeft().x, (float)top.getBottomLeft().y);
        } else {
            path.addArc((float)right.getTopLeft().x, (float)right.getTopLeft().y, (float)corner, (float)corner, 90.0f, 90.0f);
        }
        if (hasTop && hasRight) {
            path.addArc((float)(right.getLeft().x - innerCorner), (float)top.getBottom().y, (float)innerCorner, (float)innerCorner, 90.0f, -90.0f);
        }
        if (hasStandardRight) {
            if (bottom == null) {
                path.addArc((float)right.getBottomLeft().x, (float)(right.getBottomLeft().y - corner), (float)corner, (float)corner, 180.0f, 90.0f);
            } else {
                path.addArc((float)(right.getLeft().x - innerCorner), (float)(bottom.getTop().y - innerCorner), (float)innerCorner, (float)innerCorner, 0.0f, -90.0f);
                path.addArc((float)bottom.getTopLeft().x, (float)bottom.getTopLeft().y, (float)corner, (float)corner, 90.0f, 90.0f);
                path.addArc((float)bottom.getBottomLeft().x, (float)(bottom.getBottomLeft().y - corner), (float)corner, (float)corner, 180.0f, 90.0f);
                path.addArc((float)(bottom.getBottomRight().x - corner), (float)(bottom.getBottomRight().y - corner), (float)corner, (float)corner, 270.0f, 90.0f);
                path.addArc((float)bottom.getRight().x, (float)right.getBottom().y, (float)corner, (float)corner, 180.0f, -90.0f);
            }
            path.addArc((float)(right.getBottomRight().x - corner), (float)(right.getBottomRight().y - corner), (float)corner, (float)corner, 270.0f, 90.0f);
            path.addArc((float)(right.getTopRight().x - corner), (float)right.getTopRight().y, (float)corner, (float)corner, 0.0f, 90.0f);
        } else if (hasAppendageRight) {
            appendageCorner = Math.min(corner, right.width * 2);
            path.lineTo((float)right.getBottomLeft().x, (float)right.getBottomLeft().y);
            path.addArc((float)(right.getBottomRight().x - appendageCorner), (float)(right.getBottomRight().y - appendageCorner), (float)appendageCorner, (float)appendageCorner, 270.0f, 90.0f);
        } else {
            path.addArc((float)(top.getBottomRight().x - corner), (float)(top.getBottomRight().y - corner), (float)corner, (float)corner, 270.0f, 90.0f);
        }
        if (hasStandardTop && hasStandardRight) {
            path.addArc((float)top.getRight().x, (float)(right.getTop().y - corner), (float)corner, (float)corner, 270.0f, -90.0f);
        }
        path.close();
        return path;
    }

    private Rectangle transformGenericRectangle(java.awt.Rectangle source, int shrinkLines) {
        if (source == null) {
            return null;
        }
        double zoom = this.getZoomLevel();
        int lw = shrinkLines * (int)((double)this.getDeclaration().getPadLineWidth() * zoom);
        Rectangle target = new Rectangle(source.x, source.y, source.width, source.height);
        target.scale(zoom);
        int widthShrink = Math.min(target.width / 2, lw);
        int heightShrink = Math.min(target.height / 2, lw);
        target.shrink(widthShrink, heightShrink);
        return target;
    }

    public void addNotify() {
        super.addNotify();
        Control control = this.getEditor().getGraphicalViewer().getControl();
        control.addMouseMoveListener(this.mouseMoveListener);
        control.addMouseTrackListener(this.mouseTrackListener);
    }

    public void removeNotify() {
        Control control = this.getEditor().getGraphicalViewer().getControl();
        control.removeMouseMoveListener(this.mouseMoveListener);
        control.removeMouseTrackListener(this.mouseTrackListener);
        super.removeNotify();
        List childrenList = this.getChildren();
        for (Object object : childrenList) {
            if (!(object instanceof ContextButton)) continue;
            ((ContextButton)((Object)object)).dispose();
        }
    }

    protected void outlineShape(Graphics graphics) {
        Color outerLineSwtColor;
        Color middleLineSwtColor;
        Color innerLineSwtColor;
        int lw = (int)(this.getZoomLevel() * (double)this.getDeclaration().getPadLineWidth());
        graphics.setLineWidth(lw);
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        if (display.getHighContrast()) {
            innerLineSwtColor = display.getSystemColor(21);
            middleLineSwtColor = display.getSystemColor(21);
            outerLineSwtColor = display.getSystemColor(21);
        } else {
            IColorConstant padInnerLineColor = this.getDeclaration().getPadInnerLineColor();
            innerLineSwtColor = DataTypeTransformation.toSwtColor(this.resourceRegistry, padInnerLineColor);
            IColorConstant padMiddleLineColor = this.getDeclaration().getPadMiddleLineColor();
            middleLineSwtColor = DataTypeTransformation.toSwtColor(this.resourceRegistry, padMiddleLineColor);
            IColorConstant padOuterLineColor = this.getDeclaration().getPadOuterLineColor();
            outerLineSwtColor = DataTypeTransformation.toSwtColor(this.resourceRegistry, padOuterLineColor);
        }
        graphics.setForegroundColor(innerLineSwtColor);
        graphics.drawPath(this.pathInnerLine);
        graphics.setForegroundColor(middleLineSwtColor);
        graphics.drawPath(this.pathMiddleLine);
        graphics.setForegroundColor(outerLineSwtColor);
        graphics.drawPath(this.pathOuterLine);
    }

    public void paintFigure(Graphics graphics) {
        graphics.setAntialias(1);
        graphics.setAlpha((int)(this.currentTransparency * this.getDeclaration().getPadDefaultOpacity() * 255.0));
        this.createPathes();
        super.paintFigure(graphics);
        this.disposePathes();
    }

    protected void fillShape(Graphics graphics) {
        Color swtColor;
        int lw = (int)(this.getZoomLevel() * (double)this.getDeclaration().getPadLineWidth());
        graphics.setLineWidth(lw);
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        if (display.getHighContrast()) {
            swtColor = display.getSystemColor(22);
        } else {
            IColorConstant padFillColor = this.getDeclaration().getPadFillColor();
            swtColor = DataTypeTransformation.toSwtColor(this.resourceRegistry, padFillColor);
        }
        graphics.setForegroundColor(swtColor);
        graphics.setBackgroundColor(swtColor);
        graphics.drawPath(this.pathFill);
        graphics.fillPath(this.pathFill);
    }

    private void doAnimation() {
        long startTime = System.currentTimeMillis();
        long stepsDone = 0L;
        this.currentTransparency = 0.0;
        while (this.isPadShowing() && this.currentTransparency < 1.0) {
            this.forceRepaint();
            long elapsedTime = Math.max(1L, System.currentTimeMillis() - startTime);
            long restTime = Math.max(1L, this.animationDuration - elapsedTime);
            double restSteps = (double)(++stepsDone * restTime) / (double)elapsedTime;
            double deltaTransparency = (1.0 - this.currentTransparency) / restSteps;
            this.currentTransparency += deltaTransparency;
            if (elapsedTime <= this.animationDuration) continue;
            this.currentTransparency = 1.0;
        }
        this.currentTransparency = 1.0;
        this.forceRepaint();
    }

    private void forceRepaint() {
        if (this.isPadShowing()) {
            this.repaint();
            while (Display.getCurrent().readAndDispatch()) {
            }
        }
    }

    public boolean isMouseInOverlappingArea() {
        Point editorMouseLocation = new Point(this.getEditor().getMouseLocation());
        Point viewPortMouseLocation = this.getEditor().calculateRealMouseLocation(editorMouseLocation);
        Point mouseLocation = viewPortMouseLocation.scale(this.getZoomLevel());
        boolean containsPointOverlapping = this.containsPointOverlapping(mouseLocation.x, mouseLocation.y);
        if (!containsPointOverlapping) {
            this.getContextButtonManagerForPad().hideContextButtonsInstantly();
            return true;
        }
        return containsPointOverlapping;
    }

    public ContextButtonManagerForPad getContextButtonManagerForPad() {
        return this.contextButtonManagerForPad;
    }

    public boolean containsPoint(int x, int y) {
        boolean ret = false;
        for (Rectangle rectangle : this.containmentRectangles) {
            if (!rectangle.contains(x, y)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public boolean containsPointOverlapping(int x, int y) {
        boolean ret = false;
        for (Rectangle rectangle : this.overlappingContainmentRectangles) {
            if (!rectangle.contains(x, y)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public double getCurrentTransparency() {
        return this.currentTransparency;
    }

    private boolean isPadShowing() {
        boolean hasParent = this.getParent() != null;
        return hasParent;
    }
}

