/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.feature;

import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.graphiti.ui.internal.services.GraphitiUiInternal;

public class DebugFeature
extends AbstractCustomFeature {
    private static final String NAME_DUMP_PICTOGRAM_DATA = "Dump pictogram data";
    private static final String NAME_DUMP_FIGURE_DATA = "Dump figure data";
    private static final String NAME_DUMP_FIGURE_INCL_CONNECTION_DATA = "Dump figure data incl. connections";
    private static final String NAME_DUMP_EDIT_PART_DATA = "Dump editpart tree";
    private static final String NAME_DUMP_ALL = "Dump all data";
    private static final String NAME_REFRESH = "Refresh";
    public static final int TYPE_DUMP_PICTOGRAM_DATA = 0;
    public static final int TYPE_DUMP_FIGURE_DATA = 1;
    public static final int TYPE_DUMP_EDIT_PART_DATA = 2;
    public static final int TYPE_DUMP_ALL = 3;
    public static final int TYPE_REFRESH = 4;
    public static final int TYPE_DUMP_FIGURE_INCL_CONNECTION_DATA = 5;
    private int type;

    public DebugFeature(IFeatureProvider fp, int type) {
        super(fp);
        this.setType(type);
    }

    public void execute(ICustomContext context) {
        PictogramElement[] pes = context.getPictogramElements();
        if (pes != null && pes.length > 0 && pes[0] != null) {
            PictogramElement pe = pes[0];
            DiagramEditor diagramEditor = (DiagramEditor)this.getDiagramEditor();
            GraphicalEditPart ep = diagramEditor.getEditPartForPictogramElement(pe);
            IFigure figure = diagramEditor.getFigureForPictogramElement(pe);
            switch (this.getType()) {
                case 0: {
                    GraphitiUiInternal.getTraceService().dumpPictogramModelTree(pe);
                    break;
                }
                case 2: {
                    GraphitiUiInternal.getTraceService().dumpEditPartTree((EditPart)ep);
                    break;
                }
                case 1: {
                    GraphitiUiInternal.getTraceService().dumpFigureTree(figure);
                    break;
                }
                case 5: {
                    GraphitiUiInternal.getTraceService().dumpFigureTreeWithConnectionLayer(figure);
                    break;
                }
                case 3: {
                    GraphitiUiInternal.getTraceService().dumpPictogramModelTree(pe);
                    GraphitiUiInternal.getTraceService().dumpEditPartTree((EditPart)ep);
                    if (this.checkIfDiagram(pe)) {
                        GraphitiUiInternal.getTraceService().dumpFigureTreeWithConnectionLayer(figure);
                        break;
                    }
                    GraphitiUiInternal.getTraceService().dumpFigureTree(figure);
                    break;
                }
                case 4: {
                    ep.refresh();
                }
            }
        }
    }

    private boolean checkIfDiagram(PictogramElement pe) {
        return pe instanceof Diagram;
    }

    public boolean canExecute(ICustomContext context) {
        return true;
    }

    public String getName() {
        String ret = "";
        switch (this.getType()) {
            case 0: {
                ret = NAME_DUMP_PICTOGRAM_DATA;
                break;
            }
            case 1: {
                ret = NAME_DUMP_FIGURE_DATA;
                break;
            }
            case 5: {
                ret = NAME_DUMP_FIGURE_INCL_CONNECTION_DATA;
                break;
            }
            case 2: {
                ret = NAME_DUMP_EDIT_PART_DATA;
                break;
            }
            case 3: {
                ret = NAME_DUMP_ALL;
                break;
            }
            case 4: {
                ret = NAME_REFRESH;
            }
        }
        return ret;
    }

    protected int getType() {
        return this.type;
    }

    protected void setType(int type) {
        this.type = type;
    }
}

