/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.partfactory;

import java.util.Map;
import org.eclipse.gef.EditPart;
import org.eclipse.graphiti.internal.util.T;
import org.eclipse.graphiti.mm.pictograms.AdvancedAnchor;
import org.eclipse.graphiti.mm.pictograms.CompositeConnection;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.CurvedConnection;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.ManhattanConnection;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.ui.internal.config.AbstractConfigurationProviderHolder;
import org.eclipse.graphiti.ui.internal.config.IConfigurationProviderInternal;
import org.eclipse.graphiti.ui.internal.config.IEditPartFactory;
import org.eclipse.graphiti.ui.internal.parts.AdvancedAnchorEditPart;
import org.eclipse.graphiti.ui.internal.parts.CompositeConnectionEditPart;
import org.eclipse.graphiti.ui.internal.parts.ConnectionDecoratorEditPart;
import org.eclipse.graphiti.ui.internal.parts.ContainerShapeEditPart;
import org.eclipse.graphiti.ui.internal.parts.CurvedConnectionEditPart;
import org.eclipse.graphiti.ui.internal.parts.DiagramEditPart;
import org.eclipse.graphiti.ui.internal.parts.FreeFormConnectionEditPart;
import org.eclipse.graphiti.ui.internal.parts.IAnchorContainerEditPart;
import org.eclipse.graphiti.ui.internal.parts.ManhattanConnectionEditPart;
import org.eclipse.graphiti.ui.internal.parts.ShapeEditPart;

public class PictogramsEditPartFactory
extends AbstractConfigurationProviderHolder
implements IEditPartFactory {
    public PictogramsEditPartFactory(IConfigurationProviderInternal configurationProvider) {
        super(configurationProvider);
    }

    public EditPart createEditPart(EditPart context, Object model) {
        Shape shape;
        IAnchorContainerEditPart ret = null;
        IConfigurationProviderInternal configurationProvider = this.getConfigurationProvider();
        Map epRegistry = this.getConfigurationProvider().getDiagramEditor().getGraphicalViewer().getEditPartRegistry();
        if (epRegistry != null && epRegistry.containsKey(model)) {
            T.racer().warning("PictogramsEditPartFactory.createEditPart()", "edit part for this model already exists");
        }
        if (model instanceof Shape && !((shape = (Shape)model) instanceof Diagram) && !shape.isActive()) {
            ret = new ShapeEditPart(configurationProvider, shape);
        }
        if (ret == null) {
            if (model instanceof Diagram) {
                ret = new DiagramEditPart(configurationProvider, (Diagram)model);
            } else if (model instanceof ConnectionDecorator) {
                ret = new ConnectionDecoratorEditPart(configurationProvider, (Shape)model);
            } else if (model instanceof ContainerShape) {
                ret = new ContainerShapeEditPart(configurationProvider, (ContainerShape)model);
            } else if (model instanceof Shape) {
                ret = new ShapeEditPart(configurationProvider, (Shape)model);
            } else if (model instanceof ManhattanConnection) {
                ret = new ManhattanConnectionEditPart(configurationProvider, (Connection)((ManhattanConnection)model), context);
            } else if (model instanceof FreeFormConnection) {
                ret = new FreeFormConnectionEditPart(configurationProvider, (Connection)((FreeFormConnection)model), context);
            } else if (model instanceof CurvedConnection) {
                ret = new CurvedConnectionEditPart(configurationProvider, (CurvedConnection)model, context);
            } else if (model instanceof CompositeConnection) {
                ret = new CompositeConnectionEditPart(configurationProvider, (CompositeConnection)model, this, context);
            } else if (model instanceof AdvancedAnchor) {
                ret = new AdvancedAnchorEditPart(configurationProvider, (AdvancedAnchor)model);
            }
        }
        return ret;
    }
}

