/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.policy;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.handles.BendpointHandle;
import org.eclipse.gef.requests.BendpointRequest;
import org.eclipse.graphiti.features.IAddBendpointFeature;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IMoveBendpointFeature;
import org.eclipse.graphiti.features.IRemoveBendpointFeature;
import org.eclipse.graphiti.features.context.IAddBendpointContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.IMoveBendpointContext;
import org.eclipse.graphiti.features.context.IRemoveBendpointContext;
import org.eclipse.graphiti.features.context.impl.AddBendpointContext;
import org.eclipse.graphiti.features.context.impl.MoveBendpointContext;
import org.eclipse.graphiti.features.context.impl.RemoveBendpointContext;
import org.eclipse.graphiti.internal.command.GenericFeatureCommandWithContext;
import org.eclipse.graphiti.internal.command.ICommand;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.tb.IConnectionSelectionInfo;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;
import org.eclipse.graphiti.ui.internal.command.GefCommandWrapper;
import org.eclipse.graphiti.ui.internal.config.IConfigurationProviderInternal;
import org.eclipse.graphiti.ui.internal.figures.GFPolylineConnection;
import org.eclipse.graphiti.ui.internal.policy.BendpointEditPolicyFixed;
import org.eclipse.graphiti.ui.internal.util.draw2d.GFBendpointHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionBendpointEditPolicy
extends BendpointEditPolicyFixed {
    private static final int SNAP_TO_TOLERANCE = 15;
    private IConnectionSelectionInfo connectionSelectionInfo;

    public ConnectionBendpointEditPolicy(IConfigurationProviderInternal configurationProvider) {
        super(configurationProvider);
    }

    @Override
    public void activate() {
        super.activate();
        Object model = this.getHost().getModel();
        if (model instanceof Connection) {
            IToolBehaviorProvider tbp = this.getConfigurationProvider().getDiagramTypeProvider().getCurrentToolBehaviorProvider();
            this.connectionSelectionInfo = tbp.getSelectionInfoForConnection((Connection)model);
        }
    }

    @Override
    protected Command getCreateBendpointCommand(BendpointRequest request) {
        GefCommandWrapper ret = null;
        Object model = request.getSource().getModel();
        if (model instanceof FreeFormConnection) {
            FreeFormConnection freeFormConnection = (FreeFormConnection)model;
            int bendpointIndex = request.getIndex();
            Point location = request.getLocation();
            this.snapToAdjacentBendpoints(request, location);
            this.getConnection().translateToRelative((Translatable)location);
            AddBendpointContext context = new AddBendpointContext(freeFormConnection, location.x, location.y, bendpointIndex);
            IAddBendpointFeature addBendpointFeature = this.getFeatureProvider().getAddBendpointFeature((IAddBendpointContext)context);
            if (addBendpointFeature != null) {
                ret = new GefCommandWrapper((ICommand)new GenericFeatureCommandWithContext((IFeature)addBendpointFeature, (IContext)context), this.getConfigurationProvider().getDiagramEditor().getEditingDomain());
            }
        }
        this.saveOriginalConstraint();
        return ret;
    }

    @Override
    protected Command getDeleteBendpointCommand(BendpointRequest request) {
        GefCommandWrapper ret = null;
        Object model = request.getSource().getModel();
        if (model instanceof FreeFormConnection) {
            FreeFormConnection freeFormConnection = (FreeFormConnection)model;
            int bendpointIndex = request.getIndex();
            org.eclipse.graphiti.mm.algorithms.styles.Point bendpoint = (org.eclipse.graphiti.mm.algorithms.styles.Point)freeFormConnection.getBendpoints().get(bendpointIndex);
            RemoveBendpointContext context = new RemoveBendpointContext(freeFormConnection, bendpoint);
            context.setBendpointIndex(bendpointIndex);
            IRemoveBendpointFeature removeBendpointFeature = this.getFeatureProvider().getRemoveBendpointFeature((IRemoveBendpointContext)context);
            if (removeBendpointFeature != null) {
                ret = new GefCommandWrapper((ICommand)new GenericFeatureCommandWithContext((IFeature)removeBendpointFeature, (IContext)context), this.getConfigurationProvider().getDiagramEditor().getEditingDomain());
            }
        }
        return ret;
    }

    @Override
    protected Command getMoveBendpointCommand(BendpointRequest request) {
        GefCommandWrapper ret = null;
        ConnectionEditPart source = request.getSource();
        Object model = source.getModel();
        if (model instanceof FreeFormConnection) {
            FreeFormConnection freeFormConnection = (FreeFormConnection)model;
            int bendpointIndex = request.getIndex();
            org.eclipse.graphiti.mm.algorithms.styles.Point bendpoint = (org.eclipse.graphiti.mm.algorithms.styles.Point)freeFormConnection.getBendpoints().get(bendpointIndex);
            Point location = request.getLocation();
            this.snapToAdjacentBendpoints(request, location);
            this.getConnection().translateToRelative((Translatable)location);
            int requestX = location.x;
            int requestY = location.y;
            MoveBendpointContext context = new MoveBendpointContext(bendpoint);
            context.setBendpointIndex(bendpointIndex);
            context.setConnection(freeFormConnection);
            context.setX(requestX);
            context.setY(requestY);
            IMoveBendpointFeature moveBendpointFeature = this.getFeatureProvider().getMoveBendpointFeature((IMoveBendpointContext)context);
            if (moveBendpointFeature != null) {
                ret = new GefCommandWrapper((ICommand)new GenericFeatureCommandWithContext((IFeature)moveBendpointFeature, (IContext)context), this.getConfigurationProvider().getDiagramEditor().getEditingDomain());
            }
        }
        this.saveOriginalConstraint();
        return ret;
    }

    @Override
    protected void showCreateBendpointFeedback(BendpointRequest request) {
        List<Bendpoint> constraint;
        this.refreshConnectionBendpoints();
        Point p = new Point(request.getLocation());
        this.getConnection().translateToRelative((Translatable)p);
        AbsoluteBendpoint bp = new AbsoluteBendpoint(p);
        if (this.originalConstraint == null) {
            this.saveOriginalConstraint();
            constraint = this.getConnectionRoutingConstraint();
            constraint.add(request.getIndex(), (Bendpoint)bp);
        } else {
            constraint = this.getConnectionRoutingConstraint();
        }
        this.snapToAdjacentBendpoints(request, bp.getLocation());
        if (constraint.size() > 0 && request.getIndex() < constraint.size()) {
            constraint.set(request.getIndex(), (Bendpoint)bp);
        } else {
            constraint.add((Bendpoint)bp);
        }
        this.getConnection().setRoutingConstraint(constraint);
    }

    @Override
    protected void showMoveBendpointFeedback(BendpointRequest request) {
        this.refreshConnectionBendpoints();
        this.snapToAdjacentBendpoints(request, request.getLocation());
        super.showMoveBendpointFeedback(request);
    }

    @Override
    protected List<BendpointHandle> createHandlesForAutomaticBendpoints() {
        ArrayList<BendpointHandle> list = new ArrayList<BendpointHandle>();
        ConnectionEditPart connEP = (ConnectionEditPart)this.getHost();
        PointList points = this.getConnection().getPoints();
        int i = 0;
        while (i < points.size() - 1) {
            list.add(new GFBendpointHandle(connEP, 0, i, this.getConfigurationProvider(), GFBendpointHandle.Type.CREATE, this.connectionSelectionInfo));
            ++i;
        }
        return list;
    }

    @Override
    protected List<BendpointHandle> createHandlesForUserBendpoints() {
        ArrayList<BendpointHandle> list = new ArrayList<BendpointHandle>();
        ConnectionEditPart connEP = (ConnectionEditPart)this.getHost();
        PointList points = this.getConnection().getPoints();
        List bendPoints = this.getConnectionRoutingConstraint();
        int bendPointIndex = 0;
        Point currBendPoint = null;
        if (bendPoints == null) {
            bendPoints = NULL_CONSTRAINT;
        } else if (!bendPoints.isEmpty()) {
            currBendPoint = ((Bendpoint)bendPoints.get(0)).getLocation();
        }
        int i = 0;
        while (i < points.size() - 1) {
            list.add(new GFBendpointHandle(connEP, bendPointIndex, i, this.getConfigurationProvider(), GFBendpointHandle.Type.CREATE, this.connectionSelectionInfo));
            if (i < points.size() - 1 && bendPointIndex < bendPoints.size() && currBendPoint.equals((Object)points.getPoint(i + 1))) {
                list.add(new GFBendpointHandle(connEP, bendPointIndex, i + 1, this.getConfigurationProvider(), GFBendpointHandle.Type.MOVE, this.connectionSelectionInfo));
                if (++bendPointIndex < bendPoints.size()) {
                    currBendPoint = ((Bendpoint)bendPoints.get(bendPointIndex)).getLocation();
                }
            }
            ++i;
        }
        return list;
    }

    @Override
    protected void setReferencePoints(BendpointRequest request) {
        PointList points = this.getConnection().getPoints();
        int bpIndex = request.getIndex() + 1;
        points.getPoint(ref1, bpIndex - 1);
        this.getConnection().translateToAbsolute((Translatable)ref1);
        points.getPoint(ref2, bpIndex + 1);
        this.getConnection().translateToAbsolute((Translatable)ref2);
    }

    private void snapToAdjacentBendpoints(BendpointRequest request, Point p) {
        IFigure f = request.getSource().getFigure();
        if (!(f instanceof GFPolylineConnection)) {
            return;
        }
        GFPolylineConnection plc = (GFPolylineConnection)f;
        PointList points = plc.getPoints();
        Point predecessor = points.getPoint(request.getIndex()).getCopy();
        this.getConnection().translateToAbsolute((Translatable)predecessor);
        int deltaPredecessor = this.getDistanceBetweenPoints(p, predecessor);
        int successorIndex = request.getIndex() + 2 >= points.size() ? request.getIndex() + 1 : request.getIndex() + 2;
        Point successor = points.getPoint(successorIndex).getCopy();
        this.getConnection().translateToAbsolute((Translatable)successor);
        int deltaSuccessor = this.getDistanceBetweenPoints(p, successor);
        if (request.getIndex() == 0) {
            deltaPredecessor = Integer.MAX_VALUE;
        }
        if (request.getIndex() == ((List)this.getConnection().getRoutingConstraint()).size() - 1) {
            deltaSuccessor = Integer.MAX_VALUE;
        }
        if (deltaPredecessor < 15 && deltaPredecessor <= deltaSuccessor) {
            p.setLocation(predecessor);
            return;
        }
        if (deltaSuccessor < 15) {
            p.setLocation(successor);
            return;
        }
        int xDeltaPredecessor = Math.abs(predecessor.x - p.x);
        int yDeltaPredecessor = Math.abs(predecessor.y - p.y);
        int xDeltaSuccessor = Math.abs(successor.x - p.x);
        int yDeltaSuccessor = Math.abs(successor.y - p.y);
        if (xDeltaPredecessor < 15 && xDeltaPredecessor <= xDeltaSuccessor) {
            p.setLocation(predecessor.x, p.y);
        } else if (xDeltaSuccessor < 15) {
            p.setLocation(successor.x, p.y);
        }
        if (yDeltaPredecessor < 15 && yDeltaPredecessor <= yDeltaSuccessor) {
            p.setLocation(p.x, predecessor.y);
        } else if (yDeltaSuccessor < 15) {
            p.setLocation(p.x, successor.y);
        }
    }

    private int getDistanceBetweenPoints(Point p1, Point p2) {
        int dx = Math.abs(p1.x - p2.x);
        int dy = Math.abs(p1.y - p2.y);
        int distance = dx + dy;
        return distance;
    }

    private void refreshConnectionBendpoints() {
        this.getConnection().getConnectionRouter().route(this.getConnection());
    }

    protected void showSelection() {
        IMoveBendpointFeature moveBendpointFeature = this.getFeatureProvider().getMoveBendpointFeature((IMoveBendpointContext)new MoveBendpointContext(null));
        if (moveBendpointFeature != null) {
            super.showSelection();
        }
    }
}

