/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.util.ui.print;

import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.graphiti.internal.util.T;
import org.eclipse.graphiti.ui.internal.Messages;
import org.eclipse.graphiti.ui.internal.util.ui.DoubleFieldWithDropDown;
import org.eclipse.graphiti.ui.internal.util.ui.print.AbstractFigureSelectionDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportDiagramDialog
extends AbstractFigureSelectionDialog
implements ModifyListener {
    private String[] IMAGE_FILE_EXTENSIONS = new String[]{"BMP", "GIF", "JPG", "PNG", "RLE"};
    private int[] IMAGE_FILE_TYPES;
    public static final String[] WIDTHS = new String[]{"320", "640", "800", "1024", "1280", "1600"};
    public static final String[] HEIGHTS = new String[]{"200", "400", "600", "768", "1024", "1280"};
    public static final double[] SCALE_FACTORS = new double[]{0.5, 1.0, 2.0, 4.0};
    private Combo _formatCombo;
    private Combo _widthCombo;
    private Combo _heightCombo;
    private DoubleFieldWithDropDown _scaleFactorText;
    private int _formatIndex;
    private Map<String, Boolean> additionalExporterTypes;

    public ExportDiagramDialog(Shell shell, GraphicalViewer graphicalViewer) {
        super(shell, graphicalViewer);
        int[] nArray = new int[5];
        nArray[1] = 2;
        nArray[2] = 4;
        nArray[3] = 5;
        nArray[4] = 1;
        this.IMAGE_FILE_TYPES = nArray;
        this._formatIndex = 0;
    }

    public void addExporters(Map<String, Boolean> diagramExporterTypes) {
        this.additionalExporterTypes = diagramExporterTypes;
        ArrayList<String> asList = new ArrayList<String>();
        String[] stringArray = this.IMAGE_FILE_EXTENSIONS;
        int n = this.IMAGE_FILE_EXTENSIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            asList.add(string);
            ++n2;
        }
        for (String string : diagramExporterTypes.keySet()) {
            asList.add(string);
        }
        this.IMAGE_FILE_EXTENSIONS = asList.toArray(new String[0]);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        this.createChooseFigureGroup(composite);
        Group scaleGroup = this.createChooseScaleFactorGroup(composite);
        Label widthComboText = new Label((Composite)scaleGroup, 0);
        widthComboText.setText(Messages.SaveFigureAsImageDialog_0_xfld);
        this._widthCombo = new Combo((Composite)scaleGroup, 4);
        this._widthCombo.setItems(WIDTHS);
        this._widthCombo.addModifyListener((ModifyListener)this);
        GridData data = new GridData(768);
        this._widthCombo.setLayoutData((Object)data);
        Label heightComboText = new Label((Composite)scaleGroup, 0);
        heightComboText.setText(Messages.SaveFigureAsImageDialog_1_xfld);
        this._heightCombo = new Combo((Composite)scaleGroup, 4);
        this._heightCombo.setItems(HEIGHTS);
        this._heightCombo.addModifyListener((ModifyListener)this);
        GridData data2 = new GridData(768);
        this._heightCombo.setLayoutData((Object)data2);
        new Label((Composite)scaleGroup, 4);
        this.createFormatGroup(composite);
        this.updateControls();
        return composite;
    }

    @Override
    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.SaveFigureAsImageDialog_5_xtxt);
    }

    private void createFormatGroup(Composite composite) {
        Group formatGroup = new Group(composite, 0);
        formatGroup.setText(Messages.SaveFigureAsImageDialog_2_xfld);
        formatGroup.setLayout((Layout)new GridLayout(2, false));
        GridData layoutData = new GridData();
        layoutData.grabExcessVerticalSpace = true;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.verticalAlignment = 4;
        layoutData.horizontalAlignment = 4;
        formatGroup.setLayoutData((Object)layoutData);
        this._formatCombo = new Combo((Composite)formatGroup, 12);
        this._formatCombo.setItems(this.IMAGE_FILE_EXTENSIONS);
        this._formatCombo.setText(this.IMAGE_FILE_EXTENSIONS[this._formatIndex]);
        this._formatCombo.addModifyListener((ModifyListener)this);
        GridData data3 = new GridData();
        data3.grabExcessHorizontalSpace = true;
        data3.horizontalAlignment = 4;
        this._formatCombo.setLayoutData((Object)data3);
    }

    private Group createChooseScaleFactorGroup(Composite composite) {
        Group scaleGroup = new Group(composite, 0);
        scaleGroup.setText(Messages.SaveFigureAsImageDialog_3_xfld);
        GridData data = new GridData(768);
        data.horizontalSpan = 1;
        data.verticalSpan = 2;
        data.verticalAlignment = 16;
        data.grabExcessVerticalSpace = true;
        scaleGroup.setLayoutData((Object)data);
        GridLayout layout = new GridLayout(2, false);
        scaleGroup.setLayout((Layout)layout);
        Label scaleFactorText = new Label((Composite)scaleGroup, 0);
        scaleFactorText.setText(Messages.SaveFigureAsImageDialog_4_xfld);
        this._scaleFactorText = new DoubleFieldWithDropDown((Composite)scaleGroup, 0, this._preferences, 4, SCALE_FACTORS);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this._scaleFactorText.setLayoutData(data);
        this._scaleFactorText.addModifyListener(this);
        return scaleGroup;
    }

    public void modifyText(ModifyEvent e) {
        if (this._insideInternalModify) {
            return;
        }
        if (e.getSource() == this._formatCombo) {
            this._formatIndex = this._formatCombo.getSelectionIndex();
            String format = this._formatCombo.getText();
            Boolean b = !this.additionalExporterTypes.containsKey(format) || this.additionalExporterTypes.get(format) != false;
            this.setControlsEnabled(b);
        } else if (e.getSource() == this._widthCombo) {
            try {
                int width;
                String text = this._widthCombo.getText();
                if (text.length() == 0) {
                    text = "0";
                }
                if ((width = Integer.parseInt(text)) < 0) {
                    throw new NumberFormatException(String.valueOf(Messages.ExportDiagramDialog_0) + width);
                }
                this._preferences.setDoublePreference(4, (double)width / (double)this._figure.getBounds().width);
            }
            catch (NumberFormatException x) {
                T.racer().debug(x.getMessage());
            }
            this.updateControls();
        } else if (e.getSource() == this._heightCombo) {
            try {
                int height;
                String text = this._heightCombo.getText();
                if (text.length() == 0) {
                    text = "0";
                }
                if ((height = Integer.parseInt(text)) < 0) {
                    throw new NumberFormatException(String.valueOf(Messages.ExportDiagramDialog_1) + height);
                }
                this._preferences.setDoublePreference(4, (double)height / (double)this._figure.getBounds().height);
            }
            catch (NumberFormatException x) {
                T.racer().debug(x.getMessage());
            }
            this.updateControls();
        } else {
            this.updateControls();
        }
    }

    private void setControlsEnabled(boolean b) {
        this._heightCombo.setEnabled(b);
        this._widthCombo.setEnabled(b);
        this._scaleFactorText.setEnabled(b);
    }

    @Override
    public void updateControls() {
        super.updateControls();
        this._insideInternalModify = true;
        try {
            double scaleFactor = this._preferences.getDoublePreference(4);
            String newText = Long.toString(Math.round(scaleFactor * (double)this._figure.getBounds().width));
            if (!newText.equals(this._widthCombo.getText())) {
                this._widthCombo.setText(newText);
            }
            if (!(newText = Long.toString(Math.round(scaleFactor * (double)this._figure.getBounds().height))).equals(this._heightCombo.getText())) {
                this._heightCombo.setText(newText);
            }
            this._scaleFactorText.updateControl();
        }
        finally {
            this._insideInternalModify = false;
        }
    }

    protected void okPressed() {
        if (this.getImageFormat() == 5) {
            this.setScaledImage(this.getImageScaleFactor(), 10000.0);
        } else {
            this.setScaledImage(this.getImageScaleFactor());
        }
        super.okPressed();
    }

    public final int getImageFormat() {
        if (this._formatIndex >= this.IMAGE_FILE_TYPES.length) {
            return -1;
        }
        return this.IMAGE_FILE_TYPES[this._formatIndex];
    }

    public final String getFormattedFileExtension() {
        return this.IMAGE_FILE_EXTENSIONS[this._formatIndex].toLowerCase(Locale.ENGLISH);
    }

    public final String getFileExtension() {
        return this.IMAGE_FILE_EXTENSIONS[this._formatIndex];
    }

    public double getImageScaleFactor() {
        return this._preferences.getDoublePreference(4);
    }
}

