/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.editor;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.editor.DefaultRefreshBehavior;
import org.eclipse.graphiti.ui.editor.DefaultUpdateBehavior;
import org.eclipse.graphiti.ui.editor.DiagramBehavior;
import org.eclipse.graphiti.ui.editor.GraphicalComposite;
import org.eclipse.graphiti.ui.editor.IDiagramContainerUI;
import org.eclipse.graphiti.ui.editor.IDiagramEditorInput;
import org.eclipse.graphiti.ui.internal.services.GraphitiUiInternal;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;

public class DiagramComposite
extends GraphicalComposite
implements IDiagramContainerUI {
    private DiagramBehavior diagramBehavior;
    private IWorkbenchPart ownedPart;

    public DiagramComposite(IWorkbenchPart ownedPart, Composite parent, int style) {
        super(parent, style);
        this.ownedPart = ownedPart;
        this.setEditDomain(new DefaultEditDomain(null));
    }

    public DiagramComposite(Composite parent, int style) {
        this(null, parent, style);
    }

    protected DiagramBehavior createDiagramBehavior(IWorkbenchPart parentPart) {
        DiagramBehavior diagramBehavior = new DiagramBehavior(this);
        diagramBehavior.setParentPart(parentPart);
        diagramBehavior.initDefaultBehaviors();
        return diagramBehavior;
    }

    public void setInput(IDiagramEditorInput input) {
        TransactionalEditingDomain editingDomain = GraphitiUiInternal.getEmfService().createResourceSetAndEditingDomain();
        this.setInput(editingDomain, input);
    }

    public void setInput(TransactionalEditingDomain editingDomain, IDiagramEditorInput input) {
        if (this.diagramBehavior == null) {
            this.diagramBehavior = this.createDiagramBehavior(this.ownedPart);
        }
        this.getUpdateBehavior().setEditingDomain(editingDomain);
        this.diagramBehavior.setInput(input);
        if (this.diagramBehavior.getEditorInitializationError() != null) {
            this.diagramBehavior.createErrorPartControl(this);
            return;
        }
        this.diagramBehavior.getUpdateBehavior().init();
        this.init();
        this.diagramBehavior.migrateDiagramModelIfNecessary();
        this.diagramBehavior.addGefListeners();
    }

    public void initializeGraphicalViewer() {
        super.initializeGraphicalViewer();
        this.diagramBehavior.initializeGraphicalViewer();
    }

    protected void createGraphicalViewer() {
        this.diagramBehavior.createGraphicalViewer(this);
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        this.diagramBehavior.configureGraphicalViewer();
    }

    public void refreshTitle() {
    }

    public void refreshTitleToolTip() {
    }

    public void updateDirtyState() {
    }

    public IWorkbenchPart getWorkbenchPart() {
        return this.diagramBehavior.getParentPart();
    }

    public void close() {
    }

    public Object getAdapter(Class type) {
        Object returnObj = this.diagramBehavior.getAdapter(type);
        if (returnObj != null) {
            return returnObj;
        }
        return super.getAdapter(type);
    }

    public void dispose() {
        if (this.getWorkbenchPart() != null && this.getWorkbenchPart().getSite() != null && this.getWorkbenchPart().getSite().getPage() != null) {
            this.getWorkbenchPart().getSite().getPage().removeSelectionListener((ISelectionListener)this);
        }
        if (this.diagramBehavior != null) {
            this.diagramBehavior.disposeBeforeGefDispose();
        }
        RuntimeException exc = null;
        try {
            super.dispose();
        }
        catch (RuntimeException e) {
            exc = e;
        }
        if (this.diagramBehavior != null) {
            this.diagramBehavior.disposeAfterGefDispose();
        }
        if (exc != null) {
            throw exc;
        }
    }

    public boolean setFocus() {
        if (this.getGraphicalViewer() == null) {
            return false;
        }
        if (super.setFocus()) {
            this.diagramBehavior.getUpdateBehavior().handleActivate();
            return true;
        }
        return false;
    }

    public final DefaultUpdateBehavior getUpdateBehavior() {
        return this.diagramBehavior.getUpdateBehavior();
    }

    public final DefaultRefreshBehavior getRefreshBehavior() {
        return this.diagramBehavior.getRefreshBehavior();
    }

    public void editingDomainInitialized() {
        this.diagramBehavior.editingDomainInitialized();
    }

    public void disableAdapters() {
        this.diagramBehavior.disableAdapters();
    }

    public void enableAdapters() {
        this.diagramBehavior.enableAdapters();
    }

    public boolean isDirty() {
        return this.diagramBehavior.isDirty();
    }

    protected final PaletteViewerProvider createPaletteViewerProvider() {
        return this.diagramBehavior.createPaletteViewerProvider();
    }

    protected final FlyoutPaletteComposite.FlyoutPreferences getPalettePreferences() {
        return this.diagramBehavior.getPalettePreferences();
    }

    protected final PaletteRoot getPaletteRoot() {
        return this.diagramBehavior.getPaletteRoot();
    }

    public PictogramElement[] getSelectedPictogramElements() {
        return this.diagramBehavior.getSelectedPictogramElements();
    }

    public void selectPictogramElements(PictogramElement[] pictogramElements) {
        this.diagramBehavior.selectPictogramElements(pictogramElements);
    }

    public void setPictogramElementForSelection(PictogramElement pictogramElement) {
        this.diagramBehavior.setPictogramElementForSelection(pictogramElement);
    }

    public void setPictogramElementsForSelection(PictogramElement[] pictogramElements) {
        this.diagramBehavior.setPictogramElementsForSelection(pictogramElements);
    }

    public IDiagramTypeProvider getDiagramTypeProvider() {
        return this.diagramBehavior.getDiagramTypeProvider();
    }

    public GraphicalEditPart getEditPartForPictogramElement(PictogramElement pe) {
        return this.diagramBehavior.getEditPartForPictogramElement(pe);
    }

    public double getZoomLevel() {
        return this.diagramBehavior.getZoomLevel();
    }

    public boolean isAlive() {
        return this.diagramBehavior.isAlive();
    }

    public boolean isDirectEditingActive() {
        return this.diagramBehavior.isDirectEditingActive();
    }

    public void setDirectEditingActive(boolean directEditingActive) {
        this.diagramBehavior.setDirectEditingActive(directEditingActive);
    }

    public IDiagramEditorInput getDiagramEditorInput() {
        return this.diagramBehavior.getInput();
    }

    public IWorkbenchPartSite getSite() {
        return this.getWorkbenchPart().getSite();
    }

    public String getTitle() {
        return this.getWorkbenchPart().getTitle();
    }

    public String getTitleToolTip() {
        return this.getWorkbenchPart().getTitleToolTip();
    }

    public void doSave(IProgressMonitor monitor) {
        this.diagramBehavior.getPersistencyBehavior().saveDiagram(monitor);
    }

    public DiagramBehavior getDiagramBehavior() {
        return this.diagramBehavior;
    }
}

