/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.action;

import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.ui.actions.PrintAction;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IPrintFeature;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.IPrintContext;
import org.eclipse.graphiti.features.context.impl.PrintContext;
import org.eclipse.graphiti.internal.command.GenericFeatureCommandWithContext;
import org.eclipse.graphiti.internal.command.ICommand;
import org.eclipse.graphiti.platform.IDiagramBehavior;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.graphiti.ui.internal.command.GefCommandWrapper;
import org.eclipse.graphiti.ui.platform.IConfigurationProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class PrintGraphicalViewerAction
extends PrintAction {
    private static IAction TEMPLATE_ACTION = ActionFactory.PRINT.create(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
    private IConfigurationProvider configurationProvider;
    private long lastPrinterCheckTime = 0L;
    private boolean cachedEnabled = true;

    public PrintGraphicalViewerAction(IDiagramBehavior diagramBehavior, IConfigurationProvider configurationProvider) {
        super(((DiagramEditor)diagramBehavior.getDiagramContainer()).getWorkbenchPart());
        this.configurationProvider = configurationProvider;
        this.setId(TEMPLATE_ACTION.getId());
        this.setText(TEMPLATE_ACTION.getText());
        this.setToolTipText(TEMPLATE_ACTION.getToolTipText());
        this.setDescription(TEMPLATE_ACTION.getDescription());
        this.setAccelerator(TEMPLATE_ACTION.getAccelerator());
        this.setHelpListener(TEMPLATE_ACTION.getHelpListener());
        this.setImageDescriptor(TEMPLATE_ACTION.getImageDescriptor());
        this.setHoverImageDescriptor(TEMPLATE_ACTION.getHoverImageDescriptor());
        this.setDisabledImageDescriptor(TEMPLATE_ACTION.getDisabledImageDescriptor());
    }

    protected boolean calculateEnabled() {
        IFeatureProvider featureProvider = this.getFeatureProvider();
        if (featureProvider == null) {
            return false;
        }
        IPrintFeature feature = featureProvider.getPrintFeature();
        IPrintContext context = this.createPrintContext();
        if (feature == null || !feature.canPrint(context)) {
            return false;
        }
        if (this.getWorkbenchPart().getAdapter(GraphicalViewer.class) == null) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        long diffTime = (currentTime - this.lastPrinterCheckTime) / 1000L;
        if (diffTime > 300L) {
            this.lastPrinterCheckTime = currentTime;
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    PrintGraphicalViewerAction.this.cachedEnabled = PrintGraphicalViewerAction.super.calculateEnabled();
                }
            });
        }
        return this.cachedEnabled;
    }

    public void run() {
        IPrintContext context = this.createPrintContext();
        IFeatureProvider featureProvider = this.getFeatureProvider();
        IPrintFeature feature = featureProvider.getPrintFeature();
        if (feature != null) {
            GenericFeatureCommandWithContext command = new GenericFeatureCommandWithContext((IFeature)feature, (IContext)context);
            this.executeOnCommandStack((ICommand)command);
        }
    }

    private IPrintContext createPrintContext() {
        PrintContext context = new PrintContext();
        return context;
    }

    private IFeatureProvider getFeatureProvider() {
        return this.configurationProvider.getDiagramTypeProvider().getFeatureProvider();
    }

    private void executeOnCommandStack(ICommand command) {
        CommandStack commandStack = this.configurationProvider.getDiagramEditor().getEditDomain().getCommandStack();
        GefCommandWrapper wrapperCommand = new GefCommandWrapper(command, this.configurationProvider.getDiagramBehavior().getEditingDomain());
        commandStack.execute((Command)wrapperCommand);
    }
}

