/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.util.draw2d;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.handles.AbstractHandle;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.tb.IShapeSelectionInfo;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;
import org.eclipse.graphiti.ui.internal.config.IConfigurationProviderInternal;
import org.eclipse.graphiti.ui.internal.util.draw2d.GFCornerHandle;
import org.eclipse.graphiti.ui.internal.util.draw2d.GFSurroundingHandle;
import org.eclipse.graphiti.ui.platform.IConfigurationProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GFHandleHelper {
    public static double getZoomLevel(IConfigurationProvider configurationProvider) {
        double zoom = 1.0;
        return zoom;
    }

    public static List<AbstractHandle> createShapeHandles(GraphicalEditPart owner, IConfigurationProviderInternal cp, int supportedResizeDirections, boolean movable, boolean resizeAllowed) {
        ArrayList<AbstractHandle> list = new ArrayList<AbstractHandle>();
        IShapeSelectionInfo si = null;
        IToolBehaviorProvider tbp = cp.getDiagramTypeProvider().getCurrentToolBehaviorProvider();
        Object model = owner.getModel();
        if (model instanceof Shape) {
            si = tbp.getSelectionInfoForShape((Shape)model);
        } else if (model instanceof Anchor) {
            si = tbp.getSelectionInfoForAnchor((Anchor)model);
        }
        list.add(new GFSurroundingHandle(owner, cp, movable, si));
        if (resizeAllowed) {
            if ((0x11 & supportedResizeDirections) != 0) {
                list.add(new GFCornerHandle(owner, cp, 17, supportedResizeDirections, movable, si));
            }
            if ((0x14 & supportedResizeDirections) != 0) {
                list.add(new GFCornerHandle(owner, cp, 20, supportedResizeDirections, movable, si));
            }
            if ((0xC & supportedResizeDirections) != 0) {
                list.add(new GFCornerHandle(owner, cp, 12, supportedResizeDirections, movable, si));
            }
            if ((9 & supportedResizeDirections) != 0) {
                list.add(new GFCornerHandle(owner, cp, 9, supportedResizeDirections, movable, si));
            }
            if ((1 & supportedResizeDirections) != 0) {
                list.add(new GFCornerHandle(owner, cp, 1, supportedResizeDirections, movable, si));
            }
            if ((0x10 & supportedResizeDirections) != 0) {
                list.add(new GFCornerHandle(owner, cp, 16, supportedResizeDirections, movable, si));
            }
            if ((4 & supportedResizeDirections) != 0) {
                list.add(new GFCornerHandle(owner, cp, 4, supportedResizeDirections, movable, si));
            }
            if ((8 & supportedResizeDirections) != 0) {
                list.add(new GFCornerHandle(owner, cp, 8, supportedResizeDirections, movable, si));
            }
        }
        return list;
    }
}

