/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.tb;

import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.internal.util.T;
import org.eclipse.graphiti.platform.IDiagramBehavior;
import org.eclipse.graphiti.tb.IContextEntry;

public class AbstractContextEntry
implements IContextEntry {
    private IContext context;
    private IFeature feature;
    private String iconId;
    private String text;
    private String description;

    public AbstractContextEntry(IFeature feature, IContext context) {
        this.setFeature(feature);
        this.setContext(context);
        if (feature instanceof ICustomFeature) {
            this.setIconId(((ICustomFeature)feature).getImageId());
        }
    }

    public boolean canExecute() {
        if (this.getFeature() == null) {
            return false;
        }
        return this.getFeature().canExecute(this.getContext());
    }

    public void execute() {
        IDiagramBehavior diagramBehavior = this.getFeature().getFeatureProvider().getDiagramTypeProvider().getDiagramBehavior();
        try {
            diagramBehavior.executeFeature(this.getFeature(), this.getContext());
        }
        catch (Exception e) {
            if (e instanceof RollbackException) {
                T.racer().log(1, "GFCommandStack.execute(Command) " + e, e);
            }
            T.racer().error("GFCommandStack.execute(Command) " + e, e);
        }
    }

    public IContext getContext() {
        return this.context;
    }

    public IFeature getFeature() {
        return this.feature;
    }

    public String getIconId() {
        return this.iconId;
    }

    public String getText() {
        IFeature f;
        String ret = this.text;
        if (ret == null && (f = this.getFeature()) instanceof ICustomFeature) {
            ICustomFeature customFeature = (ICustomFeature)f;
            ret = customFeature.getName();
        }
        return ret;
    }

    public String getDescription() {
        IFeature f;
        String ret = this.description;
        if (ret == null && (f = this.getFeature()) instanceof ICustomFeature) {
            ICustomFeature customFeature = (ICustomFeature)f;
            ret = customFeature.getDescription();
        }
        return ret;
    }

    private void setContext(IContext context) {
        this.context = context;
    }

    private void setFeature(IFeature feature) {
        this.feature = feature;
    }

    public void setIconId(String iconId) {
        this.iconId = iconId;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setDescription(String text) {
        this.description = text;
    }
}

