/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.features;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.ISaveImageFeature;
import org.eclipse.graphiti.features.context.ISaveImageContext;
import org.eclipse.graphiti.features.impl.AbstractSaveImageFeature;
import org.eclipse.graphiti.internal.util.T;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.graphiti.ui.internal.platform.ExtensionManager;
import org.eclipse.graphiti.ui.internal.services.GraphitiUiInternal;
import org.eclipse.graphiti.ui.internal.util.ui.print.ExportDiagramDialog;
import org.eclipse.graphiti.ui.internal.util.ui.print.IDiagramsExporter;
import org.eclipse.graphiti.ui.saveasimage.ISaveAsImageConfiguration;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSaveImageFeature
extends AbstractSaveImageFeature
implements ISaveImageFeature {
    public DefaultSaveImageFeature(IFeatureProvider fp) {
        super(fp);
    }

    public void save(ISaveImageContext context) {
        String filename;
        GraphicalViewer viewer = this.getGraphicalViewer(context);
        ISaveAsImageConfiguration saveAsImageConfiguration = this.getSaveAsImageConfiguration(viewer);
        if (saveAsImageConfiguration.configure() == 0 && (filename = this.getFilename(viewer, saveAsImageConfiguration)) != null) {
            Shell shell = GraphitiUiInternal.getWorkbenchService().getShell();
            try {
                filename = this.addFileExtension(saveAsImageConfiguration.getFormattedFileExtension(), filename);
                IRunnableWithProgress operation = this.getSaveAsImageOperation(saveAsImageConfiguration, filename);
                new ProgressMonitorDialog(shell).run(false, false, operation);
            }
            catch (InterruptedException e) {
                T.racer().warning("Save as image operation was cancelled by user");
            }
            catch (Exception e) {
                String message = "Cannot save image: ";
                MessageDialog.openError((Shell)shell, (String)"Cannot save image", (String)(String.valueOf(message) + e.getMessage()));
                T.racer().error(message, (Throwable)e);
            }
        }
    }

    protected GraphicalViewer getGraphicalViewer(ISaveImageContext context) {
        DiagramEditor diagramEditor = (DiagramEditor)this.getDiagramEditor();
        return (GraphicalViewer)diagramEditor.getAdapter(GraphicalViewer.class);
    }

    protected ISaveAsImageConfiguration getSaveAsImageConfiguration(GraphicalViewer viewer) {
        Shell shell = GraphitiUiInternal.getWorkbenchService().getShell();
        ExportDiagramDialog saveAsImageDialog = new ExportDiagramDialog(shell, viewer);
        saveAsImageDialog.addExporters(this.getDiagramExporters());
        return saveAsImageDialog;
    }

    protected String getFilename(GraphicalViewer viewer, ISaveAsImageConfiguration saveAsImageConfiguration) {
        Shell shell = GraphitiUiInternal.getWorkbenchService().getShell();
        FileDialog fileDialog = new FileDialog(shell, 8192);
        String[] fileExtensions = new String[]{"*." + saveAsImageConfiguration.getFormattedFileExtension()};
        fileDialog.setFilterExtensions(fileExtensions);
        String name = ((Diagram)viewer.getContents().getModel()).getName();
        fileDialog.setFileName(name);
        String filename = fileDialog.open();
        return filename;
    }

    protected String addFileExtension(String extension, String filename) {
        Path path = new Path(filename);
        if (path.getFileExtension() == null) {
            filename = String.valueOf(filename) + "." + extension;
        }
        return filename;
    }

    protected IRunnableWithProgress getSaveAsImageOperation(ISaveAsImageConfiguration saveAsImageConfiguration, String filename) {
        IRunnableWithProgress operation = null;
        String imageExtension = saveAsImageConfiguration.getFileExtension();
        operation = this.getDiagramExporters().containsKey(imageExtension) ? this.getSaveAsImageOperationForNonStandardExporter(saveAsImageConfiguration, filename) : this.getSaveAsImageOperationForStandardExporter(saveAsImageConfiguration, filename);
        return operation;
    }

    protected IRunnableWithProgress getSaveAsImageOperationForNonStandardExporter(final ISaveAsImageConfiguration saveAsImageConfiguration, final String filename) {
        String imageExtension = saveAsImageConfiguration.getFileExtension();
        final IDiagramsExporter exporter = ExtensionManager.getSingleton().getDiagramExporterForType(imageExtension);
        Assert.isNotNull((Object)exporter);
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    exporter.export(saveAsImageConfiguration.getScaledImage(), saveAsImageConfiguration.getFigure(), filename, saveAsImageConfiguration.getImageScaleFactor());
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        return operation;
    }

    protected IRunnableWithProgress getSaveAsImageOperationForStandardExporter(ISaveAsImageConfiguration saveAsImageConfiguration, final String filename) {
        int imageFormat = saveAsImageConfiguration.getImageFormat();
        final byte[] imageBytes = this.convertImageToBytes(saveAsImageConfiguration.getScaledImage(), imageFormat);
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                FileOutputStream outputStream = null;
                try {
                    try {
                        outputStream = new FileOutputStream(filename);
                        outputStream.write(imageBytes);
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    try {
                        outputStream.close();
                    }
                    catch (Exception x) {
                        T.racer().error("close output stream failed", (Throwable)x);
                    }
                }
            }
        };
        return operation;
    }

    protected Map<String, Boolean> getDiagramExporters() {
        Map<String, Boolean> diagramExporterTypes = ExtensionManager.getSingleton().getDiagramExporterTypes();
        return diagramExporterTypes;
    }

    private byte[] convertImageToBytes(Image image, int format) {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            try {
                ImageData imDat = null;
                if (format == 2) {
                    imDat = this.create8BitIndexedPaletteImage(image);
                }
                if (imDat == null) {
                    imDat = image.getImageData();
                }
                ImageLoader imageLoader = new ImageLoader();
                imageLoader.data = new ImageData[]{imDat};
                try {
                    imageLoader.save((OutputStream)result, format);
                }
                catch (SWTException e) {
                    String error = "Depth: " + Integer.toString(image.getImageData().depth) + "\n" + "X: " + Integer.toString(image.getImageData().x) + "\n" + "Y: " + Integer.toString(image.getImageData().y);
                    throw new IllegalStateException(error, e);
                }
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        finally {
            image.dispose();
        }
        return result.toByteArray();
    }

    private ImageData create8BitIndexedPaletteImage(Image image) {
        int upperboundWidth = image.getBounds().width;
        int upperboundHeight = image.getBounds().height;
        ImageData imageData = image.getImageData();
        ArrayList<Integer> colors = new ArrayList<Integer>();
        int x = 0;
        while (x < upperboundWidth) {
            int y = 0;
            while (y < upperboundHeight) {
                int color = imageData.getPixel(x, y);
                Integer colorInteger = new Integer(color);
                if (!colors.contains(colorInteger)) {
                    colors.add(colorInteger);
                }
                ++y;
            }
            ++x;
        }
        if (colors.size() > 256) {
            throw new IllegalStateException("Image contains more than 256 colors. \n Automated color reduction is currently not supported.");
        }
        RGB[] rgbs = new RGB[256];
        int i = 0;
        while (i < 256) {
            rgbs[i] = new RGB(255, 255, 255);
            ++i;
        }
        i = 0;
        while (i < colors.size()) {
            int pixelValue = (Integer)colors.get(i);
            int red = (pixelValue & imageData.palette.redMask) >>> Math.abs(imageData.palette.redShift);
            int green = (pixelValue & imageData.palette.greenMask) >>> Math.abs(imageData.palette.greenShift);
            int blue = (pixelValue & imageData.palette.blueMask) >>> Math.abs(imageData.palette.blueShift);
            rgbs[i] = new RGB(red, green, blue);
            ++i;
        }
        PaletteData palette = new PaletteData(rgbs);
        ImageData newImageData = new ImageData(imageData.width, imageData.height, 8, palette);
        int x2 = 0;
        while (x2 < upperboundWidth) {
            int y = 0;
            while (y < upperboundHeight) {
                int color = imageData.getPixel(x2, y);
                newImageData.setPixel(x2, y, colors.indexOf(new Integer(color)));
                ++y;
            }
            ++x2;
        }
        return newImageData;
    }
}

