/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.services.impl;

import org.eclipse.core.runtime.Assert;
import org.eclipse.graphiti.internal.util.T;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.platform.IDiagramContainer;
import org.eclipse.graphiti.ui.editor.DiagramEditorInput;
import org.eclipse.graphiti.ui.internal.GraphitiUIPlugin;
import org.eclipse.graphiti.ui.internal.services.IWorkbenchService;
import org.eclipse.graphiti.ui.services.GraphitiUi;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorActionBarContributor;

public class WorkbenchService
implements IWorkbenchService {
    public IStatusLineManager getActiveStatusLineManager() {
        IEditorPart editorPart;
        IEditorActionBarContributor contributor;
        IWorkbenchPart activePart = this.getActiveOrFirstWorkbenchWindow().getActivePage().getActivePart();
        if (activePart instanceof IViewPart) {
            IViewPart viewPart = (IViewPart)activePart;
            return viewPart.getViewSite().getActionBars().getStatusLineManager();
        }
        if (activePart instanceof IEditorPart && (contributor = (editorPart = (IEditorPart)activePart).getEditorSite().getActionBarContributor()) instanceof EditorActionBarContributor) {
            EditorActionBarContributor editorContributor = (EditorActionBarContributor)contributor;
            return editorContributor.getActionBars().getStatusLineManager();
        }
        return new StatusLineManager();
    }

    public IWorkbenchWindow getActiveOrFirstWorkbenchWindow() {
        IWorkbenchWindow[] windows;
        IWorkbenchWindow result = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (result == null && (windows = PlatformUI.getWorkbench().getWorkbenchWindows()) != null && windows.length > 0) {
            result = windows[0];
        }
        return result;
    }

    public IDiagramContainer openDiagramEditor(Diagram diagram) {
        IDiagramContainer ret = null;
        String providerId = GraphitiUi.getExtensionManager().getDiagramTypeProviderId(diagram.getDiagramTypeId());
        ret = this.openDiagramEditor(diagram, providerId);
        return ret;
    }

    public IDiagramContainer openDiagramEditor(Diagram diagram, String providerId) {
        return this.openDiagramEditor(diagram, providerId, "org.eclipse.graphiti.ui.editor.DiagramEditor");
    }

    public IDiagramContainer openDiagramEditor(Diagram diagram, String providerId, String editorId) {
        IDiagramContainer ret = null;
        DiagramEditorInput diagramEditorInput = DiagramEditorInput.createEditorInput(diagram, providerId);
        IWorkbenchPage workbenchPage = WorkbenchService.getActivePage();
        try {
            Assert.isNotNull((Object)workbenchPage);
            IEditorPart editorPart = workbenchPage.openEditor((IEditorInput)diagramEditorInput, editorId);
            if (editorPart instanceof IDiagramContainer) {
                ret = (IDiagramContainer)editorPart;
            }
        }
        catch (PartInitException e) {
            T.racer().error(e.toString());
        }
        return ret;
    }

    private static IWorkbenchPage getActivePage() {
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (workbenchWindow != null) {
            return workbenchWindow.getActivePage();
        }
        return null;
    }

    public Shell getShell() {
        return GraphitiUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
    }
}

