/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.ui.internal.figures.GFAbstractRotatableDecoration;
import org.eclipse.graphiti.ui.internal.figures.GFFigureUtil;
import org.eclipse.graphiti.ui.internal.parts.IPictogramElementDelegate;
import org.eclipse.swt.graphics.Path;

public class GFEllipseDecoration
extends GFAbstractRotatableDecoration
implements RotatableDecoration {
    private Point initialTouchPoint = null;

    public GFEllipseDecoration(IPictogramElementDelegate pictogramElementDelegate, GraphicsAlgorithm graphicsAlgorithm) {
        super(pictogramElementDelegate, graphicsAlgorithm);
        this.initialTouchPoint = new Point(0, this.getInitialBounds().height / 2);
        this.initialTouchPoint.translate(-graphicsAlgorithm.getX(), -graphicsAlgorithm.getY());
    }

    protected Point getInitialTouchPoint() {
        return this.initialTouchPoint;
    }

    public boolean containsPointInInitialFigure(int x, int y) {
        return Boolean.TRUE.equals(GFFigureUtil.containsPointInEllipse(this.getInitialBounds(), x, y));
    }

    protected Path createPath(Rectangle outerBounds, Graphics graphics, boolean isFill) {
        Path path = new Path(null);
        float x = outerBounds.x;
        float y = outerBounds.y;
        float height = outerBounds.height;
        float width = outerBounds.width;
        path.moveTo(x, y);
        path.addArc(x, y, width, height, 0.0f, 360.0f);
        return path;
    }
}

