/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.util.ui.print;

import org.eclipse.draw2d.PrintFigureOperation;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.graphiti.ui.internal.Messages;
import org.eclipse.graphiti.ui.internal.util.ui.DoubleField;
import org.eclipse.graphiti.ui.internal.util.ui.DoubleFieldWithDropDown;
import org.eclipse.graphiti.ui.internal.util.ui.print.AbstractFigureSelectionDialog;
import org.eclipse.graphiti.ui.print.IPrintConfiguration;
import org.eclipse.graphiti.ui.print.IPrintPreferences;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class PrintFigureDialog
extends AbstractFigureSelectionDialog
implements IPrintConfiguration,
ModifyListener,
PaintListener {
    private static final String COLON = ":";
    private static final int BEST_FIT = 0;
    private static final int SCALE_XY = 1;
    private static final int SCALE_STRETCH = 3;
    private static final int CUSTOM_SIZE = 4;
    public static final String decimalNumberFormat = "###0.00";
    private static final int PREVIEW_SIZE = 220;
    public static final double[] SCALE_FACTORS = new double[]{0.5, 1.0, 2.0, 4.0};
    private static final double INCH_TO_CM_FACTOR = 2.54;
    private static final int WARNING_IF_MOREPAGES_THAN = 5;
    private static final int BUTTON_CHANGE_PRINTERDATA_ID = 1025;
    private Printer _printer;
    private double _dpiScale;
    private DoubleFieldWithDropDown _widthScaleText;
    private DoubleFieldWithDropDown _heightScaleText;
    private Button _pixelScaleButton;
    private Button _dpiScaleButton;
    private Canvas _preview;
    private Composite _previewGroup;
    private DoubleField _leftMarginText;
    private DoubleField _topMarginText;
    private Button _centerButton;
    private Button _customScalingButton;
    private Button _bestFitButton;
    private Button _customSizeButton;
    private DoubleField _customWidthText;
    private DoubleField _customHeightText;
    private Label _numberOfPagesInfo;
    private Button _cmButton;
    private Button _inchesButton;
    private Button _aspectRatioButton;
    private double _currentScale;
    private double _aspectRatio;
    private boolean _center = false;
    private boolean _inches = true;
    private boolean _aspectRatioOn = true;
    private int _sizeMode = 1;

    public PrintFigureDialog(Shell shell, GraphicalViewer graphicalViewer, Printer printer) {
        super(shell, graphicalViewer);
        this.setScaledImage(1.0);
        this._printer = printer;
        this._currentScale = this._dpiScale = (double)this._printer.getDPI().x / (double)Display.getCurrent().getDPI().x;
        this._aspectRatio = this._image != null ? (double)this._image.getBounds().width / (double)this._image.getBounds().height : 1.0;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1025, Messages.PrintFigureDialog_0_xfld, false);
        super.createButtonsForButtonBar(parent);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.PrintFigureDialog_3_xfld);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        this.createChooseFigureGroup(composite);
        this._previewGroup = this.createPreviewGroup(composite);
        this.createChooseSizeGroup(composite);
        this.createPositionGroup(composite);
        this.createUnitGroup(composite);
        this.aspectRatioOnChanged();
        this.updateControls();
        return composite;
    }

    public void updateControls() {
        super.updateControls();
        this._insideInternalModify = true;
        try {
            this._widthScaleText.updateControl();
            this._heightScaleText.updateControl();
            this._customWidthText.updateControl();
            this._customHeightText.updateControl();
            this._leftMarginText.setEnabled(!this._center && this._sizeMode != 3);
            this._topMarginText.setEnabled(!this._center && this._sizeMode != 3);
            this._widthScaleText.setEnabled(this._sizeMode == 1);
            this._heightScaleText.setEnabled(this._sizeMode == 1);
            this._customWidthText.setEnabled(this._sizeMode == 4);
            this._customHeightText.setEnabled(this._sizeMode == 4);
            this._inchesButton.setEnabled((this._sizeMode == 4 || !this._center) && this._sizeMode != 3);
            this._cmButton.setEnabled((this._sizeMode == 4 || !this._center) && this._sizeMode != 3);
            this._preview.redraw();
        }
        finally {
            this._insideInternalModify = false;
        }
    }

    public void paintControl(PaintEvent e) {
        Rectangle printRegion = this.getPrintRegion();
        org.eclipse.swt.graphics.Rectangle previewRegion = this._preview.getClientArea();
        Point size = this.getScaledImageSize(printRegion, previewRegion);
        Point margins = this.determineMargins(printRegion, previewRegion, size.x, size.y);
        if (this._image != null) {
            e.gc.drawImage(this._image, 0, 0, this._image.getBounds().width, this._image.getBounds().height, margins.x, margins.y, size.x, size.y);
            e.gc.drawRectangle(margins.x, margins.y, size.x - 1, size.y - 1);
        } else {
            e.gc.drawText(Messages.PrintFigureDialog_39_xmsg, 1, 1);
        }
        this.adjustPrinterValuesUsingPreview(margins.x, margins.y, size.x, size.y, printRegion, previewRegion);
    }

    private Group createUnitGroup(Composite composite) {
        Group unitGroup = new Group(composite, 0);
        unitGroup.setText(Messages.PrintFigureDialog_4_xfld);
        GridLayout layout = new GridLayout(1, false);
        unitGroup.setLayout((Layout)layout);
        unitGroup.setLayoutData((Object)new GridData(4, 128, true, false));
        this._cmButton = new Button((Composite)unitGroup, 16);
        this._cmButton.setText(Messages.PrintFigureDialog_5_xfld);
        GridData data3 = new GridData(768);
        this._cmButton.setLayoutData((Object)data3);
        this._cmButton.addSelectionListener((SelectionListener)this);
        this._inchesButton = new Button((Composite)unitGroup, 16);
        this._inchesButton.setText(Messages.PrintFigureDialog_6_xfld);
        GridData data2 = new GridData(768);
        this._inchesButton.setLayoutData((Object)data2);
        this._inchesButton.addSelectionListener((SelectionListener)this);
        Label info = new Label((Composite)unitGroup, 0);
        info.setText(Messages.PrintFigureDialog_7_xfld);
        info.setLayoutData((Object)new GridData(32));
        this._cmButton.setSelection(false);
        this._inchesButton.setSelection(true);
        return unitGroup;
    }

    private Composite createPreviewGroup(Composite composite) {
        Composite previewGroup = new Composite(composite, 0);
        previewGroup.setLayout((Layout)new GridLayout(1, false));
        GridData grid = new GridData(4, 128, true, false);
        grid.verticalSpan = 4;
        previewGroup.setLayoutData((Object)grid);
        Label previewLabel = new Label(previewGroup, 0);
        previewLabel.setText(String.valueOf(Messages.PrintFigureDialog_8_xfld) + COLON);
        previewLabel.setLayoutData((Object)new GridData(2));
        this._preview = new Canvas(previewGroup, 2048);
        GridData previewGrid = new GridData(2);
        previewGrid.widthHint = 220;
        previewGrid.heightHint = (int)(220.0 * ((double)this._printer.getClientArea().height / (double)this._printer.getClientArea().width));
        previewGrid.verticalSpan = 1;
        this._preview.setLayoutData((Object)previewGrid);
        this._preview.setBackground(this._preview.getDisplay().getSystemColor(1));
        this._preview.addPaintListener((PaintListener)this);
        this._numberOfPagesInfo = new Label(previewGroup, 0);
        this._numberOfPagesInfo.setLayoutData((Object)new GridData(642));
        this.refreshOutputPagesInfo();
        return previewGroup;
    }

    private void refreshOutputPagesInfo() {
        String text = String.valueOf(Messages.PrintFigureDialog_9_xmsg) + " " + this.getNumberOfPages();
        this._numberOfPagesInfo.setText(text);
        this._numberOfPagesInfo.getParent().layout();
    }

    private Group createChooseSizeGroup(Composite composite) {
        Group scaleGroup = new Group(composite, 0);
        scaleGroup.setText(Messages.PrintFigureDialog_11_xfld);
        GridLayout layout = new GridLayout(3, false);
        scaleGroup.setLayout((Layout)layout);
        scaleGroup.setLayoutData((Object)new GridData(4, 128, true, false));
        this._bestFitButton = new Button((Composite)scaleGroup, 16);
        this._bestFitButton.addSelectionListener((SelectionListener)this);
        this._bestFitButton.setText(Messages.PrintFigureDialog_12_xfld);
        new Label((Composite)scaleGroup, 0);
        new Label((Composite)scaleGroup, 0);
        this._customScalingButton = new Button((Composite)scaleGroup, 16);
        this._customScalingButton.addSelectionListener((SelectionListener)this);
        this._customScalingButton.setSelection(true);
        this._customScalingButton.setText(String.valueOf(Messages.PrintFigureDialog_14_xfld) + COLON);
        Label widthComboText = new Label((Composite)scaleGroup, 0);
        widthComboText.setText(String.valueOf(Messages.PrintFigureDialog_16_xfld) + ": ");
        widthComboText.setLayoutData((Object)new GridData(128));
        this._widthScaleText = new DoubleFieldWithDropDown((Composite)scaleGroup, 0, this._preferences, 0, SCALE_FACTORS);
        this._widthScaleText.setLayoutData(new GridData(768));
        this._widthScaleText.addModifyListener(this);
        new Label((Composite)scaleGroup, 0);
        Label heightComboText = new Label((Composite)scaleGroup, 0);
        heightComboText.setText(String.valueOf(Messages.PrintFigureDialog_20_xfld) + ": ");
        heightComboText.setLayoutData((Object)new GridData(128));
        this._heightScaleText = new DoubleFieldWithDropDown((Composite)scaleGroup, 0, this._preferences, 1, SCALE_FACTORS);
        this._heightScaleText.setLayoutData(new GridData(768));
        this._heightScaleText.addModifyListener(this);
        this._customSizeButton = new Button((Composite)scaleGroup, 16);
        this._customSizeButton.addSelectionListener((SelectionListener)this);
        this._customSizeButton.setText(String.valueOf(Messages.PrintFigureDialog_23_xfld) + COLON);
        Label customWidthText = new Label((Composite)scaleGroup, 0);
        customWidthText.setText(String.valueOf(Messages.PrintFigureDialog_26_xfld) + ": ");
        customWidthText.setLayoutData((Object)new GridData(128));
        this._customWidthText = new DoubleField((Composite)scaleGroup, 0, this._preferences, 10);
        this._customWidthText.setLayoutData(new GridData(768));
        this._customWidthText.addModifyListener(this);
        new Label((Composite)scaleGroup, 0);
        Label customHeightText = new Label((Composite)scaleGroup, 0);
        customHeightText.setText(String.valueOf(Messages.PrintFigureDialog_28_xfld) + ": ");
        customHeightText.setLayoutData((Object)new GridData(128));
        this._customHeightText = new DoubleField((Composite)scaleGroup, 0, this._preferences, 11);
        this._customHeightText.setLayoutData(new GridData(768));
        this._customHeightText.addModifyListener(this);
        this._aspectRatioButton = new Button((Composite)scaleGroup, 32);
        this._aspectRatioButton.addSelectionListener((SelectionListener)this);
        this._aspectRatioButton.setSelection(this._aspectRatioOn);
        this._aspectRatioButton.setText(Messages.PrintFigureDialog_17_xfld);
        return scaleGroup;
    }

    private Group createPositionGroup(Composite parent) {
        Group posGroup = new Group(parent, 0);
        posGroup.setText(Messages.PrintFigureDialog_18_xfld);
        GridLayout layout = new GridLayout(2, false);
        posGroup.setLayout((Layout)layout);
        posGroup.setLayoutData((Object)new GridData(4, 128, true, false));
        Label leftMargin = new Label((Composite)posGroup, 0);
        leftMargin.setText(String.valueOf(Messages.PrintFigureDialog_30_xfld) + ": ");
        this._leftMarginText = new DoubleField((Composite)posGroup, 0, this._preferences, 2);
        GridData data2 = new GridData(768);
        this._leftMarginText.setLayoutData(data2);
        this._leftMarginText.addModifyListener(this);
        Label topMargin = new Label((Composite)posGroup, 0);
        topMargin.setText(String.valueOf(Messages.PrintFigureDialog_32_xfld) + ": ");
        this._topMarginText = new DoubleField((Composite)posGroup, 0, this._preferences, 3);
        GridData data3 = new GridData(768);
        this._topMarginText.setLayoutData(data3);
        this._topMarginText.addModifyListener(this);
        this._centerButton = new Button((Composite)posGroup, 32);
        this._centerButton.addSelectionListener((SelectionListener)this);
        this._centerButton.setText(Messages.PrintFigureDialog_34_xfld);
        new Label((Composite)posGroup, 0);
        return posGroup;
    }

    public void buttonPressed(int buttonID) {
        super.buttonPressed(buttonID);
        if (buttonID == 1025) {
            PrintDialog printDialog = new PrintDialog(this.getShell(), 0);
            PrinterData printData = printDialog.open();
            if (!this._printer.getPrinterData().equals(printData)) {
                this._printer = new Printer(printData);
                ((GridData)this._preview.getLayoutData()).widthHint = 220;
                ((GridData)this._preview.getLayoutData()).heightHint = (int)(220.0 * ((double)this._printer.getClientArea().height / (double)this._printer.getClientArea().width));
                this._previewGroup.layout();
            }
        }
    }

    public void modifyText(ModifyEvent e) {
        if (this._insideInternalModify) {
            return;
        }
        if (this._aspectRatioOn) {
            if (e.getSource() == this._customWidthText.getText()) {
                double width = this._preferences.getDoublePreference(10);
                this._preferences.setDoublePreference(11, width / this._aspectRatio);
            }
            if (e.getSource() == this._customHeightText.getText()) {
                double height = this._preferences.getDoublePreference(11);
                this._preferences.setDoublePreference(10, height * this._aspectRatio);
            }
            if (e.getSource() == this._heightScaleText.getText() && this._aspectRatioOn) {
                this._preferences.setDoublePreference(0, this._preferences.getDoublePreference(1));
            }
            if (e.getSource() == this._widthScaleText.getText()) {
                this._preferences.setDoublePreference(1, this._preferences.getDoublePreference(0));
            }
        }
        this.updateControls();
    }

    public void widgetSelected(SelectionEvent e) {
        super.widgetSelected(e);
        if (this._insideInternalModify) {
            return;
        }
        if (e.getSource() == this._pixelScaleButton || e.getSource() == this._dpiScaleButton) {
            this._currentScale = this._pixelScaleButton.getSelection() ? 1.0 : this._dpiScale;
            this._preferences.setDoublePreference(5, this._currentScale);
        }
        if (e.getSource() == this._centerButton) {
            this._center = this._centerButton.getSelection();
        }
        if (e.getSource() == this._customScalingButton) {
            this._sizeMode = 1;
        }
        if (e.getSource() == this._bestFitButton) {
            this._sizeMode = this._aspectRatioOn ? 0 : 3;
        }
        if (e.getSource() == this._customSizeButton) {
            this._sizeMode = 4;
        }
        if (e.getSource() == this._cmButton || e.getSource() == this._inchesButton) {
            this._inches = this._inchesButton.getSelection();
        }
        if (e.getSource() == this._aspectRatioButton) {
            this.aspectRatioOnChanged();
        }
        this.updateControls();
    }

    protected void okPressed() {
        int numOfPages = this.getNumberOfPages();
        boolean proceed = true;
        if (numOfPages > 5) {
            String pagesText = String.valueOf(Messages.PrintFigureDialog_10_xmsg) + " " + numOfPages;
            proceed = MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.PrintFigureDialog_22_xfld, (String)(String.valueOf(pagesText) + " \n" + Messages.PrintFigureDialog_25_xfld));
        }
        if (proceed) {
            this.setScaledImage(this.getMaximumOfXYImageScaleFactors());
            super.okPressed();
        }
    }

    public double getPrinterScaleFactor() {
        return this._preferences.getDoublePreference(4) * this._currentScale;
    }

    public IPrintPreferences getPreferences() {
        return this._preferences;
    }

    public double getCurrentScale() {
        return this._currentScale;
    }

    public Printer getPrinter() {
        return this._printer;
    }

    private Rectangle getPrintRegion() {
        PrintFigureOperation operation = new PrintFigureOperation(this._printer, this._figure);
        Rectangle printRegion = operation.getPrintRegion();
        return printRegion;
    }

    private Point getScaledImageSize(Rectangle printRegion, org.eclipse.swt.graphics.Rectangle previewRegion) {
        int imageWidth = (int)((double)this._figure.getBounds().width / (double)printRegion.width * (double)previewRegion.width);
        int imageHeight = (int)((double)this._figure.getBounds().height / (double)printRegion.height * (double)previewRegion.height);
        if (this._sizeMode == 1) {
            return new Point((int)((double)imageWidth * this.getPrinterScaleFactorX()), (int)((double)imageHeight * this.getPrinterScaleFactorY()));
        }
        if (this._sizeMode == 0) {
            double widthRatio = (double)imageWidth * this._currentScale / (double)previewRegion.width;
            double heightRatio = (double)imageHeight * this._currentScale / (double)previewRegion.height;
            if (widthRatio > heightRatio) {
                return new Point(previewRegion.width, (int)(1.0 / widthRatio * (double)imageHeight * this._currentScale));
            }
            return new Point((int)(1.0 / heightRatio * (double)imageWidth * this._currentScale), previewRegion.height);
        }
        if (this._sizeMode == 3) {
            return new Point(previewRegion.width, previewRegion.height);
        }
        if (this._sizeMode == 4) {
            org.eclipse.swt.graphics.Point printerDPI = this._printer.getDPI();
            double widthInInches = (double)printRegion.width / (double)printerDPI.x;
            double heightInInches = (double)printRegion.height / (double)printerDPI.y;
            double width = this._preferences.getDoublePreference(10);
            double height = this._preferences.getDoublePreference(11);
            width = (double)previewRegion.width * (width / widthInInches);
            height = (double)previewRegion.height * (height / heightInInches);
            if (this._inches) {
                return new Point((int)width, (int)height);
            }
            return new Point((int)(width / 2.54), (int)(height / 2.54));
        }
        throw new IllegalArgumentException(String.valueOf(Messages.PrintFigureDialog_38_xfld) + this._sizeMode);
    }

    private double getPrinterScaleFactorX() {
        return this._preferences.getDoublePreference(0) * this._currentScale;
    }

    private double getPrinterScaleFactorY() {
        return this._preferences.getDoublePreference(1) * this._currentScale;
    }

    private Point determineMargins(Rectangle printRegion, org.eclipse.swt.graphics.Rectangle previewRegion, int imageWidthScaled, int imageHeightScaled) {
        if (!this._center && this._sizeMode != 3) {
            double leftMarginPreference = this._preferences.getDoublePreference(2);
            double topMarginPreference = this._preferences.getDoublePreference(3);
            int leftMargin = (int)(leftMarginPreference * (double)printRegion.width / (double)previewRegion.width);
            int topMargin = (int)(topMarginPreference * (double)printRegion.height / (double)previewRegion.height);
            if (!this._inches) {
                leftMargin = (int)((double)leftMargin / 2.54);
                topMargin = (int)((double)topMargin / 2.54);
            }
            return new Point(leftMargin, topMargin);
        }
        if (this._center && this._sizeMode != 3) {
            int topMargin;
            int leftMargin = (int)((double)(previewRegion.width - imageWidthScaled) / 2.0);
            if (leftMargin < 0) {
                leftMargin = 0;
            }
            if ((topMargin = (int)((double)(previewRegion.height - imageHeightScaled) / 2.0)) < 0) {
                topMargin = 0;
            }
            return new Point(leftMargin, topMargin);
        }
        int leftMargin = 0;
        int topMargin = 0;
        return new Point(leftMargin, topMargin);
    }

    private void adjustPrinterValuesUsingPreview(int leftMargin, int topMargin, int imageWidthScaled, int imageHeightScaled, Rectangle printRegion, org.eclipse.swt.graphics.Rectangle previewRegion) {
        double printerImageWidth = (double)imageWidthScaled * (double)printRegion.width / (double)previewRegion.width;
        double printerImageHeight = (double)imageHeightScaled * (double)printRegion.height / (double)previewRegion.height;
        double printerLeftMargin = (double)leftMargin * (double)printRegion.width / (double)previewRegion.width;
        double printerTopMargin = (double)topMargin * (double)printRegion.height / (double)previewRegion.height;
        this._preferences.setDoublePreference(6, printerImageWidth);
        this._preferences.setDoublePreference(7, printerImageHeight);
        this._preferences.setDoublePreference(8, printerLeftMargin);
        this._preferences.setDoublePreference(9, printerTopMargin);
        this.refreshOutputPagesInfo();
    }

    private int getNumberOfPages() {
        double width = this._preferences.getDoublePreference(6);
        double height = this._preferences.getDoublePreference(7);
        double left = this._preferences.getDoublePreference(8);
        double top = this._preferences.getDoublePreference(9);
        Rectangle clientSize = this.getPrintRegion();
        int numberOfPages = (int)Math.ceil((width += left) / (double)clientSize.width) * (int)Math.ceil((height += top) / (double)clientSize.height);
        return numberOfPages;
    }

    public double getMaximumOfXYImageScaleFactors() {
        double height;
        double heightScale;
        double width = this._preferences.getDoublePreference(6);
        double widthScale = width / (double)this._figure.getBounds().width;
        return widthScale > (heightScale = (height = this._preferences.getDoublePreference(7)) / (double)this._figure.getBounds().height) ? widthScale : heightScale;
    }

    private void aspectRatioOnChanged() {
        this._aspectRatioOn = this._aspectRatioButton.getSelection();
        if (this._aspectRatioOn) {
            double width = this._preferences.getDoublePreference(10);
            this._preferences.setDoublePreference(11, width / this._aspectRatio);
        }
        if (this._aspectRatioOn && this._sizeMode == 3) {
            this._sizeMode = 0;
        }
        if (!this._aspectRatioOn && this._sizeMode == 0) {
            this._sizeMode = 3;
        }
        if (this._aspectRatioOn && this._sizeMode == 1) {
            this._preferences.setDoublePreference(1, this._preferences.getDoublePreference(0));
        }
    }

    public int configure() {
        return this.open();
    }
}

