/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.mm.algorithms.styles.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.graphiti.mm.algorithms.styles.AdaptedGradientColoredAreas;
import org.eclipse.graphiti.mm.algorithms.styles.Color;
import org.eclipse.graphiti.mm.algorithms.styles.Font;
import org.eclipse.graphiti.mm.algorithms.styles.GradientColoredArea;
import org.eclipse.graphiti.mm.algorithms.styles.GradientColoredAreas;
import org.eclipse.graphiti.mm.algorithms.styles.GradientColoredLocation;
import org.eclipse.graphiti.mm.algorithms.styles.LineStyle;
import org.eclipse.graphiti.mm.algorithms.styles.LocationType;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.algorithms.styles.PrecisionPoint;
import org.eclipse.graphiti.mm.algorithms.styles.RenderingStyle;
import org.eclipse.graphiti.mm.algorithms.styles.Style;
import org.eclipse.graphiti.mm.algorithms.styles.StylesFactory;
import org.eclipse.graphiti.mm.algorithms.styles.StylesPackage;
import org.eclipse.graphiti.mm.algorithms.styles.TextStyle;
import org.eclipse.graphiti.mm.algorithms.styles.TextStyleRegion;
import org.eclipse.graphiti.mm.algorithms.styles.UnderlineStyle;
import org.eclipse.graphiti.mm.algorithms.styles.impl.AdaptedGradientColoredAreasImpl;
import org.eclipse.graphiti.mm.algorithms.styles.impl.ColorImpl;
import org.eclipse.graphiti.mm.algorithms.styles.impl.FontImpl;
import org.eclipse.graphiti.mm.algorithms.styles.impl.GradientColoredAreaImpl;
import org.eclipse.graphiti.mm.algorithms.styles.impl.GradientColoredAreasImpl;
import org.eclipse.graphiti.mm.algorithms.styles.impl.GradientColoredLocationImpl;
import org.eclipse.graphiti.mm.algorithms.styles.impl.PointImpl;
import org.eclipse.graphiti.mm.algorithms.styles.impl.PrecisionPointImpl;
import org.eclipse.graphiti.mm.algorithms.styles.impl.RenderingStyleImpl;
import org.eclipse.graphiti.mm.algorithms.styles.impl.StyleImpl;
import org.eclipse.graphiti.mm.algorithms.styles.impl.TextStyleImpl;
import org.eclipse.graphiti.mm.algorithms.styles.impl.TextStyleRegionImpl;

public class StylesFactoryImpl
extends EFactoryImpl
implements StylesFactory {
    public static StylesFactory init() {
        try {
            StylesFactory theStylesFactory = (StylesFactory)EPackage.Registry.INSTANCE.getEFactory("http://eclipse.org/graphiti/mm/algorithms/styles");
            if (theStylesFactory != null) {
                return theStylesFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new StylesFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createRenderingStyle();
            }
            case 1: {
                return this.createStyle();
            }
            case 3: {
                return this.createGradientColoredLocation();
            }
            case 4: {
                return this.createGradientColoredArea();
            }
            case 5: {
                return this.createGradientColoredAreas();
            }
            case 6: {
                return this.createAdaptedGradientColoredAreas();
            }
            case 7: {
                return this.createFont();
            }
            case 8: {
                return this.createPoint();
            }
            case 9: {
                return this.createColor();
            }
            case 10: {
                return this.createPrecisionPoint();
            }
            case 11: {
                return this.createTextStyle();
            }
            case 12: {
                return this.createTextStyleRegion();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 13: {
                return this.createLineStyleFromString(eDataType, initialValue);
            }
            case 14: {
                return this.createOrientationFromString(eDataType, initialValue);
            }
            case 15: {
                return this.createLocationTypeFromString(eDataType, initialValue);
            }
            case 16: {
                return this.createUnderlineStyleFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 13: {
                return this.convertLineStyleToString(eDataType, instanceValue);
            }
            case 14: {
                return this.convertOrientationToString(eDataType, instanceValue);
            }
            case 15: {
                return this.convertLocationTypeToString(eDataType, instanceValue);
            }
            case 16: {
                return this.convertUnderlineStyleToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public RenderingStyle createRenderingStyle() {
        RenderingStyleImpl renderingStyle = new RenderingStyleImpl();
        return renderingStyle;
    }

    public Style createStyle() {
        StyleImpl style = new StyleImpl();
        return style;
    }

    public GradientColoredLocation createGradientColoredLocation() {
        GradientColoredLocationImpl gradientColoredLocation = new GradientColoredLocationImpl();
        return gradientColoredLocation;
    }

    public GradientColoredArea createGradientColoredArea() {
        GradientColoredAreaImpl gradientColoredArea = new GradientColoredAreaImpl();
        return gradientColoredArea;
    }

    public GradientColoredAreas createGradientColoredAreas() {
        GradientColoredAreasImpl gradientColoredAreas = new GradientColoredAreasImpl();
        return gradientColoredAreas;
    }

    public AdaptedGradientColoredAreas createAdaptedGradientColoredAreas() {
        AdaptedGradientColoredAreasImpl adaptedGradientColoredAreas = new AdaptedGradientColoredAreasImpl();
        return adaptedGradientColoredAreas;
    }

    public Font createFont() {
        FontImpl font = new FontImpl();
        return font;
    }

    public Point createPoint() {
        PointImpl point = new PointImpl();
        return point;
    }

    public Color createColor() {
        ColorImpl color = new ColorImpl();
        return color;
    }

    public PrecisionPoint createPrecisionPoint() {
        PrecisionPointImpl precisionPoint = new PrecisionPointImpl();
        return precisionPoint;
    }

    public TextStyle createTextStyle() {
        TextStyleImpl textStyle = new TextStyleImpl();
        return textStyle;
    }

    public TextStyleRegion createTextStyleRegion() {
        TextStyleRegionImpl textStyleRegion = new TextStyleRegionImpl();
        return textStyleRegion;
    }

    public LineStyle createLineStyleFromString(EDataType eDataType, String initialValue) {
        LineStyle result = LineStyle.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertLineStyleToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public Orientation createOrientationFromString(EDataType eDataType, String initialValue) {
        Orientation result = Orientation.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertOrientationToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public LocationType createLocationTypeFromString(EDataType eDataType, String initialValue) {
        LocationType result = LocationType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertLocationTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public UnderlineStyle createUnderlineStyleFromString(EDataType eDataType, String initialValue) {
        UnderlineStyle result = UnderlineStyle.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertUnderlineStyleToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public StylesPackage getStylesPackage() {
        return (StylesPackage)this.getEPackage();
    }

    @Deprecated
    public static StylesPackage getPackage() {
        return StylesPackage.eINSTANCE;
    }
}

