/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.ui.internal.figures.GFAbstractShape;
import org.eclipse.graphiti.ui.internal.figures.GFFigureUtil;
import org.eclipse.graphiti.ui.internal.parts.IPictogramElementDelegate;
import org.eclipse.swt.graphics.Path;

public abstract class GFAbstractRotatableDecoration
extends GFAbstractShape
implements RotatableDecoration {
    private Rectangle initialBounds = null;
    private Rectangle bounds = new Rectangle();
    private Point decoratorLocation = new Point();
    private Point decoratorReferencePoint = new Point();
    private double phiDegrees = 0.0;
    private double phiRadians = 0.0;
    private Point touchPointDelta = new Point();

    public GFAbstractRotatableDecoration(IPictogramElementDelegate pictogramElementDelegate, GraphicsAlgorithm graphicsAlgorithm) {
        super(pictogramElementDelegate, graphicsAlgorithm);
        this.initialBounds = new Rectangle(0, 0, graphicsAlgorithm.getWidth(), graphicsAlgorithm.getHeight());
    }

    protected abstract Point getInitialTouchPoint();

    public void setLocation(Point p) {
        this.decoratorLocation.setLocation(p);
        this.processRotatableDecorationValues();
    }

    public void setReferencePoint(Point ref) {
        this.decoratorReferencePoint.setLocation(ref);
        this.processRotatableDecorationValues();
    }

    protected void processRotatableDecorationValues() {
        Point tempRect = Point.SINGLETON.setLocation(this.getDecoratorReferencePoint());
        tempRect.negate().translate(this.getDecoratorLocation());
        this.phiDegrees = Math.toDegrees(Math.atan2(tempRect.y, tempRect.x)) + 180.0;
        this.phiRadians = Math.toRadians(this.phiDegrees);
        double sin = Math.sin(this.getPhiRadians());
        double cos = Math.cos(this.getPhiRadians());
        double rotatedX = (double)this.getInitialTouchPoint().x * cos - (double)this.getInitialTouchPoint().y * sin;
        double rotatedY = (double)this.getInitialTouchPoint().x * sin + (double)this.getInitialTouchPoint().y * cos;
        this.touchPointDelta = new PrecisionPoint((double)this.getDecoratorLocation().x - rotatedX, (double)this.getDecoratorLocation().y - rotatedY);
        int maxExtension = Math.max(this.getInitialBounds().width, this.getInitialBounds().height) + 10;
        this.bounds = new Rectangle(this.touchPointDelta.x - maxExtension, this.touchPointDelta.y - maxExtension, 3 * maxExtension, 3 * maxExtension);
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    protected void paintShape(Graphics graphics, boolean isFill) {
        int oldLineWidth = graphics.getLineWidth();
        graphics.setLineWidth(this.getLineWidth(graphics));
        double zoom = this.getZoomLevel(graphics);
        int lw = this.getLineWidth(graphics);
        Rectangle pathbounds = GFFigureUtil.getAdjustedRectangle(this.getInitialBounds(), zoom, lw);
        Path path = this.createPath(pathbounds, graphics, isFill);
        graphics.pushState();
        graphics.translate(this.getTouchPointDelta().x, this.getTouchPointDelta().y);
        graphics.rotate((float)this.getPhiDegrees());
        if (isFill) {
            this.fillPath(graphics, path);
        } else {
            graphics.drawPath(path);
        }
        path.dispose();
        graphics.popState();
        graphics.setLineWidth(oldLineWidth);
    }

    public boolean containsPointInFigure(int x, int y) {
        PrecisionPoint backwards = this.rotateTargetToInitial(x, y);
        if (!this.getInitialBounds().contains((int)Math.round(backwards.preciseX()), (int)Math.round(backwards.preciseY()))) {
            return false;
        }
        return this.containsPointInInitialFigure(backwards.x, backwards.y);
    }

    public boolean containsPointInInitialFigure(int x, int y) {
        return true;
    }

    protected PrecisionPoint rotateTargetToInitial(double x, double y) {
        double sin = Math.sin(-this.getPhiRadians());
        double cos = Math.cos(-this.getPhiRadians());
        double translatedX = x - (double)this.getDecoratorLocation().x;
        double translatedY = y - (double)this.getDecoratorLocation().y;
        double rotatedX = translatedX * cos - translatedY * sin;
        double rotatedY = translatedX * sin + translatedY * cos;
        return new PrecisionPoint(rotatedX += (double)this.getInitialTouchPoint().x, rotatedY += (double)this.getInitialTouchPoint().y);
    }

    protected final void setInitialBounds(Rectangle initialBounds) {
        this.initialBounds = initialBounds;
    }

    protected final Rectangle getInitialBounds() {
        return this.initialBounds;
    }

    protected final Point getDecoratorLocation() {
        return this.decoratorLocation;
    }

    protected final Point getDecoratorReferencePoint() {
        return this.decoratorReferencePoint;
    }

    protected final double getPhiDegrees() {
        return this.phiDegrees;
    }

    protected final double getPhiRadians() {
        return this.phiRadians;
    }

    protected final Point getTouchPointDelta() {
        return this.touchPointDelta;
    }
}

