/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.parts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gef.CompoundSnapToHelper;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.SnapToGeometry;
import org.eclipse.gef.SnapToGrid;
import org.eclipse.gef.SnapToGuides;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.platform.ga.IGraphicsAlgorithmRenderer;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;
import org.eclipse.graphiti.ui.internal.config.IConfigurationProviderInternal;
import org.eclipse.graphiti.ui.internal.parts.DiagramEditPart;
import org.eclipse.graphiti.ui.internal.parts.IContainerShapeEditPart;
import org.eclipse.graphiti.ui.internal.parts.ShapeEditPart;
import org.eclipse.graphiti.ui.internal.util.ui.sfx.GFSnapFeedbackPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerShapeEditPart
extends ShapeEditPart
implements IContainerShapeEditPart {
    private IFigure contentPaneFigureCache;
    private Integer contentPaneChilds = 0;

    public ContainerShapeEditPart(IConfigurationProviderInternal configurationProvider, ContainerShape containerShape) {
        super(configurationProvider, (Shape)containerShape);
    }

    @Override
    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("LayoutEditPolicy", this.getConfigurationProvider().getEditPolicyFactory().createShapeXYLayoutEditPolicy());
        this.installEditPolicy("Snap Feedback", (EditPolicy)new GFSnapFeedbackPolicy());
    }

    @Override
    protected IFigure createFigure() {
        if (this.getPictogramElement().getGraphicsAlgorithm() == null) {
            throw new IllegalStateException("The ContainerShape must have a valid GraphicsAlgorithm: " + this.getPictogramElement().toString());
        }
        this.resetContentPaneFigureCache();
        IFigure figure = super.createFigure();
        if (figure != null) {
            if (figure.getBackgroundColor() == null && !(figure instanceof IGraphicsAlgorithmRenderer)) {
                figure.setBackgroundColor(ColorConstants.lightGray);
            }
            figure.setOpaque(true);
        }
        this.setFigure(figure);
        this.contentPaneChilds = this.getContentPane().getChildren().size();
        return figure;
    }

    @Override
    public List<PictogramElement> getModelChildren() {
        ArrayList<PictogramElement> result = new ArrayList<PictogramElement>();
        if (this.getPictogramElementDelegate().isValid()) {
            ContainerShape containerShape = (ContainerShape)this.getPictogramElement();
            List<PictogramElement> activeChildren = this.collectActiveChildrenRecursively(containerShape);
            result.addAll(activeChildren);
            result.addAll(super.getModelChildren());
        }
        return result;
    }

    private List<PictogramElement> collectActiveChildrenRecursively(ContainerShape containerShape) {
        EList coll = containerShape.getChildren();
        ArrayList<PictogramElement> activeChildren = new ArrayList<PictogramElement>();
        for (Object obj : coll) {
            if (obj == null || !(obj instanceof PictogramElement)) continue;
            PictogramElement pe = (PictogramElement)obj;
            if (pe.isActive()) {
                activeChildren.add(pe);
                continue;
            }
            if (!(pe instanceof ContainerShape)) continue;
            activeChildren.addAll(this.collectActiveChildrenRecursively((ContainerShape)pe));
        }
        return activeChildren;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        this.resetContentPaneFigureCache();
        int realIndex = index + this.getContentPaneChildCount();
        super.addChildVisual(childEditPart, realIndex);
    }

    private void resetContentPaneFigureCache() {
        this.contentPaneFigureCache = null;
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == SnapToHelper.class) {
            ArrayList<Object> snapStrategies = new ArrayList<Object>();
            Boolean val = (Boolean)this.getViewer().getProperty("ruler$visibility");
            if (val != null && val.booleanValue()) {
                snapStrategies.add(new SnapToGuides((GraphicalEditPart)this));
            }
            if ((val = (Boolean)this.getViewer().getProperty("SnapToGeometry.isEnabled")) != null && val.booleanValue()) {
                snapStrategies.add(new SnapToGeometry((GraphicalEditPart)this));
            }
            if ((val = (Boolean)this.getViewer().getProperty("SnapToGrid.isEnabled")) != null && val.booleanValue()) {
                snapStrategies.add(new SnapToGrid((GraphicalEditPart)this));
            }
            if (snapStrategies.size() == 0) {
                return null;
            }
            if (snapStrategies.size() == 1) {
                return snapStrategies.get(0);
            }
            SnapToHelper[] ss = new SnapToHelper[snapStrategies.size()];
            int i = 0;
            while (i < snapStrategies.size()) {
                ss[i] = (SnapToHelper)snapStrategies.get(i);
                ++i;
            }
            return new CompoundSnapToHelper(ss);
        }
        return super.getAdapter(adapter);
    }

    public IFigure getContentPane() {
        ContainerShape cs;
        GraphicsAlgorithm contentGa;
        if (this.getContentPaneFigureCache() != null) {
            return this.getContentPaneFigureCache();
        }
        IToolBehaviorProvider tbp = this.getConfigurationProvider().getDiagramTypeProvider().getCurrentToolBehaviorProvider();
        PictogramElement pe = this.getPictogramElement();
        if (pe instanceof ContainerShape && !(this instanceof DiagramEditPart) && (contentGa = tbp.getContentArea(cs = (ContainerShape)pe)) != null) {
            this.setConentPaneFigureCache(this.getPictogramElementDelegate().getFigureForGraphicsAlgorithm(contentGa));
            if (this.getContentPaneFigureCache() != null) {
                LayoutManager lm = this.getContentPaneFigureCache().getLayoutManager();
                if (!(lm instanceof XYLayout)) {
                    this.getContentPaneFigureCache().setLayoutManager((LayoutManager)new XYLayout());
                }
                return this.getContentPaneFigureCache();
            }
        }
        IFigure ret = super.getContentPane();
        return ret;
    }

    private void setConentPaneFigureCache(IFigure figure) {
        this.contentPaneFigureCache = figure;
    }

    private IFigure getContentPaneFigureCache() {
        return this.contentPaneFigureCache;
    }

    private Integer getContentPaneChildCount() {
        return this.contentPaneChilds;
    }
}

