/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.services.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.commands.operations.DefaultOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.transaction.TransactionalCommandStack;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl;
import org.eclipse.emf.workspace.WorkspaceEditingDomainFactory;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.ui.internal.editor.GFWorkspaceCommandStackImpl;
import org.eclipse.graphiti.ui.internal.services.IEmfService;
import org.eclipse.graphiti.ui.internal.util.ModelElementNameComparator;
import org.eclipse.jface.viewers.IStructuredSelection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmfService
implements IEmfService {
    private final String LINE_SEP = System.getProperty("line.separator");
    private final String ATTRIBUTE_OBJ_NAME = "name";
    private final String ATTRIBUTE_OBJ_ID = "id";

    @Override
    public String getObjectName(Object obj) {
        String value;
        EObject refObject;
        Map.Entry<EAttribute, String> attr;
        ENamedElement elem;
        String name;
        if (obj == null) {
            throw new IllegalArgumentException("Obj must not be null");
        }
        if (obj instanceof ENamedElement && (name = (elem = (ENamedElement)obj).getName()) != null) {
            return name;
        }
        if (obj instanceof EObject && (attr = this.getObjectNameAttribute(refObject = (EObject)obj)) != null && (value = attr.getValue()) != null) {
            return value;
        }
        return obj.toString();
    }

    @Override
    public EObject getEObject(Object object) {
        EObject eObject = null;
        if (object != null && object instanceof EObject) {
            eObject = (EObject)object;
            return eObject;
        }
        if (object instanceof IStructuredSelection) {
            if (((IStructuredSelection)object).isEmpty()) {
                return null;
            }
            Object element = ((IStructuredSelection)object).getFirstElement();
            return this.getEObject(element);
        }
        return null;
    }

    private Map.Entry<EAttribute, String> getObjectNameAttribute(EObject eObject) {
        EClass metaObject = eObject.eClass();
        EList attrs = metaObject.getEAllAttributes();
        if (attrs != null) {
            for (EAttribute attr : attrs) {
                Object value = eObject.eGet((EStructuralFeature)attr);
                if ("name".equalsIgnoreCase(attr.getName()) && value != null) {
                    String v = String.valueOf(value);
                    return Collections.singletonMap(attr, v).entrySet().iterator().next();
                }
                if ("id".equalsIgnoreCase(attr.getName()) && value != null) {
                    String v = String.valueOf(value);
                    return Collections.singletonMap(attr, v).entrySet().iterator().next();
                }
                if (!(value instanceof String)) continue;
                return Collections.singletonMap(attr, (String)value).entrySet().iterator().next();
            }
        }
        return null;
    }

    @Override
    public IFile getFile(EObject object) {
        ResourceSet resourceSet;
        IFile result = null;
        Resource resource = object.eResource();
        if (resource != null && (resourceSet = resource.getResourceSet()) != null) {
            result = this.getFile(resource.getURI());
        }
        return result;
    }

    @Deprecated
    public IFile getFile(URI uri, TransactionalEditingDomain editingDomain) {
        return this.getFile(uri);
    }

    @Deprecated
    public IFile getFile(URI uri, ResourceSet resourceSet) {
        return this.getFile(uri);
    }

    @Override
    public IFile getFile(URI uri) {
        if (uri == null) {
            return null;
        }
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        String filePath = this.getWorkspaceFilePath(uri.trimFragment());
        if (filePath == null) {
            IPath location = Path.fromOSString((String)uri.toString());
            IFile file = workspaceRoot.getFileForLocation(location);
            if (file != null) {
                return file;
            }
            return null;
        }
        IResource workspaceResource = workspaceRoot.findMember(filePath);
        return (IFile)workspaceResource;
    }

    private String getWorkspaceFilePath(URI uri) {
        if (uri.isPlatform()) {
            return uri.toPlatformString(true);
        }
        return null;
    }

    @Override
    public StringBuilder toString(EObject o, StringBuilder result) {
        EClass metaObject = o.eClass();
        result.append(metaObject.getName());
        result.append(" \"");
        result.append(this.getObjectName(o));
        result.append("\": ");
        result.append(EcoreUtil.getURI((EObject)o));
        result.append(this.LINE_SEP);
        if (o instanceof EObject) {
            TreeMap<ENamedElement, Object> atts = new TreeMap<ENamedElement, Object>(ModelElementNameComparator.INSTANCE_IGNORING_CASE);
            atts.putAll(this.getAttributesWithValues(o, true));
            Set attsWithValues = atts.entrySet();
            for (Map.Entry attr : attsWithValues) {
                result.append("  ");
                result.append(((EAttribute)attr.getKey()).getName());
                result.append("=");
                result.append(String.valueOf(attr.getValue()));
                result.append(this.LINE_SEP);
            }
        }
        result.append("  class=");
        result.append(o.eClass().getInstanceClassName());
        return result;
    }

    private Map<EAttribute, Object> getAttributesWithValues(EObject refObject, boolean b) {
        EClass metaObject = refObject.eClass();
        EList attrs = metaObject.getEAllAttributes();
        HashMap<EAttribute, Object> result = new HashMap<EAttribute, Object>(attrs.size());
        for (EAttribute attr : attrs) {
            Object value = refObject.eGet((EStructuralFeature)attr);
            result.put(attr, value);
        }
        return result;
    }

    @Override
    public Diagram getDiagramFromFile(IFile file, ResourceSet resourceSet) {
        URI resourceURI = this.getFileURI(file);
        try {
            URI diagramUri;
            EObject eObject;
            Resource resource = resourceSet.getResource(resourceURI, true);
            if (resource != null && (eObject = resource.getEObject((diagramUri = this.mapDiagramFileUriToDiagramUri(resourceURI)).fragment())) instanceof Diagram) {
                return (Diagram)eObject;
            }
        }
        catch (WrappedException wrappedException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public URI getFileURI(IFile file) {
        String pathName = file.getFullPath().toString();
        URI resourceURI = URI.createPlatformResourceURI((String)pathName, (boolean)true);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceURI = resourceSet.getURIConverter().normalize(resourceURI);
        return resourceURI;
    }

    @Override
    public URI mapDiagramFileUriToDiagramUri(URI diagramFileUri) {
        return diagramFileUri.appendFragment("/0");
    }

    @Override
    public TransactionalEditingDomain createResourceSetAndEditingDomain() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        GFWorkspaceCommandStackImpl workspaceCommandStack = new GFWorkspaceCommandStackImpl((IOperationHistory)new DefaultOperationHistory());
        TransactionalEditingDomainImpl editingDomain = new TransactionalEditingDomainImpl((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE), (TransactionalCommandStack)workspaceCommandStack, (ResourceSet)resourceSet);
        WorkspaceEditingDomainFactory.INSTANCE.mapResourceSet((TransactionalEditingDomain)editingDomain);
        return editingDomain;
    }
}

