/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.features.impl;

import java.util.HashMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.features.impl.AbstractUpdateFeature;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;

public class DefaultUpdateDiagramFeature
extends AbstractUpdateFeature {
    private boolean hasDoneChanges = false;

    public DefaultUpdateDiagramFeature(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    public boolean canUpdate(IUpdateContext context) {
        return context.getPictogramElement() instanceof Diagram;
    }

    @Override
    public boolean update(IUpdateContext context) {
        PictogramElement pe = context.getPictogramElement();
        if (pe instanceof Diagram) {
            Diagram d = (Diagram)pe;
            EList children = d.getChildren();
            HashMap<IUpdateFeature, UpdateContext> connToUpdate = new HashMap<IUpdateFeature, UpdateContext>();
            for (Shape shape : children) {
                UpdateContext updateContext = new UpdateContext((PictogramElement)shape);
                IUpdateFeature updateFeature = this.getFeatureProvider().getUpdateFeature(updateContext);
                if (updateFeature == null || !updateFeature.canUpdate(updateContext) || !updateFeature.updateNeeded(updateContext).toBoolean()) continue;
                connToUpdate.put(updateFeature, updateContext);
            }
            this.hasDoneChanges = false;
            for (IUpdateFeature feature : connToUpdate.keySet()) {
                feature.update((IUpdateContext)connToUpdate.get(feature));
                if (!feature.hasDoneChanges()) continue;
                this.hasDoneChanges = true;
            }
        }
        return true;
    }

    @Override
    public IReason updateNeeded(IUpdateContext context) {
        PictogramElement pe = context.getPictogramElement();
        if (pe instanceof Diagram) {
            Diagram d = (Diagram)pe;
            EList children = d.getChildren();
            for (Shape shape : children) {
                UpdateContext updateContext = new UpdateContext((PictogramElement)shape);
                IUpdateFeature updateFeature = this.getFeatureProvider().getUpdateFeature(updateContext);
                if (updateFeature == null || !updateFeature.updateNeeded(updateContext).toBoolean()) continue;
                return Reason.createTrueReason();
            }
            EList connections = d.getConnections();
            for (Connection connection : connections) {
                UpdateContext updateContext = new UpdateContext((PictogramElement)connection);
                IUpdateFeature updateFeature = this.getFeatureProvider().getUpdateFeature(updateContext);
                if (updateFeature == null || !updateFeature.updateNeeded(updateContext).toBoolean()) continue;
                return Reason.createTrueReason();
            }
        }
        return Reason.createFalseReason();
    }

    @Override
    public boolean hasDoneChanges() {
        return this.hasDoneChanges;
    }
}

