/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.editor;

import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.Tool;
import org.eclipse.gef.dnd.TemplateTransferDragSourceListener;
import org.eclipse.gef.dnd.TransferDragSourceListener;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.tools.ConnectionCreationTool;
import org.eclipse.gef.tools.CreationTool;
import org.eclipse.gef.ui.palette.DefaultPaletteViewerPreferences;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.PaletteViewerPreferences;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.graphiti.ui.editor.DiagramBehavior;
import org.eclipse.graphiti.ui.internal.GraphitiUIPlugin;
import org.eclipse.graphiti.ui.internal.editor.GFPaletteRoot;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.KeyEvent;

public class DefaultPaletteBehavior {
    protected static final String PROPERTY_PALETTE_DOCK_LOCATION = "Dock location";
    protected static final String PROPERTY_PALETTE_SIZE = "Palette Size";
    protected static final String PROPERTY_PALETTE_STATE = "Palette state";
    protected static final int DEFAULT_PALETTE_SIZE = 130;
    protected final DiagramBehavior diagramBehavior;
    private PaletteRoot paletteRoot;

    public DefaultPaletteBehavior(DiagramBehavior diagramBehavior) {
        this.diagramBehavior = diagramBehavior;
    }

    protected PaletteRoot createPaletteRoot() {
        return new GFPaletteRoot(this.diagramBehavior.getDiagramTypeProvider());
    }

    public PaletteRoot getPaletteRoot() {
        if (this.paletteRoot == null) {
            this.paletteRoot = this.createPaletteRoot();
        }
        return this.paletteRoot;
    }

    public void initializeViewer() {
        PaletteViewer paletteViewer = this.diagramBehavior.getEditDomain().getPaletteViewer();
        if (paletteViewer != null) {
            IPreferenceStore store = GraphitiUIPlugin.getDefault().getPreferenceStore();
            paletteViewer.setPaletteViewerPreferences((PaletteViewerPreferences)new DefaultPaletteViewerPreferences(store));
            store.firePropertyChangeEvent("Palette Font", null, null);
        }
    }

    public FlyoutPaletteComposite.FlyoutPreferences getPalettePreferences() {
        return new FlyoutPaletteComposite.FlyoutPreferences(){

            public int getDockLocation() {
                return DefaultPaletteBehavior.this.getPreferenceStore().getInt(DefaultPaletteBehavior.PROPERTY_PALETTE_DOCK_LOCATION);
            }

            public int getPaletteState() {
                if (!DefaultPaletteBehavior.this.diagramBehavior.getDiagramTypeProvider().getCurrentToolBehaviorProvider().isShowFlyoutPalette()) {
                    return 8;
                }
                return DefaultPaletteBehavior.this.getPreferenceStore().getInt(DefaultPaletteBehavior.PROPERTY_PALETTE_STATE);
            }

            public int getPaletteWidth() {
                return DefaultPaletteBehavior.this.getPreferenceStore().getInt(DefaultPaletteBehavior.PROPERTY_PALETTE_SIZE);
            }

            public void setDockLocation(int location) {
                DefaultPaletteBehavior.this.getPreferenceStore().setValue(DefaultPaletteBehavior.PROPERTY_PALETTE_DOCK_LOCATION, location);
            }

            public void setPaletteState(int state) {
                DefaultPaletteBehavior.this.getPreferenceStore().setValue(DefaultPaletteBehavior.PROPERTY_PALETTE_STATE, state);
            }

            public void setPaletteWidth(int width) {
                DefaultPaletteBehavior.this.getPreferenceStore().setValue(DefaultPaletteBehavior.PROPERTY_PALETTE_SIZE, width);
            }
        };
    }

    protected PaletteViewerProvider createPaletteViewerProvider() {
        return new PaletteViewerProvider((EditDomain)this.diagramBehavior.getEditDomain()){
            private KeyHandler paletteKeyHandler;
            {
                this.paletteKeyHandler = null;
            }

            protected void configurePaletteViewer(PaletteViewer viewer) {
                super.configurePaletteViewer(viewer);
                viewer.getKeyHandler().setParent(this.getPaletteKeyHandler());
                viewer.addDragSourceListener((TransferDragSourceListener)new TemplateTransferDragSourceListener((EditPartViewer)viewer));
            }

            private KeyHandler getPaletteKeyHandler() {
                if (this.paletteKeyHandler == null) {
                    this.paletteKeyHandler = new KeyHandler(){

                        public boolean keyReleased(KeyEvent event) {
                            Tool tool;
                            if (event.keyCode == 13 && ((tool = this.getEditDomain().getPaletteViewer().getActiveTool().createTool()) instanceof CreationTool || tool instanceof ConnectionCreationTool)) {
                                tool.keyUp(event, (EditPartViewer)(this).DefaultPaletteBehavior.this.diagramBehavior.getDiagramContainer().getGraphicalViewer());
                                this.getEditDomain().getPaletteViewer().setActiveTool(null);
                                return true;
                            }
                            return super.keyReleased(event);
                        }
                    };
                }
                return this.paletteKeyHandler;
            }
        };
    }

    public void refreshPalette() {
        PaletteRoot pr = this.getPaletteRoot();
        if (pr instanceof GFPaletteRoot) {
            GFPaletteRoot gpr = (GFPaletteRoot)pr;
            gpr.updatePaletteEntries();
        }
    }

    public void dispose() {
        this.paletteRoot = null;
    }

    private IPreferenceStore getPreferenceStore() {
        IPreferenceStore ps = GraphitiUIPlugin.getDefault().getPreferenceStore();
        ps.setDefault(PROPERTY_PALETTE_STATE, 4);
        ps.setDefault(PROPERTY_PALETTE_SIZE, 130);
        return ps;
    }
}

