/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.internal.services.impl;

import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.dt.AbstractDiagramTypeProvider;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.internal.services.IEmfService;
import org.eclipse.graphiti.mm.pictograms.Diagram;

public final class EmfService
implements IEmfService {
    private WeakHashMap<Diagram, WeakReference<IDiagramTypeProvider>> diagToProvider = new WeakHashMap();

    @Override
    public boolean isObjectAlive(EObject obj) {
        return obj != null && obj.eResource() != null;
    }

    @Override
    public IDiagramTypeProvider getDTPForDiagram(Diagram d) {
        WeakReference<IDiagramTypeProvider> weakReference = this.diagToProvider.get(d);
        if (weakReference == null || weakReference.get() == null) {
            return new GenericDiagramTypeProvider(){};
        }
        return (IDiagramTypeProvider)weakReference.get();
    }

    @Override
    public void wireDTPToDiagram(Diagram d, IDiagramTypeProvider provider) {
        this.diagToProvider.put(d, new WeakReference<IDiagramTypeProvider>(provider));
    }

    private class GenericDiagramTypeProvider
    extends AbstractDiagramTypeProvider {
        private GenericDiagramTypeProvider() {
        }
    }
}

