/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.parts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.TextUtilities;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.graphiti.datatypes.IDimension;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.datatypes.IRectangle;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.internal.datatypes.impl.LocationImpl;
import org.eclipse.graphiti.internal.pref.GFPreferences;
import org.eclipse.graphiti.internal.services.GraphitiInternal;
import org.eclipse.graphiti.internal.util.T;
import org.eclipse.graphiti.mm.algorithms.AbstractText;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Image;
import org.eclipse.graphiti.mm.algorithms.MultiText;
import org.eclipse.graphiti.mm.algorithms.PlatformGraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polygon;
import org.eclipse.graphiti.mm.algorithms.RoundedRectangle;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.LineStyle;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.pictograms.AdvancedAnchor;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.BoxRelativeAnchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.FixPointAnchor;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.platform.ga.IGraphicsAlgorithmRenderer;
import org.eclipse.graphiti.platform.ga.IGraphicsAlgorithmRendererFactory;
import org.eclipse.graphiti.platform.ga.IRendererContext;
import org.eclipse.graphiti.platform.ga.IVisualState;
import org.eclipse.graphiti.platform.ga.RendererContext;
import org.eclipse.graphiti.platform.ga.VisualState;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.tb.DefaultToolBehaviorProvider;
import org.eclipse.graphiti.tb.IBorderDecorator;
import org.eclipse.graphiti.tb.IColorDecorator;
import org.eclipse.graphiti.tb.IDecorator;
import org.eclipse.graphiti.tb.IImageDecorator;
import org.eclipse.graphiti.tb.ITextDecorator;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;
import org.eclipse.graphiti.ui.editor.DefaultRefreshBehavior;
import org.eclipse.graphiti.ui.editor.DiagramBehavior;
import org.eclipse.graphiti.ui.internal.IResourceRegistry;
import org.eclipse.graphiti.ui.internal.config.IConfigurationProviderInternal;
import org.eclipse.graphiti.ui.internal.figures.DecoratorImageFigure;
import org.eclipse.graphiti.ui.internal.figures.GFAbstractShape;
import org.eclipse.graphiti.ui.internal.figures.GFEllipse;
import org.eclipse.graphiti.ui.internal.figures.GFEllipseDecoration;
import org.eclipse.graphiti.ui.internal.figures.GFImageFigure;
import org.eclipse.graphiti.ui.internal.figures.GFMultilineText;
import org.eclipse.graphiti.ui.internal.figures.GFPolygon;
import org.eclipse.graphiti.ui.internal.figures.GFPolygonDecoration;
import org.eclipse.graphiti.ui.internal.figures.GFPolyline;
import org.eclipse.graphiti.ui.internal.figures.GFPolylineConnection;
import org.eclipse.graphiti.ui.internal.figures.GFPolylineDecoration;
import org.eclipse.graphiti.ui.internal.figures.GFRectangleFigure;
import org.eclipse.graphiti.ui.internal.figures.GFRoundedRectangle;
import org.eclipse.graphiti.ui.internal.figures.GFText;
import org.eclipse.graphiti.ui.internal.parts.AdvancedAnchorEditPart;
import org.eclipse.graphiti.ui.internal.parts.ConnectionEditPart;
import org.eclipse.graphiti.ui.internal.parts.GFAdapter;
import org.eclipse.graphiti.ui.internal.parts.IGFAdapter;
import org.eclipse.graphiti.ui.internal.parts.IPictogramElementDelegate;
import org.eclipse.graphiti.ui.internal.parts.IPictogramElementEditPart;
import org.eclipse.graphiti.ui.internal.parts.IShapeEditPart;
import org.eclipse.graphiti.ui.internal.parts.ShapeEditPart;
import org.eclipse.graphiti.ui.internal.services.GraphitiUiInternal;
import org.eclipse.graphiti.ui.internal.util.DataTypeTransformation;
import org.eclipse.graphiti.ui.services.GraphitiUi;
import org.eclipse.graphiti.util.IColorConstant;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.IWorkbenchAdapter2;

public class PictogramElementDelegate
implements IPictogramElementDelegate {
    private boolean forceRefresh = false;
    private boolean valid = true;
    private IConfigurationProviderInternal configurationProvider;
    private final Hashtable<GraphicsAlgorithm, IFigure> elementFigureHash = new Hashtable();
    private final HashSet<Font> fontList = new HashSet();
    private final HashSet<Font> decoratorFontList = new HashSet();
    private PictogramElement pictogramElement;
    private final HashMap<IFigure, List<IFigure>> decoratorMap = new HashMap();
    private EditPart containerEditPart;
    private IVisualState visualState;

    public PictogramElementDelegate(IConfigurationProviderInternal configurationProvider, PictogramElement pictogramElement, EditPart containerEditPart) {
        this.setConfigurationProvider(configurationProvider);
        this.setPictogramElement(pictogramElement);
        this.setContainerEditPart(containerEditPart);
    }

    @Override
    public void activate() {
    }

    @Override
    public IFigure createFigure() {
        PictogramElement pe = this.getPictogramElement();
        IFigure ret = this.createFigureForPictogramElement(pe);
        if (this.getDiagramBehavior().getRefreshBehavior().isMultipleRefreshSupressionActive()) {
            return ret;
        }
        this.refreshFigureForPictogramElement(pe);
        return ret;
    }

    @Override
    public void deactivate() {
        for (IFigure figure : this.elementFigureHash.values()) {
            this.removeDecorators(figure);
        }
        this.disposeFonts();
    }

    public Object getAdapter(Class key) {
        GFAdapter ret = null;
        if (key == IGFAdapter.class || key == IWorkbenchAdapter.class || key == IWorkbenchAdapter2.class) {
            ret = new GFAdapter();
        }
        return ret;
    }

    @Override
    public IConfigurationProviderInternal getConfigurationProvider() {
        return this.configurationProvider;
    }

    @Override
    public IFigure getFigureForGraphicsAlgorithm(GraphicsAlgorithm graphicsAlgorithm) {
        IFigure ret = null;
        if (graphicsAlgorithm == null) {
            return ret;
        }
        ret = this.elementFigureHash.get(graphicsAlgorithm);
        return ret;
    }

    @Override
    public PictogramElement getPictogramElement() {
        return this.pictogramElement;
    }

    @Override
    public void refreshEditPartsForModelChildrenAndSourceConnections(EditPart ep) {
        if (ep instanceof IPictogramElementEditPart) {
            Map editPartRegistry;
            EditPartViewer viewer;
            IPictogramElementEditPart peep = (IPictogramElementEditPart)ep;
            ArrayList<Object> peList = new ArrayList<Object>();
            peList.addAll(peep.getModelChildren());
            peList.addAll(peep.getModelSourceConnections());
            if (ep.getParent() != null && (viewer = ep.getViewer()) != null && (editPartRegistry = viewer.getEditPartRegistry()) != null) {
                for (PictogramElement pictogramElement : peList) {
                    Object object = editPartRegistry.get(pictogramElement);
                    if (!(object instanceof EditPart)) continue;
                    EditPart editPart = (EditPart)object;
                    try {
                        editPart.refresh();
                    }
                    catch (NullPointerException e) {
                        String message = "PictogramElementDelegate.refreshEditPartsForModelChildrenAndSourceConnections():\n    editPart.refresh() threw NullPointerException\n    editPart: " + editPart;
                        T.racer().error(message, (Throwable)e);
                    }
                }
            }
        }
    }

    @Override
    public void refreshFigureForEditPart() {
        DefaultRefreshBehavior refreshBehavior = this.getDiagramBehavior().getRefreshBehavior();
        if (!this.isForceRefresh() && refreshBehavior.isMultipleRefreshSupressionActive() && !refreshBehavior.shouldRefresh(this.getContainerEditPart())) {
            return;
        }
        PictogramElement pe = this.getPictogramElement();
        if (!GraphitiInternal.getEmfService().isObjectAlive((EObject)pe)) {
            return;
        }
        if (pe instanceof org.eclipse.graphiti.mm.pictograms.Shape || pe instanceof AdvancedAnchor) {
            if (this.isRefreshPossible(pe)) {
                this.refreshFigureForPictogramElement(pe);
            } else {
                EditPart parentEp = this.getContainerEditPart().getParent();
                if (parentEp instanceof IShapeEditPart) {
                    this.elementFigureHash.clear();
                    IShapeEditPart parent = (IShapeEditPart)parentEp;
                    parent.deleteChildAndRefresh(this.getContainerEditPart());
                    this.setValid(false);
                }
            }
        } else if (pe instanceof Connection) {
            Connection connection = (Connection)pe;
            if (!this.isConnectionRefreshPossible(connection)) {
                IFigure figure = this.getFigureForGraphicsAlgorithm(connection.getGraphicsAlgorithm());
                this.elementFigureHash.clear();
                if (figure instanceof GFPolylineConnection) {
                    GFPolylineConnection c = (GFPolylineConnection)figure;
                    c.removeAllDecorations();
                }
                this.addGraphicsAlgorithmForFigure(figure, connection.getGraphicsAlgorithm());
                this.createFiguresForPassiveDecorators(connection);
            }
            this.refreshFigureForPictogramElement(pe);
        } else if (pe instanceof Anchor) {
            this.refreshFigureForPictogramElement(pe);
        }
    }

    protected EditPart getContainerEditPart() {
        return this.containerEditPart;
    }

    protected void setContainerEditPart(EditPart containerEditPart) {
        this.containerEditPart = containerEditPart;
    }

    IReason checkIfUpdateNeeded(PictogramElement pe) {
        UpdateContext updateCtx;
        IReason ret = Reason.createFalseReason();
        IFeatureProvider featureProvider = this.getConfigurationProvider().getFeatureProvider();
        IUpdateFeature updateFeature = featureProvider.getUpdateFeature((IUpdateContext)(updateCtx = new UpdateContext(pe)));
        if (updateFeature != null) {
            ret = updateFeature.updateNeeded((IUpdateContext)updateCtx);
        }
        if (this.getPreferences().isRecursiveCheckForUpdateActive() && !ret.toBoolean()) {
            Collection peChildren = Graphiti.getPeService().getPictogramElementChildren(pe);
            for (PictogramElement peChild : peChildren) {
                ret = this.checkIfUpdateNeeded(peChild);
                if (ret.toBoolean()) break;
            }
        }
        if (T.racer().info()) {
            T.racer().info("returns " + ret.toString());
        }
        return ret;
    }

    void refreshFigureForGraphicsAlgorithm(GraphicsAlgorithm graphicsAlgorithm, PictogramElement pe, IReason updateNeeded) {
        Object label;
        GFPolyline p;
        PointList pointList;
        int selectedState;
        if (graphicsAlgorithm == null || pe == null) {
            return;
        }
        IFigure figure = this.getFigureForGraphicsAlgorithm(graphicsAlgorithm);
        if (figure == null) {
            return;
        }
        DefaultRefreshBehavior refreshBehavior = this.getDiagramBehavior().getRefreshBehavior();
        if (!this.isForceRefresh() && refreshBehavior.isMultipleRefreshSupressionActive() && !refreshBehavior.shouldRefresh(graphicsAlgorithm)) {
            return;
        }
        figure.setOpaque(true);
        figure.setVisible(pe.isVisible());
        figure.setBorder(null);
        boolean selectedConnection = false;
        if (this.getContainerEditPart() instanceof ConnectionEditPart && ((selectedState = this.getContainerEditPart().getSelected()) == 2 || selectedState == 1)) {
            selectedConnection = true;
        }
        if (selectedConnection) {
            Color bg = DataTypeTransformation.toSwtColor(this.getConfigurationProvider().getResourceRegistry(), Graphiti.getGaService().getBackgroundColor(graphicsAlgorithm, true));
            figure.setBackgroundColor(bg);
        } else {
            this.refreshFigureColors(figure, graphicsAlgorithm);
        }
        if (graphicsAlgorithm instanceof org.eclipse.graphiti.mm.algorithms.Ellipse && (figure instanceof Ellipse || figure instanceof GFEllipse || figure instanceof GFEllipseDecoration)) {
            Shape f = (Shape)figure;
            this.refreshShapeData(f, graphicsAlgorithm);
        } else if (graphicsAlgorithm instanceof Polygon && (figure instanceof org.eclipse.draw2d.Polygon || figure instanceof GFPolygon || figure instanceof GFPolygonDecoration)) {
            Polygon polygon = (Polygon)graphicsAlgorithm;
            LocationImpl polygonLocation = new LocationImpl(polygon.getX(), polygon.getY());
            pointList = this.toAbsoluteDraw2dPoints((Collection<org.eclipse.graphiti.mm.algorithms.styles.Point>)polygon.getPoints(), (ILocation)polygonLocation);
            if (figure instanceof GFPolygonDecoration) {
                p = (GFPolygonDecoration)figure;
                p.setSpecificBezierDistances(this.getBezierDistances((Collection<org.eclipse.graphiti.mm.algorithms.styles.Point>)polygon.getPoints()));
                ((GFPolygonDecoration)p).setDecoratorTemplate(pointList);
            } else if (figure instanceof GFPolygon) {
                p = (GFPolygon)figure;
                p.setSpecificBezierDistances(this.getBezierDistances((Collection<org.eclipse.graphiti.mm.algorithms.styles.Point>)polygon.getPoints()));
                p.setPoints(pointList);
            }
            if (!selectedConnection) {
                this.refreshShapeData((Shape)figure, graphicsAlgorithm);
            }
        } else if (graphicsAlgorithm instanceof org.eclipse.graphiti.mm.algorithms.Polyline && (figure instanceof Polyline || figure instanceof GFPolyline || figure instanceof GFPolylineDecoration)) {
            org.eclipse.graphiti.mm.algorithms.Polyline polyline = (org.eclipse.graphiti.mm.algorithms.Polyline)graphicsAlgorithm;
            LocationImpl polylineLocation = new LocationImpl(polyline.getX(), polyline.getY());
            pointList = this.toAbsoluteDraw2dPoints((Collection<org.eclipse.graphiti.mm.algorithms.styles.Point>)polyline.getPoints(), (ILocation)polylineLocation);
            if (figure instanceof GFPolylineConnection) {
                if (!this.isDefaultBendPointRenderingActive() && pe instanceof FreeFormConnection) {
                    FreeFormConnection ffc = (FreeFormConnection)pe;
                    GFPolylineConnection p2 = (GFPolylineConnection)figure;
                    int[] bendpointBezierDistances = this.getBezierDistances((Collection<org.eclipse.graphiti.mm.algorithms.styles.Point>)ffc.getBendpoints());
                    int[] allPointsBezierDistances = new int[bendpointBezierDistances.length + 4];
                    allPointsBezierDistances[0] = 0;
                    allPointsBezierDistances[1] = 0;
                    int i = 0;
                    while (i < bendpointBezierDistances.length) {
                        allPointsBezierDistances[i + 2] = bendpointBezierDistances[i];
                        ++i;
                    }
                    allPointsBezierDistances[allPointsBezierDistances.length - 2] = 0;
                    allPointsBezierDistances[allPointsBezierDistances.length - 1] = 0;
                    p2.setSpecificBezierDistances(allPointsBezierDistances);
                }
            } else if (figure instanceof GFPolylineDecoration) {
                p = (GFPolylineDecoration)figure;
                p.setSpecificBezierDistances(this.getBezierDistances((Collection<org.eclipse.graphiti.mm.algorithms.styles.Point>)polyline.getPoints()));
                ((GFPolylineDecoration)p).setDecoratorTemplate(pointList);
            } else if (figure instanceof GFPolyline) {
                p = (GFPolyline)figure;
                p.setSpecificBezierDistances(this.getBezierDistances((Collection<org.eclipse.graphiti.mm.algorithms.styles.Point>)polyline.getPoints()));
                p.setPoints(pointList);
            }
            if (!selectedConnection) {
                this.refreshShapeData((Shape)figure, graphicsAlgorithm);
            }
        } else if (graphicsAlgorithm instanceof org.eclipse.graphiti.mm.algorithms.Rectangle && figure instanceof GFRectangleFigure) {
            GFRectangleFigure f = (GFRectangleFigure)figure;
            this.refreshShapeData(f, graphicsAlgorithm);
        } else if (graphicsAlgorithm instanceof RoundedRectangle) {
            if (figure instanceof GFRoundedRectangle) {
                GFRoundedRectangle f = (GFRoundedRectangle)figure;
                this.refreshShapeData(f, graphicsAlgorithm);
                RoundedRectangle rr = (RoundedRectangle)graphicsAlgorithm;
                Dimension dimension = new Dimension(rr.getCornerWidth(), rr.getCornerHeight());
                f.setCornerDimensions(dimension);
            }
        } else if (graphicsAlgorithm instanceof MultiText && figure instanceof GFMultilineText) {
            MultiText text = (MultiText)graphicsAlgorithm;
            label = (GFMultilineText)figure;
            label.setBorder((Border)new MarginBorder(2));
            ((GFMultilineText)((Object)label)).setText(text.getValue());
            this.refreshFlowTextAlignment((GFMultilineText)((Object)label), text);
            this.refreshFont((AbstractText)text, (Figure)label);
            label.setOpaque(Graphiti.getGaService().isFilled((GraphicsAlgorithm)text, true));
            label.setRequestFocusEnabled(false);
            label.invalidateTree();
        } else if (graphicsAlgorithm instanceof Text && figure instanceof GFText) {
            Text text = (Text)graphicsAlgorithm;
            label = (GFText)figure;
            label.setText(text.getValue());
            this.refreshTextOrientation((GFText)((Object)label), text);
            this.refreshFont((AbstractText)text, (Figure)label);
            label.setOpaque(Graphiti.getGaService().isFilled((GraphicsAlgorithm)text, true));
            label.setRequestFocusEnabled(false);
        } else if (graphicsAlgorithm instanceof Image && figure instanceof ImageFigure) {
            ImageFigure imageFigure = (ImageFigure)figure;
            Image pictogramImage = (Image)graphicsAlgorithm;
            org.eclipse.swt.graphics.Image image = GraphitiUi.getImageService().getImageForId(this.configurationProvider.getDiagramTypeProvider().getProviderId(), pictogramImage.getId());
            imageFigure.setImage(image);
            imageFigure.setAlignment(2);
            imageFigure.setOpaque(false);
        }
        this.setFigureConstraint(figure, graphicsAlgorithm, pe);
        EList graphicsAlgorithmChildren = graphicsAlgorithm.getGraphicsAlgorithmChildren();
        for (GraphicsAlgorithm childGA : graphicsAlgorithmChildren) {
            this.refreshFigureForGraphicsAlgorithm(childGA, pe, Reason.createFalseReason());
        }
        IDiagramTypeProvider diagramTypeProvider = this.getConfigurationProvider().getDiagramTypeProvider();
        IToolBehaviorProvider toolBehaviorProvider = diagramTypeProvider.getCurrentToolBehaviorProvider();
        this.addDecorators(graphicsAlgorithm, pe, figure, toolBehaviorProvider);
        GraphicsAlgorithm selectionGraphicsAlgorithm = toolBehaviorProvider.getSelectionBorder(pe);
        IFigure selectionFigure = this.getFigureForGraphicsAlgorithm(selectionGraphicsAlgorithm);
        if (selectionFigure == null) {
            selectionFigure = figure;
        }
        Object tooltipFigure = null;
        Label indicateUpdateNeedeTooltipLabel = null;
        if (selectionFigure != null) {
            indicateUpdateNeedeTooltipLabel = this.indicateNeededUpdates(selectionFigure, updateNeeded);
        }
        if (indicateUpdateNeedeTooltipLabel != null) {
            tooltipFigure = indicateUpdateNeedeTooltipLabel;
        } else {
            Object toolTip = toolBehaviorProvider.getToolTip(graphicsAlgorithm);
            if (toolTip != null) {
                MultiText multiText;
                if (toolTip instanceof String) {
                    String toolTipString = (String)toolTip;
                    if (toolTipString.length() > 0) {
                        tooltipFigure = new Label(toolTipString);
                    }
                } else if (toolTip instanceof Text) {
                    Text text = (Text)toolTip;
                    if (text.getValue() != null && text.getValue().length() > 0) {
                        tooltipFigure = new GFText(this, text);
                        ((GFText)((Object)tooltipFigure)).setText(text.getValue());
                    }
                } else if (toolTip instanceof MultiText && (multiText = (MultiText)toolTip).getValue() != null && multiText.getValue().length() > 0) {
                    tooltipFigure = new GFMultilineText(this, multiText);
                }
            }
        }
        figure.setToolTip((IFigure)tooltipFigure);
    }

    private void refreshFont(AbstractText text, Figure label) {
        if (text == null || label == null) {
            return;
        }
        org.eclipse.graphiti.mm.algorithms.styles.Font font = Graphiti.getGaService().getFont(text, true);
        if (font != null && font.getName() != null) {
            Font currentSwtFont = label.getFont();
            if (currentSwtFont == null || currentSwtFont.isDisposed()) {
                Font newSwtFont = DataTypeTransformation.toSwtFont(font);
                this.fontList.add(newSwtFont);
                label.setFont(newSwtFont);
            } else {
                Font newSwtFont = DataTypeTransformation.syncToSwtFont(font, currentSwtFont);
                if (newSwtFont != currentSwtFont) {
                    this.fontList.add(newSwtFont);
                    label.setFont(newSwtFont);
                    boolean wasInList = this.fontList.remove(currentSwtFont);
                    if (wasInList) {
                        currentSwtFont.dispose();
                    }
                }
            }
        }
    }

    private void addGraphicsAlgorithmForFigure(IFigure figure, GraphicsAlgorithm graphicsAlgorithm) {
        if (figure != null && graphicsAlgorithm != null) {
            this.elementFigureHash.put(graphicsAlgorithm, figure);
        }
    }

    private ILocation calculatePolylineLocation(org.eclipse.graphiti.mm.algorithms.Polyline polyline) {
        EList points = polyline.getPoints();
        int minX = points.isEmpty() ? 0 : ((org.eclipse.graphiti.mm.algorithms.styles.Point)points.toArray()[0]).getX();
        int minY = points.isEmpty() ? 0 : ((org.eclipse.graphiti.mm.algorithms.styles.Point)points.toArray()[0]).getY();
        for (org.eclipse.graphiti.mm.algorithms.styles.Point point : points) {
            int x = point.getX();
            int y = point.getY();
            minX = Math.min(minX, x);
            minY = Math.min(minY, y);
        }
        int locX = polyline.getX();
        int locY = polyline.getY();
        return new LocationImpl(minX + locX, minY + locY);
    }

    private boolean checkGA(GraphicsAlgorithm graphicsAlgorithm) {
        if (graphicsAlgorithm != null && GraphitiInternal.getEmfService().isObjectAlive((EObject)graphicsAlgorithm)) {
            IFigure ret = this.getFigureForGraphicsAlgorithm(graphicsAlgorithm);
            if (ret == null) {
                return false;
            }
            EList children = graphicsAlgorithm.getGraphicsAlgorithmChildren();
            for (GraphicsAlgorithm childGraphicsAlgorithm : children) {
                if (this.checkGA(childGraphicsAlgorithm)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkGAs(PictogramElement pe) {
        if (!GraphitiInternal.getEmfService().isObjectAlive((EObject)pe)) {
            return false;
        }
        GraphicsAlgorithm graphicsAlgorithm = pe.getGraphicsAlgorithm();
        if (!this.checkGA(graphicsAlgorithm)) {
            return false;
        }
        if (pe instanceof ContainerShape) {
            ContainerShape containerShape = (ContainerShape)pe;
            EList children = containerShape.getChildren();
            for (org.eclipse.graphiti.mm.pictograms.Shape childShape : children) {
                if (childShape.isActive() || this.checkGAs((PictogramElement)childShape)) continue;
                return false;
            }
        }
        return true;
    }

    private IFigure createFigureForGraphicsAlgorithm(PictogramElement pe, GraphicsAlgorithm graphicsAlgorithm) {
        return this.createFigureForGraphicsAlgorithm(pe, graphicsAlgorithm, false);
    }

    private IFigure createFigureForGraphicsAlgorithm(PictogramElement pe, GraphicsAlgorithm graphicsAlgorithm, boolean specialSelectionHandlingForOuterGaFigures) {
        Object ret = null;
        if (graphicsAlgorithm != null) {
            if (pe instanceof Connection) {
                ret = new GFPolylineConnection(this, graphicsAlgorithm);
            } else if (graphicsAlgorithm instanceof org.eclipse.graphiti.mm.algorithms.Ellipse) {
                ret = pe instanceof ConnectionDecorator && !pe.isActive() ? new GFEllipseDecoration(this, graphicsAlgorithm) : new GFEllipse(this, graphicsAlgorithm);
            } else if (graphicsAlgorithm instanceof Polygon) {
                ret = pe instanceof ConnectionDecorator && !pe.isActive() ? new GFPolygonDecoration(this, graphicsAlgorithm) : new GFPolygon(this, graphicsAlgorithm);
            } else if (graphicsAlgorithm instanceof org.eclipse.graphiti.mm.algorithms.Polyline) {
                ret = pe instanceof ConnectionDecorator && !pe.isActive() ? new GFPolylineDecoration(this, graphicsAlgorithm) : new GFPolyline(this, graphicsAlgorithm);
            } else if (graphicsAlgorithm instanceof org.eclipse.graphiti.mm.algorithms.Rectangle) {
                ret = new GFRectangleFigure(this, graphicsAlgorithm);
            } else if (graphicsAlgorithm instanceof RoundedRectangle) {
                ret = new GFRoundedRectangle(this, graphicsAlgorithm);
            } else if (graphicsAlgorithm instanceof MultiText) {
                ret = new GFMultilineText(this, (MultiText)graphicsAlgorithm);
            } else if (graphicsAlgorithm instanceof Text) {
                ret = new GFText(this, (Text)graphicsAlgorithm);
            } else if (graphicsAlgorithm instanceof PlatformGraphicsAlgorithm) {
                RendererContext rendererContext;
                IGraphicsAlgorithmRenderer pr;
                PlatformGraphicsAlgorithm pga = (PlatformGraphicsAlgorithm)graphicsAlgorithm;
                IGraphicsAlgorithmRendererFactory factory = this.getGraphicsAlgorithmRendererFactory();
                if (factory != null && (pr = factory.createGraphicsAlgorithmRenderer((IRendererContext)(rendererContext = new RendererContext(pga, this.getConfigurationProvider().getDiagramTypeProvider())))) instanceof IFigure) {
                    ret = (IFigure)pr;
                }
            } else if (graphicsAlgorithm instanceof Image) {
                ret = new GFImageFigure(graphicsAlgorithm);
            }
            if (ret != null) {
                if (graphicsAlgorithm.getGraphicsAlgorithmChildren().size() > 0) {
                    ret.setLayoutManager((LayoutManager)new XYLayout());
                }
                this.addGraphicsAlgorithmForFigure((IFigure)ret, graphicsAlgorithm);
                EList graphicsAlgorithmChildren = graphicsAlgorithm.getGraphicsAlgorithmChildren();
                for (GraphicsAlgorithm childGa : graphicsAlgorithmChildren) {
                    ret.add(this.createFigureForGraphicsAlgorithm(null, childGa));
                }
            }
        }
        if (specialSelectionHandlingForOuterGaFigures && ret instanceof GFAbstractShape) {
            GFAbstractShape gfAbstractShape = ret;
            IToolBehaviorProvider currentToolBehaviorProvider = this.getConfigurationProvider().getDiagramTypeProvider().getCurrentToolBehaviorProvider();
            gfAbstractShape.setSelectionBorder(currentToolBehaviorProvider.getSelectionBorder(this.getPictogramElement()));
            gfAbstractShape.setClickArea(currentToolBehaviorProvider.getClickArea(this.getPictogramElement()));
        }
        return ret;
    }

    private IFigure createFigureForPictogramElement(PictogramElement pe) {
        GraphicsAlgorithm graphicsAlgorithm = pe.getGraphicsAlgorithm();
        IFigure ret = this.createFigureForGraphicsAlgorithm(pe, graphicsAlgorithm, pe.isActive());
        if (ret == null) {
            return ret;
        }
        if (pe instanceof ContainerShape) {
            ret.setLayoutManager((LayoutManager)new XYLayout());
            ContainerShape containerShape = (ContainerShape)pe;
            EList containersChildren = containerShape.getChildren();
            for (org.eclipse.graphiti.mm.pictograms.Shape shape : containersChildren) {
                if (shape.isActive()) continue;
                IFigure f = this.createFigureForPictogramElement((PictogramElement)shape);
                ret.add(f);
            }
        } else if (pe instanceof Connection) {
            this.createFiguresForPassiveDecorators((Connection)pe);
        }
        return ret;
    }

    private void createFiguresForPassiveDecorators(Connection connection) {
        IFigure figure = this.getFigureForGraphicsAlgorithm(connection.getGraphicsAlgorithm());
        if (figure instanceof GFPolylineConnection) {
            GFPolylineConnection polylineConnection = (GFPolylineConnection)figure;
            EList c = connection.getConnectionDecorators();
            for (ConnectionDecorator connectionDecorator : c) {
                if (connectionDecorator.isActive()) continue;
                GraphicsAlgorithm graphicsAlgorithm = connectionDecorator.getGraphicsAlgorithm();
                IFigure newFigure = this.createFigureForGraphicsAlgorithm((PictogramElement)connectionDecorator, graphicsAlgorithm);
                RotatableDecoration rotatableDecoration = null;
                if (newFigure instanceof RotatableDecoration) {
                    rotatableDecoration = (RotatableDecoration)newFigure;
                }
                if (!connectionDecorator.isLocationRelative()) continue;
                double relativeLocation = connectionDecorator.getLocation();
                if (relativeLocation != 1.0) {
                    polylineConnection.addDecoration((IFigure)rotatableDecoration, true, relativeLocation, 0, 0.0);
                    continue;
                }
                polylineConnection.addDecoration((IFigure)rotatableDecoration, false, 0.0, 0, 0.0);
            }
        }
    }

    private IFigure decorateFigure(IFigure figure, IDecorator decorator) {
        IResourceRegistry resourceRegistry;
        IBorderDecorator renderingDecorator;
        if (decorator == null) {
            return null;
        }
        String messageText = decorator.getMessage();
        Object decoratorFigure = null;
        Rectangle boundsForDecoratorFigure = new Rectangle(0, 0, 16, 16);
        if (decorator instanceof IImageDecorator) {
            IFigure parent;
            IImageDecorator imageDecorator = (IImageDecorator)decorator;
            org.eclipse.swt.graphics.Image imageForId = GraphitiUi.getImageService().getImageForId(this.configurationProvider.getDiagramTypeProvider().getProviderId(), imageDecorator.getImageId());
            DecoratorImageFigure imageFigure = new DecoratorImageFigure(imageForId);
            decoratorFigure = imageFigure;
            org.eclipse.swt.graphics.Rectangle imageBounds = imageFigure.getImage().getBounds();
            boundsForDecoratorFigure.setSize(imageBounds.width, imageBounds.height);
            if (decorator instanceof ILocation) {
                ILocation location = (ILocation)decorator;
                boundsForDecoratorFigure.setLocation(location.getX(), location.getY());
            }
            if ((parent = figure.getParent()) != null) {
                Rectangle ownerBounds = (Rectangle)parent.getLayoutManager().getConstraint(figure);
                boundsForDecoratorFigure.translate(ownerBounds.getLocation());
            }
            decoratorFigure.setVisible(true);
            if (messageText != null && messageText.length() > 0) {
                decoratorFigure.setToolTip((IFigure)new Label(messageText));
            }
            if (parent.getLayoutManager() == null) {
                parent.setLayoutManager((LayoutManager)new XYLayout());
            }
            parent.add((IFigure)decoratorFigure, (Object)boundsForDecoratorFigure, parent.getChildren().indexOf(figure) + 1);
        }
        if (decorator instanceof ITextDecorator) {
            IFigure parent;
            IColorConstant foregroundColor;
            ITextDecorator textDecorator = (ITextDecorator)decorator;
            String text = textDecorator.getText();
            decoratorFigure = new Label(text);
            Font font = new Font(null, textDecorator.getFontName(), textDecorator.getFontSize(), 0);
            this.decoratorFontList.add(font);
            Dimension dimension = TextUtilities.INSTANCE.getStringExtents(text, font);
            boundsForDecoratorFigure.setSize(dimension.width, dimension.height);
            decoratorFigure.setFont(font);
            IResourceRegistry resourceRegistry2 = this.getConfigurationProvider().getResourceRegistry();
            IColorConstant backgroundColor = textDecorator.getBackgroundColor();
            if (backgroundColor != null) {
                decoratorFigure.setOpaque(true);
                decoratorFigure.setBackgroundColor(resourceRegistry2.getSwtColor(backgroundColor.getRed(), backgroundColor.getGreen(), backgroundColor.getBlue()));
            }
            if ((foregroundColor = textDecorator.getForegroundColor()) != null) {
                decoratorFigure.setForegroundColor(resourceRegistry2.getSwtColor(foregroundColor.getRed(), foregroundColor.getGreen(), foregroundColor.getBlue()));
            }
            if (decorator instanceof ILocation) {
                ILocation location = (ILocation)decorator;
                boundsForDecoratorFigure.setLocation(location.getX(), location.getY());
            }
            if ((parent = figure.getParent()) != null) {
                Rectangle ownerBounds = (Rectangle)parent.getLayoutManager().getConstraint(figure);
                boundsForDecoratorFigure.translate(ownerBounds.getLocation());
            }
            decoratorFigure.setVisible(true);
            if (messageText != null && messageText.length() > 0) {
                decoratorFigure.setToolTip((IFigure)new Label(messageText));
            }
            if (parent.getLayoutManager() == null) {
                parent.setLayoutManager((LayoutManager)new XYLayout());
            }
            parent.add((IFigure)decoratorFigure, (Object)boundsForDecoratorFigure, parent.getChildren().indexOf(figure) + 1);
        }
        if (decorator instanceof IBorderDecorator) {
            Integer borderStyle;
            renderingDecorator = (IBorderDecorator)decorator;
            resourceRegistry = this.getConfigurationProvider().getResourceRegistry();
            Integer borderWidth = renderingDecorator.getBorderWidth();
            if (borderWidth == null || borderWidth < 1) {
                borderWidth = 1;
            }
            if ((borderStyle = renderingDecorator.getBorderStyle()) == null || 2 != borderStyle && 4 != borderStyle && 5 != borderStyle && 3 != borderStyle && 1 != borderStyle) {
                borderStyle = 1;
            }
            Color borderColor = null;
            IColorConstant colorConstant = renderingDecorator.getBorderColor();
            if (colorConstant == null) {
                colorConstant = IColorConstant.BLACK;
            }
            borderColor = resourceRegistry.getSwtColor(colorConstant.getRed(), colorConstant.getGreen(), colorConstant.getBlue());
            figure.setBorder((Border)new LineBorder(borderColor, borderWidth.intValue(), borderStyle.intValue()));
        }
        if (decorator instanceof IColorDecorator) {
            renderingDecorator = (IColorDecorator)decorator;
            resourceRegistry = this.getConfigurationProvider().getResourceRegistry();
            Color backgroundColor = null;
            IColorConstant colorConstant = renderingDecorator.getBackgroundColor();
            if (colorConstant != null) {
                backgroundColor = resourceRegistry.getSwtColor(colorConstant.getRed(), colorConstant.getGreen(), colorConstant.getBlue());
            }
            Color foregroundColor = null;
            colorConstant = renderingDecorator.getForegroundColor();
            if (colorConstant != null) {
                foregroundColor = resourceRegistry.getSwtColor(colorConstant.getRed(), colorConstant.getGreen(), colorConstant.getBlue());
            }
            if (foregroundColor != null) {
                figure.setForegroundColor(foregroundColor);
            }
            if (backgroundColor != null) {
                figure.setBackgroundColor(backgroundColor);
            }
            if (figure instanceof Shape) {
                ((Shape)figure).setFill(true);
            }
        }
        return decoratorFigure;
    }

    private void disposeFonts() {
        for (Font font : this.fontList) {
            font.dispose();
        }
        this.disposeDecoratorFonts();
    }

    private void disposeDecoratorFonts() {
        for (Font font : this.decoratorFontList) {
            font.dispose();
        }
    }

    private Label indicateNeededUpdates(IFigure figure, IReason updateNeeded) {
        Label ret = null;
        if (figure != null && updateNeeded != null && updateNeeded.toBoolean()) {
            figure.setForegroundColor(ColorConstants.red);
            if (figure instanceof Shape) {
                Shape draw2dShape = (Shape)figure;
                draw2dShape.setLineWidth(2);
                draw2dShape.setLineStyle(3);
                String updateNeededText = updateNeeded.getText();
                if (updateNeededText != null && updateNeededText.length() > 0) {
                    Label toolTipFigure = new Label();
                    toolTipFigure.setText(updateNeededText);
                    org.eclipse.swt.graphics.Image image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
                    toolTipFigure.setIcon(image);
                    ret = toolTipFigure;
                }
            }
        }
        return ret;
    }

    private boolean isConnectionRefreshPossible(Connection connection) {
        if (!GraphitiInternal.getEmfService().isObjectAlive((EObject)connection)) {
            return false;
        }
        ArrayList<GraphicsAlgorithm> gaList = new ArrayList<GraphicsAlgorithm>();
        EList c = connection.getConnectionDecorators();
        for (ConnectionDecorator connectionDecorator : c) {
            GraphicsAlgorithm ga;
            if (connectionDecorator.isActive() || (ga = connectionDecorator.getGraphicsAlgorithm()) == null) continue;
            gaList.add(ga);
        }
        if (connection.getGraphicsAlgorithm() != null) {
            gaList.add(connection.getGraphicsAlgorithm());
        }
        for (GraphicsAlgorithm graphicsAlgorithm : gaList) {
            IFigure figure = this.getFigureForGraphicsAlgorithm(graphicsAlgorithm);
            if (figure != null) continue;
            return false;
        }
        for (GraphicsAlgorithm graphicsAlgorithm : this.elementFigureHash.keySet()) {
            if (gaList.contains(graphicsAlgorithm)) continue;
            return false;
        }
        return true;
    }

    private boolean isRefreshPossible(PictogramElement pe) {
        if (pe instanceof org.eclipse.graphiti.mm.pictograms.Shape || pe instanceof AdvancedAnchor) {
            boolean ret = this.checkGAs(pe);
            if (!ret) {
                return ret;
            }
            for (GraphicsAlgorithm graphicsAlgorithm : this.elementFigureHash.keySet()) {
                if (GraphitiInternal.getEmfService().isObjectAlive((EObject)graphicsAlgorithm)) continue;
                return false;
            }
        }
        return true;
    }

    private void refreshFigureColors(IFigure figure, GraphicsAlgorithm graphicsAlgorithm) {
        Color fg = DataTypeTransformation.toSwtColor(this.getConfigurationProvider().getResourceRegistry(), Graphiti.getGaService().getForegroundColor(graphicsAlgorithm, true));
        Color bg = DataTypeTransformation.toSwtColor(this.getConfigurationProvider().getResourceRegistry(), Graphiti.getGaService().getBackgroundColor(graphicsAlgorithm, true));
        figure.setBackgroundColor(bg);
        figure.setForegroundColor(fg);
    }

    private void refreshFigureForPictogramElement(PictogramElement pe) {
        if (pe != null) {
            DefaultRefreshBehavior refreshBehavior = this.getDiagramBehavior().getRefreshBehavior();
            if (!this.isForceRefresh() && refreshBehavior.isMultipleRefreshSupressionActive() && !refreshBehavior.shouldRefresh(pe)) {
                return;
            }
            if (pe instanceof ContainerShape) {
                ContainerShape containerShape = (ContainerShape)pe;
                EList children = containerShape.getChildren();
                for (org.eclipse.graphiti.mm.pictograms.Shape shape : children) {
                    if (shape.isActive()) continue;
                    this.refreshFigureForPictogramElement((PictogramElement)shape);
                }
            } else if (pe instanceof Connection) {
                Connection connection = (Connection)pe;
                EList c = connection.getConnectionDecorators();
                for (ConnectionDecorator decorator : c) {
                    if (decorator.isActive()) continue;
                    this.refreshFigureForPictogramElement((PictogramElement)decorator);
                }
            }
            GraphicsAlgorithm ga = pe.getGraphicsAlgorithm();
            if (ga != null) {
                IReason updateNeeded = this.checkIfUpdateNeeded(pe);
                this.refreshFigureForGraphicsAlgorithm(ga, pe, updateNeeded);
            }
        }
    }

    private void refreshShapeData(Shape shape, GraphicsAlgorithm graphicsAlgorithm) {
        if (shape == null || graphicsAlgorithm == null) {
            return;
        }
        int lineWidth = Graphiti.getGaService().getLineWidth(graphicsAlgorithm, true);
        shape.setLineWidth(lineWidth);
        LineStyle lineStyle = Graphiti.getGaService().getLineStyle(graphicsAlgorithm, true);
        int draw2dLineStyle = 1;
        if (lineStyle == LineStyle.DASH) {
            draw2dLineStyle = 2;
        } else if (lineStyle == LineStyle.DASHDOT) {
            draw2dLineStyle = 4;
        } else if (lineStyle == LineStyle.DASHDOTDOT) {
            draw2dLineStyle = 5;
        } else if (lineStyle == LineStyle.DOT) {
            draw2dLineStyle = 3;
        } else if (lineStyle == LineStyle.SOLID) {
            draw2dLineStyle = 1;
        }
        shape.setLineStyle(draw2dLineStyle);
        boolean filled = Graphiti.getGaService().isFilled(graphicsAlgorithm, true);
        shape.setFill(filled);
        boolean lineVisible = Graphiti.getGaService().isLineVisible(graphicsAlgorithm, true);
        shape.setOutline(lineVisible);
    }

    private void refreshTextOrientation(GFText label, Text text) {
        int draw2dOrientation = 1;
        Orientation orientation = Graphiti.getGaService().getHorizontalAlignment((AbstractText)text, true);
        if (orientation != null) {
            if (orientation == Orientation.ALIGNMENT_BOTTOM) {
                draw2dOrientation = 32;
            } else if (orientation == Orientation.ALIGNMENT_CENTER) {
                draw2dOrientation = 2;
            } else if (orientation == Orientation.ALIGNMENT_LEFT) {
                draw2dOrientation = 1;
            } else if (orientation == Orientation.ALIGNMENT_RIGHT) {
                draw2dOrientation = 4;
            } else if (orientation == Orientation.ALIGNMENT_TOP) {
                draw2dOrientation = 8;
            }
        }
        label.setLabelAlignment(draw2dOrientation);
    }

    private void refreshFlowTextAlignment(GFMultilineText label, MultiText text) {
        int draw2dOrientation = 1;
        Orientation orientation = Graphiti.getGaService().getHorizontalAlignment((AbstractText)text, true);
        if (orientation != null) {
            if (orientation == Orientation.ALIGNMENT_RIGHT) {
                draw2dOrientation = 4;
            } else if (orientation == Orientation.ALIGNMENT_CENTER) {
                draw2dOrientation = 2;
            }
        }
        label.setHorizontalAligment(draw2dOrientation);
        draw2dOrientation = 8;
        orientation = Graphiti.getGaService().getVerticalAlignment((AbstractText)text, true);
        if (orientation != null) {
            if (orientation == Orientation.ALIGNMENT_BOTTOM) {
                draw2dOrientation = 32;
            } else if (orientation == Orientation.ALIGNMENT_CENTER) {
                draw2dOrientation = 16;
            }
        }
        label.setVerticalAligment(draw2dOrientation);
    }

    private void setConfigurationProvider(IConfigurationProviderInternal configurationProvider) {
        this.configurationProvider = configurationProvider;
    }

    private void setFigureConstraint(IFigure figure, GraphicsAlgorithm graphicsAlgorithm, PictogramElement pe) {
        IFigure parent;
        if (figure instanceof PolylineConnection || figure instanceof GFPolylineConnection || figure instanceof RotatableDecoration && !(figure instanceof GFText) || figure.getParent() == null) {
            return;
        }
        IDimension gaSize = Graphiti.getGaService().calculateSize(graphicsAlgorithm);
        if (gaSize == null) {
            return;
        }
        Dimension dimension = new Dimension(gaSize.getWidth(), gaSize.getHeight());
        if (figure instanceof GFText && pe instanceof ConnectionDecorator && !pe.isActive() && figure.getParent() instanceof GFPolylineConnection) {
            GFText text = (GFText)figure;
            text.setSize(dimension);
            return;
        }
        Object gaLocation = null;
        gaLocation = !(graphicsAlgorithm instanceof org.eclipse.graphiti.mm.algorithms.Polyline) ? new LocationImpl(graphicsAlgorithm.getX(), graphicsAlgorithm.getY()) : this.calculatePolylineLocation((org.eclipse.graphiti.mm.algorithms.Polyline)graphicsAlgorithm);
        if (gaLocation == null) {
            gaLocation = new LocationImpl(0, 0);
        }
        Point point = null;
        if (pe instanceof ConnectionDecorator && pe.isActive()) {
            Label label;
            ConnectionDecorator connectionDecorator = (ConnectionDecorator)pe;
            Connection connection = connectionDecorator.getConnection();
            Point pointAt = null;
            double decoratorLocation = connectionDecorator.getLocation();
            pointAt = connectionDecorator.isLocationRelative() ? GraphitiUiInternal.getGefService().getConnectionPointAt(connection, decoratorLocation) : GraphitiUiInternal.getGefService().getAbsolutePointOnConnection(connection, decoratorLocation);
            if (pointAt == null) {
                return;
            }
            point = new Point(pointAt.x + gaLocation.getX(), pointAt.y + gaLocation.getY());
            if (figure instanceof Label && connectionDecorator.getGraphicsAlgorithm() instanceof Text && (label = (Label)figure).getText() != null && label.getText().length() > 0) {
                dimension = label.getTextBounds().getSize();
                dimension.width += label.getText().length();
            }
        } else if (pe instanceof BoxRelativeAnchor && pe.equals(graphicsAlgorithm.getPictogramElement())) {
            BoxRelativeAnchor bra = (BoxRelativeAnchor)pe;
            IRectangle gaBoundsForAnchor = Graphiti.getLayoutService().getGaBoundsForAnchor((Anchor)bra);
            double newX = (double)gaBoundsForAnchor.getX() + (double)gaBoundsForAnchor.getWidth() * bra.getRelativeWidth() + (double)gaLocation.getX();
            double newY = (double)gaBoundsForAnchor.getY() + (double)gaBoundsForAnchor.getHeight() * bra.getRelativeHeight() + (double)gaLocation.getY();
            point = new PrecisionPoint(newX, newY);
        } else if (pe instanceof FixPointAnchor && pe.equals(graphicsAlgorithm.getPictogramElement())) {
            FixPointAnchor fpa = (FixPointAnchor)pe;
            IRectangle gaBoundsForAnchor = Graphiti.getLayoutService().getGaBoundsForAnchor((Anchor)fpa);
            org.eclipse.graphiti.mm.algorithms.styles.Point fpaLocation = fpa.getLocation();
            if (fpaLocation == null) {
                return;
            }
            point = new Point(gaBoundsForAnchor.getX() + fpaLocation.getX() + gaLocation.getX(), gaBoundsForAnchor.getY() + fpaLocation.getY() + gaLocation.getY());
        } else {
            point = new Point(gaLocation.getX(), gaLocation.getY());
        }
        if (point != null && (parent = figure.getParent()) != null) {
            parent.setConstraint(figure, (Object)new Rectangle(point, dimension));
        }
    }

    private void setPictogramElement(PictogramElement pictogramElement) {
        this.pictogramElement = pictogramElement;
    }

    private PointList toAbsoluteDraw2dPoints(Collection<org.eclipse.graphiti.mm.algorithms.styles.Point> points, ILocation location) {
        int deltaX = 0;
        int deltaY = 0;
        if (location != null) {
            deltaX = location.getX();
            deltaY = location.getY();
        }
        PointList pointList = new PointList();
        for (org.eclipse.graphiti.mm.algorithms.styles.Point dtp : points) {
            pointList.addPoint(dtp.getX() + deltaX, dtp.getY() + deltaY);
        }
        return pointList;
    }

    private int[] getBezierDistances(Collection<org.eclipse.graphiti.mm.algorithms.styles.Point> points) {
        if (this.getPreferences().getPolylineRounding() == 0 || this.getPreferences().getPolylineRounding() == 2) {
            int i = 0;
            int[] bezierDistances = new int[points.size() * 2];
            for (org.eclipse.graphiti.mm.algorithms.styles.Point dtp : points) {
                if (this.getPreferences().getPolylineRounding() == 0) {
                    bezierDistances[i++] = dtp.getBefore();
                    bezierDistances[i++] = dtp.getAfter();
                    continue;
                }
                if (this.getPreferences().getPolylineRounding() != 2) continue;
                bezierDistances[i++] = 15;
                bezierDistances[i++] = 15;
            }
            return bezierDistances;
        }
        return null;
    }

    private IGraphicsAlgorithmRendererFactory getGraphicsAlgorithmRendererFactory() {
        return this.getConfigurationProvider().getDiagramTypeProvider().getGraphicsAlgorithmRendererFactory();
    }

    public IFeatureProvider getFeatureProvider() {
        IConfigurationProviderInternal cp = this.getConfigurationProvider();
        IFeatureProvider ret = null;
        if (cp != null) {
            ret = cp.getFeatureProvider();
        }
        if (T.racer().info()) {
            T.racer().info("PictogramElementDelegate", "getFeatureProvider", "returns " + ret.toString());
        }
        return ret;
    }

    @Override
    public void setForceRefresh(boolean forceRefresh) {
        this.forceRefresh = forceRefresh;
    }

    protected boolean isForceRefresh() {
        return this.forceRefresh;
    }

    private DiagramBehavior getDiagramBehavior() {
        return this.getConfigurationProvider().getDiagramBehavior();
    }

    protected void addDecorators(GraphicsAlgorithm graphicsAlgorithm, PictogramElement pe, IFigure figure, IToolBehaviorProvider toolBehaviorProvider) {
        if (pe.isActive() && !(pe instanceof Anchor) && !(pe instanceof Connection) && graphicsAlgorithm.equals(pe.getGraphicsAlgorithm())) {
            this.removeDecorators(figure);
            this.refreshFigureColors(figure, graphicsAlgorithm);
            figure.setBorder(null);
            IDecorator[] decorators = toolBehaviorProvider.getDecorators(pe);
            if (decorators.length > 0) {
                ArrayList<IFigure> decList = new ArrayList<IFigure>();
                this.decoratorMap.put(figure, decList);
                int i = 0;
                while (i < decorators.length) {
                    IDecorator decorator = decorators[i];
                    IFigure decorateFigure = this.decorateFigure(figure, decorator);
                    if (decorateFigure != null) {
                        decList.add(decorateFigure);
                    }
                    ++i;
                }
            }
        }
    }

    private void removeDecorators(IFigure figure) {
        List<IFigure> decFigureList = this.decoratorMap.get(figure);
        if (decFigureList != null) {
            for (IFigure decFigure : decFigureList) {
                IFigure parent = decFigure.getParent();
                if (parent == null) continue;
                parent.remove(decFigure);
            }
            decFigureList.clear();
            this.decoratorMap.remove(figure);
        }
        this.disposeDecoratorFonts();
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    protected void setValid(boolean valid) {
        this.valid = valid;
    }

    public IVisualState getVisualState() {
        if (this.visualState == null) {
            this.visualState = new VisualState();
        }
        return this.visualState;
    }

    private boolean isDefaultBendPointRenderingActive() {
        boolean defaultBendPointRenderingActive = true;
        IToolBehaviorProvider ctbp = this.getConfigurationProvider().getDiagramTypeProvider().getCurrentToolBehaviorProvider();
        if (ctbp instanceof DefaultToolBehaviorProvider) {
            defaultBendPointRenderingActive = ((DefaultToolBehaviorProvider)ctbp).isDefaultBendPointRenderingActive();
        }
        return defaultBendPointRenderingActive;
    }

    @Override
    public List<IFigure> getMainFiguresFromChildEditparts() {
        ArrayList<IFigure> ret = new ArrayList<IFigure>();
        List<EditPart> children = GraphitiUiInternal.getGefService().getEditPartChildren(this.getContainerEditPart());
        for (EditPart ep : children) {
            if (!(ep instanceof ShapeEditPart) && !(ep instanceof AdvancedAnchorEditPart)) continue;
            GraphicalEditPart gep = (GraphicalEditPart)ep;
            ret.add(gep.getFigure());
        }
        return ret;
    }

    protected GFPreferences getPreferences() {
        return GFPreferences.getInstance();
    }
}

