/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.editor;

import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.ui.editor.DiagramBehavior;
import org.eclipse.graphiti.ui.editor.ElementDeleteListener;
import org.eclipse.graphiti.ui.editor.IDiagramContainerUI;
import org.eclipse.graphiti.ui.editor.ResourceSetUpdateAdapter;
import org.eclipse.graphiti.ui.internal.Messages;
import org.eclipse.graphiti.ui.internal.editor.DomainModelWorkspaceSynchronizerDelegate;
import org.eclipse.graphiti.ui.internal.services.GraphitiUiInternal;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;

public class DefaultUpdateBehavior
extends PlatformObject
implements IEditingDomainProvider,
IOperationHistoryListener {
    protected final DiagramBehavior diagramBehavior;
    private TransactionalEditingDomain editingDomain;
    private ElementDeleteListener elementDeleteListener = null;
    private ResourceSetUpdateAdapter resourceSetUpdateAdapter;
    private boolean resourceDeleted = false;
    private boolean resourceChanged = false;
    private WorkspaceSynchronizer workspaceSynchronizer;
    private boolean adapterActive = true;
    private Adapter updateAdapter = null;

    public DefaultUpdateBehavior(DiagramBehavior diagramBehavior) {
        this.diagramBehavior = diagramBehavior;
    }

    protected boolean isResourceDeleted() {
        return this.resourceDeleted;
    }

    public void setResourceDeleted(boolean resourceDeleted) {
        this.resourceDeleted = resourceDeleted;
    }

    protected boolean isResourceChanged() {
        return this.resourceChanged;
    }

    public void setResourceChanged(boolean resourceChanged) {
        this.resourceChanged = resourceChanged;
    }

    public void handleActivate() {
        if (this.isResourceDeleted()) {
            if (this.handleDirtyConflict()) {
                this.closeContainer();
            } else {
                this.setResourceDeleted(false);
                this.setResourceChanged(false);
            }
        } else if (this.isResourceChanged()) {
            this.handleChangedResources();
            this.setResourceChanged(false);
        }
    }

    protected boolean isAdapterActive() {
        return this.adapterActive;
    }

    public void setAdapterActive(boolean active) {
        this.adapterActive = active;
    }

    protected void handleChangedResources() {
        if (!this.diagramBehavior.getDiagramContainer().isDirty() || this.handleDirtyConflict()) {
            IUndoContext undoContext = ((IWorkspaceCommandStack)this.getEditingDomain().getCommandStack()).getDefaultUndoContext();
            IOperationHistory operationHistory = this.getOperationHistory();
            if (operationHistory != null) {
                operationHistory.dispose(undoContext, true, true, true);
            }
            this.diagramBehavior.disableAdapters();
            try {
                EList resources = this.getEditingDomain().getResourceSet().getResources();
                for (Resource resource : resources) {
                    resource.unload();
                }
                this.diagramBehavior.refreshContent();
            }
            finally {
                this.diagramBehavior.enableAdapters();
            }
        }
    }

    protected boolean handleDirtyConflict() {
        return MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.DiscardChangesDialog_0_xmsg, (String)Messages.DiscardChangesDialog_1_xmsg);
    }

    public TransactionalEditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void init() {
        IOperationHistory operationHistory;
        EObject object = (EObject)this.diagramBehavior.getAdapter(Diagram.class);
        if (object != null) {
            this.elementDeleteListener = new ElementDeleteListener(this.diagramBehavior);
            object.eAdapters().add((Object)this.elementDeleteListener);
        }
        if ((operationHistory = this.getOperationHistory()) != null) {
            operationHistory.addOperationHistoryListener((IOperationHistoryListener)this);
        }
    }

    protected Adapter createUpdateAdapter() {
        return new DefaultUpdateAdapter();
    }

    protected Adapter getUpdateAdapter() {
        return this.updateAdapter;
    }

    protected void createEditingDomain() {
        TransactionalEditingDomain editingDomain = GraphitiUiInternal.getEmfService().createResourceSetAndEditingDomain();
        this.initializeEditingDomain(editingDomain);
    }

    protected void initializeEditingDomain(TransactionalEditingDomain domain) {
        this.editingDomain = domain;
        ResourceSet resourceSet = domain.getResourceSet();
        this.updateAdapter = this.createUpdateAdapter();
        this.resourceSetUpdateAdapter = new ResourceSetUpdateAdapter(this.updateAdapter);
        resourceSet.eAdapters().add((Object)this.resourceSetUpdateAdapter);
        WorkspaceSynchronizer.Delegate synchronizerDelegate = this.createWorkspaceSynchronizerDelegate();
        if (synchronizerDelegate != null) {
            this.workspaceSynchronizer = new WorkspaceSynchronizer(this.getEditingDomain(), synchronizerDelegate);
        }
        this.diagramBehavior.editingDomainInitialized();
    }

    protected WorkspaceSynchronizer.Delegate createWorkspaceSynchronizerDelegate() {
        return new DomainModelWorkspaceSynchronizerDelegate(this.diagramBehavior);
    }

    public void dispose() {
        this.editingDomain.getResourceSet().eAdapters().remove((Object)this.resourceSetUpdateAdapter);
        this.resourceSetUpdateAdapter = null;
        IOperationHistory operationHistory = this.getOperationHistory();
        if (operationHistory != null) {
            operationHistory.removeOperationHistoryListener((IOperationHistoryListener)this);
        }
        for (Resource r : this.editingDomain.getResourceSet().getResources()) {
            r.eAdapters().remove((Object)this.updateAdapter);
        }
        EObject object = (EObject)this.diagramBehavior.getAdapter(Diagram.class);
        if (object != null) {
            object.eAdapters().remove((Object)this.elementDeleteListener);
        }
        if (this.workspaceSynchronizer != null) {
            this.workspaceSynchronizer.dispose();
        }
        this.disposeEditingDomain();
        this.editingDomain = null;
    }

    protected void disposeEditingDomain() {
        this.editingDomain.dispose();
    }

    public void historyNotification(OperationHistoryEvent event) {
        switch (event.getEventType()) {
            case 9: 
            case 10: {
                this.diagramBehavior.getDiagramContainer().updateDirtyState();
            }
        }
    }

    private Shell getShell() {
        return this.diagramBehavior.getDiagramContainer().getSite().getShell();
    }

    protected void closeContainer() {
        IDiagramContainerUI diagramContainer = this.diagramBehavior.getDiagramContainer();
        if (diagramContainer == null) {
            return;
        }
        IWorkbenchPartSite site = diagramContainer.getSite();
        if (site == null) {
            return;
        }
        IWorkbenchPage page = site.getPage();
        if (page == null) {
            return;
        }
        diagramContainer.close();
    }

    protected IOperationHistory getOperationHistory() {
        IWorkspaceCommandStack commandStack;
        IOperationHistory history = null;
        TransactionalEditingDomain domain = this.getEditingDomain();
        if (domain != null && (commandStack = (IWorkspaceCommandStack)domain.getCommandStack()) != null) {
            history = commandStack.getOperationHistory();
        }
        return history;
    }

    public void setEditingDomain(TransactionalEditingDomain editingDomain) {
        this.editingDomain = editingDomain;
        this.initializeEditingDomain(editingDomain);
    }

    protected class DefaultUpdateAdapter
    extends AdapterImpl {
        protected DefaultUpdateAdapter() {
        }

        public void notifyChanged(Notification msg) {
            if (!DefaultUpdateBehavior.this.isAdapterActive()) {
                return;
            }
            if (msg.getFeatureID(Resource.class) == 4 && msg.getNewBooleanValue() == Boolean.FALSE.booleanValue()) {
                Resource resource = (Resource)msg.getNotifier();
                URI uri = resource.getURI();
                IDiagramContainerUI diagramContainer = DefaultUpdateBehavior.this.diagramBehavior.getDiagramContainer();
                if (DefaultUpdateBehavior.this.editingDomain.getResourceSet().getURIConverter().exists(uri, null)) {
                    DefaultUpdateBehavior.this.setResourceChanged(true);
                    IWorkbenchPart activePart = diagramContainer.getWorkbenchPart().getSite().getPage().getActivePart();
                    if (activePart == diagramContainer) {
                        DefaultUpdateBehavior.this.getShell().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                DefaultUpdateBehavior.this.handleActivate();
                            }
                        });
                    }
                } else if (!diagramContainer.isDirty()) {
                    URI uriOfDiagramFile;
                    URI diagramUri;
                    Diagram diagram = diagramContainer.getDiagramTypeProvider().getDiagram();
                    if (diagram != null && (diagramUri = EcoreUtil.getURI((EObject)diagram)) != null && (uriOfDiagramFile = diagramUri.trimFragment()).equals(uri)) {
                        this.closeEditorAsynchronously();
                    }
                } else {
                    DefaultUpdateBehavior.this.setResourceDeleted(true);
                    IWorkbenchPart activePart = diagramContainer.getWorkbenchPart().getSite().getPage().getActivePart();
                    if (activePart == diagramContainer) {
                        DefaultUpdateBehavior.this.getShell().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                DefaultUpdateBehavior.this.handleActivate();
                            }
                        });
                    }
                }
            }
            super.notifyChanged(msg);
        }

        protected void closeEditorAsynchronously() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DefaultUpdateBehavior.this.closeContainer();
                }
            });
        }
    }
}

