/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.util.draw2d;

import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Polygon;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.graphiti.mm.pictograms.AdvancedAnchor;
import org.eclipse.graphiti.ui.internal.figures.GFEllipse;
import org.eclipse.graphiti.ui.internal.figures.GFEllipseDecoration;
import org.eclipse.graphiti.ui.internal.figures.GFPolygon;
import org.eclipse.graphiti.ui.internal.figures.GFPolyline;
import org.eclipse.graphiti.ui.internal.util.draw2d.ChopboxAnchorFixed;
import org.eclipse.graphiti.ui.internal.util.draw2d.LineSeg;

public class GFChopboxAnchor
extends ChopboxAnchorFixed {
    public GFChopboxAnchor(IFigure figure) {
        super(figure, null);
    }

    public GFChopboxAnchor(IFigure figure, AdvancedAnchor advancedAnchor) {
        super(figure, advancedAnchor);
    }

    protected Rectangle getBox() {
        if (this.getOwner() instanceof HandleBounds) {
            Rectangle copy = ((HandleBounds)this.getOwner()).getHandleBounds().getCopy();
            if (this.getAdvancedAnchor() != null && this.getAdvancedAnchor().isUseAnchorLocationAsConnectionEndpoint()) {
                int x = this.getAdvancedAnchor().getGraphicsAlgorithm().getX();
                int y = this.getAdvancedAnchor().getGraphicsAlgorithm().getY();
                copy.translate(-x, -y);
                copy.setHeight(1);
                copy.setWidth(1);
            }
            return copy;
        }
        return this.getOwner().getBounds().getCopy();
    }

    @Override
    public Point getLocation(Point reference) {
        if (this.getOwner() instanceof GFEllipse || this.getOwner() instanceof GFEllipseDecoration || this.getOwner() instanceof Ellipse) {
            Rectangle r = Rectangle.SINGLETON;
            r.setBounds(this.getBox());
            r.translate(-1, -1);
            r.resize(1, 1);
            this.getOwner().translateToAbsolute((Translatable)r);
            Point ref = r.getCenter().negate().translate(reference);
            if (ref.x == 0) {
                return new Point(reference.x, ref.y > 0 ? r.bottom() : r.y);
            }
            if (ref.y == 0) {
                return new Point(ref.x > 0 ? r.right() : r.x, reference.y);
            }
            float dx = ref.x > 0 ? 0.5f : -0.5f;
            float dy = ref.y > 0 ? 0.5f : -0.5f;
            float k = (float)(ref.y * r.width) / (float)(ref.x * r.height);
            k *= k;
            return r.getCenter().translate((int)((double)((float)r.width * dx) / Math.sqrt(1.0f + k)), (int)((double)((float)r.height * dy) / Math.sqrt(1.0f + 1.0f / k)));
        }
        if (this.getOwner() instanceof GFPolygon || this.getOwner() instanceof Polygon || this.getOwner() instanceof GFPolyline || this.getOwner() instanceof Polyline) {
            Point foreignReference = reference.getCopy();
            Point ownReference = this.getReferencePoint().getCopy();
            Point location = this.getLocation(ownReference, foreignReference);
            if (location == null || this.getBox().expand(1, 1).contains(foreignReference) && !this.getBox().shrink(1, 1).contains(foreignReference)) {
                location = this.getLocation(this.getBox().getCenter(), foreignReference);
            }
            if (location == null) {
                location = this.getBox().getCenter();
            }
            return location;
        }
        return super.getLocation(reference);
    }

    protected Point getLocation(Point ownReference, Point foreignReference) {
        PointList intersections = this.getIntersectionPoints(ownReference, foreignReference);
        if (intersections != null && intersections.size() != 0) {
            Point location = GFChopboxAnchor.pickClosestPoint(intersections, foreignReference);
            return location;
        }
        return null;
    }

    public static Point pickClosestPoint(PointList points, Point p) {
        Point result = points.getFirstPoint();
        int i = 1;
        while (i < points.size()) {
            Point temp = points.getPoint(i);
            if (Math.abs(temp.x - p.x) < Math.abs(result.x - p.x)) {
                result = temp;
            } else if (Math.abs(temp.y - p.y) < Math.abs(result.y - p.y)) {
                result = temp;
            }
            ++i;
        }
        return result;
    }

    protected PointList getIntersectionPoints(Point ownReference, Point foreignReference) {
        PointList polygon = this.getPolylinePoints();
        return new LineSeg(ownReference, foreignReference).getLineIntersectionsWithLineSegs(polygon);
    }

    protected PointList getPolylinePoints() {
        if (this.getOwner() instanceof GFPolyline) {
            PointList polyList = ((GFPolyline)this.getOwner()).getPoints().getCopy();
            polyList.addPoint(polyList.getFirstPoint());
            this.getOwner().translateToAbsolute((Translatable)polyList);
            return polyList;
        }
        return null;
    }

    public static PrecisionPoint getAnchorRelativeLocation(Point p, Rectangle bounds) {
        PrecisionPoint relLocation;
        Point temp = new Point(p);
        if (p.x < bounds.x || p.x > bounds.x + bounds.width || p.y < bounds.y || p.y > bounds.y + bounds.height) {
            if (p.x < bounds.x || p.x > bounds.x + bounds.width) {
                int n = temp.x = p.x < bounds.x ? bounds.x : bounds.x + bounds.width;
            }
            if (p.y < bounds.y || p.y > bounds.y + bounds.height) {
                temp.y = p.y < bounds.y ? bounds.y : bounds.y + bounds.height;
            }
            relLocation = new PrecisionPoint((double)(temp.x - bounds.x) / (double)bounds.width, (double)(temp.y - bounds.y) / (double)bounds.height);
        } else {
            relLocation = new PrecisionPoint((double)(temp.x - bounds.x) / (double)bounds.width, (double)(temp.y - bounds.y) / (double)bounds.height);
        }
        return relLocation;
    }
}

