/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.editor;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramsPackage;
import org.eclipse.graphiti.ui.editor.DiagramBehavior;
import org.eclipse.graphiti.ui.internal.GraphitiUIPlugin;
import org.eclipse.graphiti.ui.internal.T;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.IThreadListener;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.swt.widgets.Display;

public class DefaultPersistencyBehavior {
    protected final DiagramBehavior diagramBehavior;
    protected Command savedCommand = null;

    public DefaultPersistencyBehavior(DiagramBehavior diagramBehavior) {
        this.diagramBehavior = diagramBehavior;
    }

    public Diagram loadDiagram(URI uri) {
        TransactionalEditingDomain editingDomain;
        if (uri != null && (editingDomain = this.diagramBehavior.getEditingDomain()) != null) {
            EObject modelElement = null;
            try {
                modelElement = editingDomain.getResourceSet().getEObject(uri, false);
                if (modelElement == null && (modelElement = editingDomain.getResourceSet().getEObject(uri, true)) == null) {
                    return null;
                }
            }
            catch (WrappedException e) {
                T.racer().debug("Diagram with URI '" + uri.toString() + "' could not be loaded", e);
                return null;
            }
            modelElement.eResource().setTrackingModification(true);
            return (Diagram)modelElement;
        }
        return null;
    }

    public void saveDiagram(IProgressMonitor monitor) {
        HashSet<Resource> savedResources;
        block6: {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            Diagram diagram = this.diagramBehavior.getDiagramTypeProvider().getDiagram();
            this.setDiagramVersion(diagram);
            Map<Resource, Map<?, ?>> saveOptions = this.createSaveOptions();
            savedResources = new HashSet<Resource>();
            IRunnableWithProgress operation = this.createOperation(savedResources, saveOptions);
            this.diagramBehavior.disableAdapters();
            try {
                try {
                    ModalContext.run((IRunnableWithProgress)operation, (boolean)true, (IProgressMonitor)monitor, (Display)Display.getDefault());
                    BasicCommandStack commandStack = (BasicCommandStack)this.diagramBehavior.getEditingDomain().getCommandStack();
                    commandStack.saveIsDone();
                    this.savedCommand = commandStack.getUndoCommand();
                    this.diagramBehavior.getDiagramContainer().updateDirtyState();
                }
                catch (Exception exception) {
                    T.racer().error(exception.getMessage(), exception);
                    this.diagramBehavior.enableAdapters();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.diagramBehavior.enableAdapters();
                throw throwable;
            }
            this.diagramBehavior.enableAdapters();
        }
        Resource[] savedResourcesArray = savedResources.toArray(new Resource[savedResources.size()]);
        this.diagramBehavior.getDiagramContainer().commandStackChanged(null);
        IDiagramTypeProvider provider = this.diagramBehavior.getConfigurationProvider().getDiagramTypeProvider();
        provider.resourcesSaved(provider.getDiagram(), savedResourcesArray);
    }

    public boolean isDirty() {
        TransactionalEditingDomain editingDomain = this.diagramBehavior.getEditingDomain();
        if (editingDomain == null) {
            return false;
        }
        BasicCommandStack commandStack = (BasicCommandStack)editingDomain.getCommandStack();
        if (commandStack == null) {
            return false;
        }
        return this.savedCommand != commandStack.getUndoCommand();
    }

    protected Map<Resource, Map<?, ?>> createSaveOptions() {
        HashMap<String, String> saveOption = new HashMap<String, String>();
        saveOption.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        EList resources = this.diagramBehavior.getEditingDomain().getResourceSet().getResources();
        HashMap saveOptions = new HashMap();
        for (Resource resource : resources) {
            saveOptions.put(resource, saveOption);
        }
        return saveOptions;
    }

    protected IRunnableWithProgress createOperation(Set<Resource> savedResources, Map<Resource, Map<?, ?>> saveOptions) {
        SaveOperation operation = new SaveOperation(saveOptions, savedResources);
        return operation;
    }

    protected Set<Resource> save(final TransactionalEditingDomain editingDomain, final Map<Resource, Map<?, ?>> saveOptions, IProgressMonitor monitor) {
        final HashMap<URI, Throwable> failedSaves = new HashMap<URI, Throwable>();
        final HashSet<Resource> savedResources = new HashSet<Resource>();
        IWorkspaceRunnable wsRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        InternalTransaction parentTx;
                        if (editingDomain != null && (parentTx = ((InternalTransactionalEditingDomain)editingDomain).getActiveTransaction()) != null) {
                            do {
                                if (parentTx.isReadOnly()) continue;
                                throw new IllegalStateException("saveInWorkspaceRunnable() called from within a command (likely to produce deadlock)");
                            } while ((parentTx = ((InternalTransactionalEditingDomain)editingDomain).getActiveTransaction().getParent()) != null);
                        }
                        EList resources = editingDomain.getResourceSet().getResources();
                        Object[] resourcesArray = new Resource[resources.size()];
                        resourcesArray = (Resource[])resources.toArray(resourcesArray);
                        int i = 0;
                        while (i < resourcesArray.length) {
                            Object resource = resourcesArray[i];
                            if (DefaultPersistencyBehavior.this.shouldSave((Resource)resource)) {
                                try {
                                    resource.save((Map)saveOptions.get(resource));
                                    savedResources.add(resource);
                                }
                                catch (Throwable t) {
                                    failedSaves.put(resource.getURI(), t);
                                }
                            }
                            ++i;
                        }
                    }
                };
                try {
                    editingDomain.runExclusive(runnable);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(wsRunnable, null);
            if (!failedSaves.isEmpty()) {
                throw new WrappedException(this.createMessage(failedSaves), (Exception)new RuntimeException());
            }
        }
        catch (CoreException e) {
            Throwable cause = e.getStatus().getException();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(e);
        }
        return savedResources;
    }

    private String createMessage(Map<URI, Throwable> failedSaves) {
        StringBuilder buf = new StringBuilder("The following resources could not be saved:");
        for (Map.Entry<URI, Throwable> entry : failedSaves.entrySet()) {
            buf.append("\nURI: ").append(entry.getKey().toString()).append(", cause: \n").append(this.getExceptionAsString(entry.getValue()));
        }
        return buf.toString();
    }

    private String getExceptionAsString(Throwable t) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        t.printStackTrace(printWriter);
        String result = stringWriter.toString();
        try {
            stringWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        printWriter.close();
        return result;
    }

    protected void setDiagramVersion(final Diagram diagram) {
        if (!"0.12.0".equals(diagram.getVersion())) {
            CommandStack commandStack = this.diagramBehavior.getEditingDomain().getCommandStack();
            commandStack.execute((Command)new RecordingCommand(this.diagramBehavior.getEditingDomain()){

                protected void doExecute() {
                    diagram.eSet((EStructuralFeature)PictogramsPackage.eINSTANCE.getDiagram_Version(), (Object)"0.12.0");
                }
            });
        }
    }

    protected boolean shouldSave(Resource resource) {
        return !this.diagramBehavior.getEditingDomain().isReadOnly(resource) && (!resource.isTrackingModification() || resource.isModified()) && resource.isLoaded();
    }

    protected final class SaveOperation
    implements IRunnableWithProgress,
    IThreadListener {
        private final Map<Resource, Map<?, ?>> saveOptions;
        private final Set<Resource> savedResources;

        private SaveOperation(Map<Resource, Map<?, ?>> saveOptions, Set<Resource> savedResources) {
            this.saveOptions = saveOptions;
            this.savedResources = savedResources;
        }

        public void run(IProgressMonitor monitor) {
            try {
                this.savedResources.addAll(DefaultPersistencyBehavior.this.save(DefaultPersistencyBehavior.this.diagramBehavior.getEditingDomain(), this.saveOptions, monitor));
            }
            catch (WrappedException e) {
                MultiStatus errorStatus = new MultiStatus("org.eclipse.graphiti.ui", 0, e.getMessage(), (Throwable)e.exception());
                GraphitiUIPlugin.getDefault().getLog().log((IStatus)errorStatus);
                T.racer().error(e.getMessage(), e.exception());
            }
        }

        public void threadChange(Thread thread) {
            ISchedulingRule rule = Job.getJobManager().currentRule();
            if (rule != null) {
                Job.getJobManager().transferRule(rule, thread);
            }
        }
    }
}

