/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.editor;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.CommandStackListener;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.gef.ui.parts.GraphicalEditorWithFlyoutPalette;
import org.eclipse.gef.ui.parts.SelectionSynchronizer;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;
import org.eclipse.graphiti.ui.editor.DiagramBehavior;
import org.eclipse.graphiti.ui.editor.DiagramEditorInput;
import org.eclipse.graphiti.ui.editor.EditorInputAdapter;
import org.eclipse.graphiti.ui.editor.IDiagramContainerUI;
import org.eclipse.graphiti.ui.editor.IDiagramEditorInput;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;

public class DiagramEditor
extends GraphicalEditorWithFlyoutPalette
implements IDiagramContainerUI,
ITabbedPropertySheetPageContributor,
IEditingDomainProvider {
    private String contributorId;
    private DiagramBehavior diagramBehavior;
    public static final String DIAGRAM_EDITOR_ID = "org.eclipse.graphiti.ui.editor.DiagramEditor";

    @Override
    public DiagramBehavior getDiagramBehavior() {
        return this.diagramBehavior;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        IDiagramEditorInput diagramEditorInput;
        this.diagramBehavior = this.createDiagramBehavior();
        this.diagramBehavior.setParentPart((IWorkbenchPart)this);
        this.diagramBehavior.initDefaultBehaviors();
        if (input instanceof IDiagramEditorInput) {
            diagramEditorInput = (IDiagramEditorInput)input;
        } else {
            diagramEditorInput = this.convertToDiagramEditorInput(input);
            if (diagramEditorInput == null) {
                throw new PartInitException("No DiagramEditorInput instance is available but it is required. The method convertToDiagramEditorInput illegally returned null.");
            }
        }
        this.diagramBehavior.getUpdateBehavior().createEditingDomain(diagramEditorInput);
        this.setSite((IWorkbenchPartSite)site);
        this.setInput((IEditorInput)diagramEditorInput);
        if (this.diagramBehavior.getEditorInitializationError() != null) {
            return;
        }
        this.getCommandStack().addCommandStackListener((CommandStackListener)this);
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
        this.initializeActionRegistry();
        this.diagramBehavior.getUpdateBehavior().init();
        this.diagramBehavior.migrateDiagramModelIfNecessary();
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        contextService.activateContext(this.getDiagramTypeProvider().getContextId());
    }

    protected DiagramBehavior createDiagramBehavior() {
        return new DiagramBehavior(this);
    }

    protected DiagramEditorInput convertToDiagramEditorInput(IEditorInput input) throws PartInitException {
        DiagramEditorInput newInput = EditorInputAdapter.adaptToDiagramEditorInput(input);
        if (!(newInput instanceof IDiagramEditorInput)) {
            throw new PartInitException("Unknown editor input: " + input);
        }
        return newInput;
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        if (!(input instanceof IDiagramEditorInput)) {
            throw new IllegalArgumentException("The IEditorInput has the wrong type: " + input.getClass());
        }
        this.diagramBehavior.setInput((IDiagramEditorInput)input);
    }

    public void createPartControl(Composite parent) {
        if (this.diagramBehavior.getEditorInitializationError() != null) {
            this.diagramBehavior.createErrorPartControl(parent);
        } else {
            super.createPartControl(parent);
            this.diagramBehavior.addGefListeners();
        }
    }

    protected void createGraphicalViewer(Composite parent) {
        this.diagramBehavior.createGraphicalViewer(parent);
    }

    @Override
    public void initializeGraphicalViewer() {
        super.initializeGraphicalViewer();
        this.diagramBehavior.initializeGraphicalViewer();
        if (this.getEditorSite().getActionBarContributor() != null) {
            this.getEditorSite().getActionBarContributor().setActiveEditor((IEditorPart)this);
        }
    }

    @Override
    public void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        this.diagramBehavior.configureGraphicalViewer();
    }

    public void updateDirtyState() {
        this.firePropertyChange(257);
    }

    public void doSave(IProgressMonitor monitor) {
        this.diagramBehavior.getPersistencyBehavior().saveDiagram(monitor);
        this.diagramBehavior.getUpdateBehavior().setResourceChanged(false);
    }

    public boolean isDirty() {
        return this.diagramBehavior.isDirty();
    }

    protected final PaletteViewerProvider createPaletteViewerProvider() {
        return this.diagramBehavior.createPaletteViewerProvider();
    }

    protected final FlyoutPaletteComposite.FlyoutPreferences getPalettePreferences() {
        return this.diagramBehavior.getPalettePreferences();
    }

    protected final PaletteRoot getPaletteRoot() {
        return this.diagramBehavior.getPaletteRoot();
    }

    public void refreshTitle() {
        String name = this.getDiagramTypeProvider().getDiagramTitle();
        if (name == null || name.length() == 0) {
            name = this.getConfigurationElement().getAttribute("name");
        }
        if (name == null || name.length() == 0) {
            name = URI.decode((String)this.getDiagramTypeProvider().getDiagram().eResource().getURI().lastSegment());
        }
        this.setPartName(name);
    }

    public void refreshTitleToolTip() {
        this.setTitleToolTip(this.getTitleToolTip());
    }

    public Object getAdapter(Class type) {
        Object returnObj = this.diagramBehavior.getAdapter(type);
        if (returnObj != null) {
            return returnObj;
        }
        if (type == SelectionSynchronizer.class) {
            return this.getSelectionSynchronizer();
        }
        return super.getAdapter(type);
    }

    public void dispose() {
        if (this.diagramBehavior != null) {
            this.diagramBehavior.disposeBeforeGefDispose();
        }
        RuntimeException exc = null;
        if (this.getEditDomain() != null) {
            try {
                super.dispose();
            }
            catch (RuntimeException e) {
                exc = e;
            }
        }
        if (this.diagramBehavior != null) {
            this.diagramBehavior.disposeAfterGefDispose();
        }
        if (exc != null) {
            throw exc;
        }
    }

    public void setFocus() {
        if (this.getGraphicalViewer() == null) {
            return;
        }
        super.setFocus();
        this.diagramBehavior.getUpdateBehavior().handleActivate();
    }

    public PictogramElement[] getSelectedPictogramElements() {
        return this.diagramBehavior.getSelectedPictogramElements();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        Object selectedPage;
        IEditorPart activeEditor;
        boolean editorIsActive = this.getSite().getPage().isPartVisible((IWorkbenchPart)this);
        if (!editorIsActive && (activeEditor = this.getSite().getPage().getActiveEditor()) != null && activeEditor instanceof MultiPageEditorPart && (selectedPage = ((MultiPageEditorPart)activeEditor).getAdapter(this.getClass())) instanceof DiagramEditor) {
            editorIsActive = true;
        }
        if (editorIsActive) {
            if (part instanceof CommonNavigator && !((CommonNavigator)part).isLinkingEnabled()) {
                return;
            }
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                ArrayList<PictogramElement> peList = new ArrayList<PictogramElement>();
                for (Object object : structuredSelection) {
                    if (object instanceof EObject) {
                        List referencingPes = Graphiti.getLinkService().getPictogramElements(this.getDiagramTypeProvider().getDiagram(), (EObject)object);
                        if (referencingPes.size() <= 0) continue;
                        peList.addAll(referencingPes);
                        continue;
                    }
                    PictogramElement[] relatedPictogramElements = this.getDiagramTypeProvider().getNotificationService().calculateRelatedPictogramElements(new Object[]{object});
                    int i = 0;
                    while (i < relatedPictogramElements.length) {
                        peList.add(relatedPictogramElements[i]);
                        ++i;
                    }
                }
                PictogramElement[] pes = null;
                if (peList.size() > 0) {
                    pes = peList.toArray(new PictogramElement[peList.size()]);
                }
                if (pes != null && pes.length > 0) {
                    this.selectPictogramElements(pes);
                }
            }
            this.updateActions(this.getSelectionActions());
        }
    }

    public void selectPictogramElements(PictogramElement[] pictogramElements) {
        this.diagramBehavior.selectPictogramElements(pictogramElements);
    }

    public void setPictogramElementForSelection(PictogramElement pictogramElement) {
        this.diagramBehavior.setPictogramElementForSelection(pictogramElement);
    }

    public void setPictogramElementsForSelection(PictogramElement[] pictogramElements) {
        this.diagramBehavior.setPictogramElementsForSelection(pictogramElements);
    }

    public String getContributorId() {
        IToolBehaviorProvider tbp;
        if (this.contributorId == null && (tbp = this.getToolBehaviorProvider()) != null) {
            this.contributorId = tbp.getContributorId();
        }
        return this.contributorId;
    }

    public IDiagramTypeProvider getDiagramTypeProvider() {
        return this.diagramBehavior.getDiagramTypeProvider();
    }

    @Override
    public DefaultEditDomain getEditDomain() {
        return super.getEditDomain();
    }

    @Override
    public GraphicalViewer getGraphicalViewer() {
        return super.getGraphicalViewer();
    }

    public String getTitleToolTip() {
        IToolBehaviorProvider tbp;
        String titleToolTip;
        if (this.getDiagramTypeProvider() != null && this.getDiagramTypeProvider().getCurrentToolBehaviorProvider() != null && (titleToolTip = (tbp = this.getDiagramTypeProvider().getCurrentToolBehaviorProvider()).getTitleToolTip()) != null) {
            return titleToolTip;
        }
        return super.getTitleToolTip();
    }

    private IToolBehaviorProvider getToolBehaviorProvider() {
        IDiagramTypeProvider dtp = this.getDiagramTypeProvider();
        if (dtp != null) {
            return dtp.getCurrentToolBehaviorProvider();
        }
        return null;
    }

    public TransactionalEditingDomain getEditingDomain() {
        return this.diagramBehavior.getEditingDomain();
    }

    @Override
    public IDiagramEditorInput getDiagramEditorInput() {
        return this.diagramBehavior.getInput();
    }

    @Override
    public IWorkbenchPart getWorkbenchPart() {
        return this;
    }

    public void close() {
        this.getSite().getPage().closeEditor((IEditorPart)this, false);
    }

    @Override
    public void setEditDomain(DefaultEditDomain editDomain) {
        super.setEditDomain(editDomain);
    }

    @Override
    public ActionRegistry getActionRegistry() {
        return super.getActionRegistry();
    }

    @Override
    public List getSelectionActions() {
        return super.getSelectionActions();
    }

    @Override
    public void commandStackChanged(EventObject event) {
        super.commandStackChanged(event);
    }

    @Override
    public void setGraphicalViewer(GraphicalViewer viewer) {
        super.setGraphicalViewer(viewer);
    }

    @Override
    public void hookGraphicalViewer() {
        super.hookGraphicalViewer();
    }
}

