/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.internal.services.impl;

import java.awt.Point;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.graphiti.IExecutionInfo;
import org.eclipse.graphiti.datatypes.IDimension;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.datatypes.IRectangle;
import org.eclipse.graphiti.features.IFeatureAndContext;
import org.eclipse.graphiti.features.context.impl.MoveShapeContext;
import org.eclipse.graphiti.internal.datatypes.impl.LocationImpl;
import org.eclipse.graphiti.internal.datatypes.impl.RectangleImpl;
import org.eclipse.graphiti.internal.services.GraphitiInternal;
import org.eclipse.graphiti.internal.util.LookManager;
import org.eclipse.graphiti.internal.util.T;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.MmFactory;
import org.eclipse.graphiti.mm.Property;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.styles.PrecisionPoint;
import org.eclipse.graphiti.mm.algorithms.styles.StylesFactory;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.BoxRelativeAnchor;
import org.eclipse.graphiti.mm.pictograms.ChopboxAnchor;
import org.eclipse.graphiti.mm.pictograms.CompositeConnection;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.CurvedConnection;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FixPointAnchor;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.ManhattanConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.PictogramLink;
import org.eclipse.graphiti.mm.pictograms.PictogramsFactory;
import org.eclipse.graphiti.mm.pictograms.PictogramsPackage;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeService;
import org.eclipse.graphiti.util.ILocationInfo;
import org.eclipse.graphiti.util.ILook;
import org.eclipse.graphiti.util.LocationInfo;

public final class PeServiceImpl
implements IPeService {
    private static final ArrayList<Property> EMPTY_PROPERTIES_LIST = new ArrayList(0);

    @Override
    public BoxRelativeAnchor createBoxRelativeAnchor(AnchorContainer anchorContainer) {
        BoxRelativeAnchor ret = PictogramsFactory.eINSTANCE.createBoxRelativeAnchor();
        ret.setVisible(true);
        ret.setActive(true);
        ret.setRelativeHeight(0.0);
        ret.setRelativeWidth(0.0);
        ret.setParent(anchorContainer);
        return ret;
    }

    @Override
    public ChopboxAnchor createChopboxAnchor(AnchorContainer anchorContainer) {
        ChopboxAnchor ret = PictogramsFactory.eINSTANCE.createChopboxAnchor();
        ret.setVisible(false);
        ret.setActive(false);
        ret.setParent(anchorContainer);
        return ret;
    }

    @Override
    public ConnectionDecorator createConnectionDecorator(Connection connection, boolean active, double location, boolean isRelative) {
        ConnectionDecorator ret = PictogramsFactory.eINSTANCE.createConnectionDecorator();
        ret.setActive(active);
        ret.setLocation(location);
        ret.setLocationRelative(isRelative);
        ret.setConnection(connection);
        ret.setVisible(true);
        return ret;
    }

    @Override
    public ContainerShape createContainerShape(ContainerShape parentContainerShape, boolean active) {
        ContainerShape ret = PictogramsFactory.eINSTANCE.createContainerShape();
        ret.getProperties().addAll(EMPTY_PROPERTIES_LIST);
        ret.setVisible(true);
        ret.setActive(active);
        ret.setContainer(parentContainerShape);
        return ret;
    }

    @Override
    public Diagram createDiagram(String diagramTypeId, String diagramName) {
        return this.createDiagram(diagramTypeId, diagramName, LookManager.getLook().getMinorGridLineDistance(), false);
    }

    @Override
    public Diagram createDiagram(String diagramTypeId, String diagramName, boolean snap) {
        return this.createDiagram(diagramTypeId, diagramName, LookManager.getLook().getMinorGridLineDistance(), snap);
    }

    @Override
    public Diagram createDiagram(String diagramTypeId, String diagramName, int gridUnit, boolean snap) {
        return this.createDiagram(diagramTypeId, diagramName, gridUnit, -1, snap);
    }

    @Override
    public Diagram createDiagram(String diagramTypeId, String diagramName, int horizontalGridUnit, int verticalGridUnit, boolean snap) {
        if (diagramTypeId == null || diagramName == null) {
            return null;
        }
        ILook look = LookManager.getLook();
        Diagram ret = PictogramsFactory.eINSTANCE.createDiagram();
        ret.setDiagramTypeId(diagramTypeId);
        ret.setGridUnit(horizontalGridUnit);
        if (verticalGridUnit != -1) {
            ret.setVerticalGridUnit(verticalGridUnit);
        }
        ret.setSnapToGrid(snap);
        ret.setVisible(true);
        ret.eSet((EStructuralFeature)PictogramsPackage.eINSTANCE.getDiagram_Version(), (Object)"0.12.0");
        IGaService gaService = Graphiti.getGaService();
        Rectangle rectangle = gaService.createRectangle((GraphicsAlgorithmContainer)ret);
        rectangle.setForeground(gaService.manageColor(ret, look.getMinorGridLineColor()));
        rectangle.setBackground(gaService.manageColor(ret, look.getGridBackgroundColor()));
        gaService.setSize((GraphicsAlgorithm)rectangle, 1000, 1000);
        ret.setName(diagramName);
        return ret;
    }

    @Override
    public FixPointAnchor createFixPointAnchor(AnchorContainer anchorContainer) {
        FixPointAnchor ret = PictogramsFactory.eINSTANCE.createFixPointAnchor();
        ret.setVisible(true);
        ret.setActive(true);
        ret.setParent(anchorContainer);
        return ret;
    }

    @Override
    public FreeFormConnection createFreeFormConnection(Diagram diagram) {
        FreeFormConnection ret = PictogramsFactory.eINSTANCE.createFreeFormConnection();
        ret.setVisible(true);
        ret.setActive(true);
        ret.setParent(diagram);
        return ret;
    }

    @Override
    public ManhattanConnection createManhattanConnection(Diagram diagram) {
        ManhattanConnection ret = PictogramsFactory.eINSTANCE.createManhattanConnection();
        ret.setVisible(true);
        ret.setActive(true);
        ret.setParent(diagram);
        return ret;
    }

    @Override
    public CompositeConnection createCompositeConnection(Diagram diagram) {
        CompositeConnection ret = PictogramsFactory.eINSTANCE.createCompositeConnection();
        ret.setVisible(true);
        ret.setActive(true);
        ret.setParent(diagram);
        return ret;
    }

    @Override
    public CurvedConnection createCurvedConnection(double[] xy, Diagram diagram) {
        assert (xy != null && xy.length % 2 == 0);
        CurvedConnection ret = PictogramsFactory.eINSTANCE.createCurvedConnection();
        ret.setVisible(true);
        ret.setActive(true);
        ret.setParent(diagram);
        int i = 0;
        while (i < xy.length) {
            PrecisionPoint point = StylesFactory.eINSTANCE.createPrecisionPoint();
            point.setX(xy[i]);
            point.setY(xy[i + 1]);
            ret.getControlPoints().add((Object)point);
            i += 2;
        }
        return ret;
    }

    @Override
    public Shape createShape(ContainerShape parentContainerShape, boolean active) {
        Shape ret = PictogramsFactory.eINSTANCE.createShape();
        ret.getProperties().addAll(EMPTY_PROPERTIES_LIST);
        ret.setVisible(true);
        ret.setActive(active);
        ret.setContainer(parentContainerShape);
        return ret;
    }

    @Override
    public void deletePictogramElement(PictogramElement pe) {
        PictogramLink linkForPictogramElement;
        GraphicsAlgorithm graphicsAlgorithm;
        ArrayList<Object> l;
        if (pe instanceof ContainerShape) {
            ContainerShape cs = (ContainerShape)pe;
            EList childList = cs.getChildren();
            l = new ArrayList<Object>();
            for (Shape shape : childList) {
                l.add(shape);
            }
            for (Shape shape : l) {
                this.deletePictogramElement((PictogramElement)shape);
            }
        }
        if (pe instanceof AnchorContainer) {
            AnchorContainer ac = (AnchorContainer)pe;
            EList anchorList = ac.getAnchors();
            l = new ArrayList();
            for (Anchor anchor : anchorList) {
                l.add(anchor);
            }
            for (Anchor anchor : l) {
                this.deletePictogramElement((PictogramElement)anchor);
            }
        }
        if ((graphicsAlgorithm = pe.getGraphicsAlgorithm()) != null) {
            EcoreUtil.delete((EObject)graphicsAlgorithm, (boolean)true);
        }
        if ((linkForPictogramElement = Graphiti.getLinkService().getLinkForPictogramElement(pe)) != null) {
            EcoreUtil.delete((EObject)linkForPictogramElement, (boolean)true);
        }
        EcoreUtil.delete((EObject)pe, (boolean)true);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public PictogramElement getActiveContainerPe(GraphicsAlgorithm ga) {
        if (ga != null) ** GOTO lbl5
        throw new IllegalArgumentException("Parameter must not be null");
lbl-1000:
        // 1 sources

        {
            if ((ga = ga.getParentGraphicsAlgorithm()) != null) continue;
            return null;
lbl5:
            // 2 sources

            ** while (ga.getPictogramElement() == null)
        }
lbl6:
        // 1 sources

        pe = ga.getPictogramElement();
        while (pe != null && !pe.isActive()) {
            pe = this.getPictogramElementParent(pe);
        }
        return pe;
    }

    @Override
    public PictogramElement getActiveContainerPe(PictogramElement pictogramElement) {
        PictogramElement pe = this.getPictogramElementParent(pictogramElement);
        while (pe != null && !pe.isActive()) {
            pe = this.getPictogramElementParent(pe);
        }
        return pe;
    }

    @Override
    public List<Connection> getAllConnections(Anchor anchor) {
        ArrayList<Connection> connections = new ArrayList<Connection>();
        connections.addAll((Collection<Connection>)anchor.getIncomingConnections());
        connections.addAll((Collection<Connection>)anchor.getOutgoingConnections());
        return connections;
    }

    @Override
    public List<Connection> getAllConnections(AnchorContainer anchorContainer) {
        ArrayList<Connection> connections = new ArrayList<Connection>();
        EList anchors = anchorContainer.getAnchors();
        for (Anchor anchor : anchors) {
            connections.addAll(this.getAllConnections(anchor));
        }
        return connections;
    }

    @Override
    public Collection<PictogramElement> getAllContainedPictogramElements(PictogramElement pe) {
        ArrayList<PictogramElement> ret = new ArrayList<PictogramElement>();
        Collection<PictogramElement> peChildren = this.getPictogramElementChildren(pe);
        ret.addAll(peChildren);
        for (PictogramElement peChild : peChildren) {
            ret.addAll(this.getAllContainedPictogramElements(peChild));
        }
        return ret;
    }

    @Override
    public Collection<Shape> getAllContainedShapes(ContainerShape cs) {
        ArrayList<Shape> ret = new ArrayList<Shape>();
        EList children = cs.getChildren();
        for (Shape childShape : children) {
            ret.add(childShape);
            if (!(childShape instanceof ContainerShape)) continue;
            ContainerShape childCs = (ContainerShape)childShape;
            ret.addAll(this.getAllContainedShapes(childCs));
        }
        return ret;
    }

    @Override
    public Anchor getChopboxAnchor(AnchorContainer anchorContainer) {
        EList existingAnchors = anchorContainer.getAnchors();
        for (Anchor anchor : existingAnchors) {
            if (!(anchor instanceof ChopboxAnchor)) continue;
            return anchor;
        }
        return null;
    }

    private static Point getChopboxLocationOnBox(Point outsidePoint, java.awt.Rectangle box) {
        java.awt.Rectangle r = new java.awt.Rectangle(box.x - 1, box.y - 1, box.width + 1, box.height + 1);
        float centerX = (float)r.x + 0.5f * (float)r.width;
        float centerY = (float)r.y + 0.5f * (float)r.height;
        if (r.isEmpty() || outsidePoint.x == (int)centerX && outsidePoint.y == (int)centerY) {
            return new Point((int)centerX, (int)centerY);
        }
        float dx = (float)outsidePoint.x - centerX;
        float dy = (float)outsidePoint.y - centerY;
        float scale = 0.5f / Math.max(Math.abs(dx) / (float)r.width, Math.abs(dy) / (float)r.height);
        return new Point(Math.round(centerX += (dx *= scale)), Math.round(centerY += (dy *= scale)));
    }

    @Override
    public ILocation getConnectionMidpoint(Connection c, double d) {
        ILocation ret = null;
        Anchor startAnchor = c.getStart();
        ILocation startLocation = this.getLocationRelativeToDiagram(startAnchor);
        Point startPoint = new Point(startLocation.getX(), startLocation.getY());
        Anchor endAnchor = c.getEnd();
        ILocation endLocation = this.getLocationRelativeToDiagram(endAnchor);
        Point endPoint = new Point(endLocation.getX(), endLocation.getY());
        if (startAnchor instanceof ChopboxAnchor || endAnchor instanceof ChopboxAnchor) {
            Point chopboxLocationOnBox;
            FreeFormConnection ffc;
            EList bendpoints;
            java.awt.Rectangle parentRect;
            ILocation location;
            Shape shape;
            GraphicsAlgorithm parentGa;
            if (startAnchor instanceof ChopboxAnchor) {
                ChopboxAnchor cbStartAnchor = (ChopboxAnchor)startAnchor;
                parentGa = cbStartAnchor.getParent().getGraphicsAlgorithm();
                shape = (Shape)cbStartAnchor.getParent();
                location = this.getLocationRelativeToDiagram(shape);
                parentRect = new java.awt.Rectangle(location.getX(), location.getY(), parentGa.getWidth(), parentGa.getHeight());
                Point pointNextToStartAnchor = new Point(startPoint.x, startPoint.y);
                if (c instanceof FreeFormConnection && !(bendpoints = (ffc = (FreeFormConnection)c).getBendpoints()).isEmpty()) {
                    org.eclipse.graphiti.mm.algorithms.styles.Point firstBendpoint = (org.eclipse.graphiti.mm.algorithms.styles.Point)bendpoints.get(0);
                    pointNextToStartAnchor.setLocation(firstBendpoint.getX(), firstBendpoint.getY());
                }
                chopboxLocationOnBox = PeServiceImpl.getChopboxLocationOnBox(pointNextToStartAnchor, parentRect);
                startPoint.setLocation(chopboxLocationOnBox);
            }
            if (endAnchor instanceof ChopboxAnchor) {
                ChopboxAnchor cbEndAnchor = (ChopboxAnchor)endAnchor;
                parentGa = cbEndAnchor.getParent().getGraphicsAlgorithm();
                shape = (Shape)cbEndAnchor.getParent();
                location = this.getLocationRelativeToDiagram(shape);
                parentRect = new java.awt.Rectangle(location.getX(), location.getY(), parentGa.getWidth(), parentGa.getHeight());
                Point pointNextToEndAnchor = new Point(endPoint.x, endPoint.y);
                if (c instanceof FreeFormConnection && !(bendpoints = (ffc = (FreeFormConnection)c).getBendpoints()).isEmpty()) {
                    org.eclipse.graphiti.mm.algorithms.styles.Point lastBendpoint = (org.eclipse.graphiti.mm.algorithms.styles.Point)bendpoints.get(bendpoints.size() - 1);
                    pointNextToEndAnchor.setLocation(lastBendpoint.getX(), lastBendpoint.getY());
                }
                chopboxLocationOnBox = PeServiceImpl.getChopboxLocationOnBox(pointNextToEndAnchor, parentRect);
                endPoint.setLocation(chopboxLocationOnBox);
            }
        }
        if (c instanceof FreeFormConnection) {
            FreeFormConnection ffc = (FreeFormConnection)c;
            EList bendpoints = ffc.getBendpoints();
            Point[] awtPointsArray = new Point[bendpoints.size() + 2];
            awtPointsArray[0] = startPoint;
            int i = 1;
            for (org.eclipse.graphiti.mm.algorithms.styles.Point pictogramsPoint : bendpoints) {
                awtPointsArray[i] = new Point(pictogramsPoint.getX(), pictogramsPoint.getY());
                ++i;
            }
            awtPointsArray[i] = endPoint;
            double completeDistance = PeServiceImpl.getDistance(awtPointsArray);
            double absDistanceToRelPoint = completeDistance * d;
            double distanceSum = 0.0;
            int i2 = 0;
            while (i2 < awtPointsArray.length - 1) {
                double oldDistanceSum = distanceSum;
                Point currentPoint = awtPointsArray[i2];
                Point nextPoint = awtPointsArray[i2 + 1];
                double additionalDistanceToNext = PeServiceImpl.getDistance(currentPoint, nextPoint);
                if ((distanceSum += additionalDistanceToNext) >= absDistanceToRelPoint) {
                    double thisRelative = (completeDistance * d - oldDistanceSum) / additionalDistanceToNext;
                    ret = PeServiceImpl.getMidpoint(currentPoint.x, currentPoint.y, nextPoint.x, nextPoint.y, thisRelative);
                    break;
                }
                ++i2;
            }
        } else {
            int midX = (int)Math.round((double)startPoint.x + d * (double)(endPoint.x - startPoint.x));
            int midY = (int)Math.round((double)startPoint.y + d * (double)(endPoint.y - startPoint.y));
            ret = new LocationImpl(midX, midY);
        }
        return ret;
    }

    @Override
    public Diagram getDiagramForAnchor(Anchor anchor) {
        Diagram ret = null;
        AnchorContainer ac = anchor.getParent();
        if (ac instanceof Connection) {
            Connection connection = (Connection)ac;
            ret = connection.getParent();
        } else if (ac instanceof Shape) {
            Shape shape = (Shape)ac;
            ret = this.getDiagramForShape(shape);
        }
        return ret;
    }

    @Override
    public Diagram getDiagramForPictogramElement(PictogramElement pe) {
        Diagram ret = null;
        if (pe instanceof Diagram) {
            ret = (Diagram)pe;
        } else if (pe instanceof ConnectionDecorator) {
            ret = this.getDiagramForPictogramElement((PictogramElement)((ConnectionDecorator)pe).getConnection());
        } else if (pe instanceof Shape) {
            ret = this.getDiagramForShape((Shape)((Shape)pe).getContainer());
        } else if (pe instanceof Anchor) {
            ret = this.getDiagramForAnchor((Anchor)pe);
        } else if (pe instanceof Connection) {
            ret = ((Connection)pe).getParent();
        }
        return ret;
    }

    @Override
    public Diagram getDiagramForShape(Shape shape) {
        Diagram ret = null;
        ret = shape instanceof Diagram ? (Diagram)shape : (shape instanceof ConnectionDecorator ? this.getDiagramForPictogramElement((PictogramElement)((ConnectionDecorator)shape).getConnection()) : this.getDiagramForShape((Shape)shape.getContainer()));
        return ret;
    }

    private static double getDistance(Point start, Point end) {
        int xDist = end.x - start.x;
        int yDist = end.y - start.y;
        double ret = Math.sqrt(xDist * xDist + yDist * yDist);
        return ret;
    }

    private static double getDistance(Point[] points) {
        double ret = 0.0;
        int i = 0;
        while (i < points.length - 1) {
            Point currentPoint = points[i];
            Point nextPoint = points[i + 1];
            ret += PeServiceImpl.getDistance(currentPoint, nextPoint);
            ++i;
        }
        return ret;
    }

    @Override
    public EObject[] getElementsNotInDiagram(EObject[] elements, Diagram diagram) {
        String SIGNATURE = "getElementsNotInDiagram(EObject[] elements, Diagram diag)";
        boolean info = T.racer().info();
        if (info) {
            T.racer().entering(PeServiceImpl.class, "getElementsNotInDiagram(EObject[] elements, Diagram diag)", elements, diagram);
        }
        if (elements.length == 0) {
            return new EObject[0];
        }
        if (diagram == null) {
            throw new IllegalArgumentException("Diagram must not be null");
        }
        HashSet<EObject> notLinkedPEs = new HashSet<EObject>(elements.length);
        int i = 0;
        while (i < elements.length) {
            notLinkedPEs.add(elements[i]);
            ++i;
        }
        TreeIterator iterator = diagram.eAllContents();
        while (iterator.hasNext()) {
            PictogramLink link;
            EObject object = (EObject)iterator.next();
            if (!(object instanceof PictogramElement) || (link = ((PictogramElement)object).getLink()) == null) continue;
            EList businessObjects = link.getBusinessObjects();
            for (EObject businessObject : businessObjects) {
                EObject toRemove = null;
                for (EObject notLinkedObject : notLinkedPEs) {
                    if (!GraphitiInternal.getEmfService().getDTPForDiagram(diagram).getCurrentToolBehaviorProvider().equalsBusinessObjects(notLinkedObject, businessObject)) continue;
                    toRemove = notLinkedObject;
                }
                if (toRemove == null) continue;
                notLinkedPEs.remove(toRemove);
            }
        }
        EObject[] result = new EObject[notLinkedPEs.size()];
        result = notLinkedPEs.toArray(result);
        return result;
    }

    @Override
    public IRectangle getGaBoundsForAnchor(Anchor anchor) {
        RectangleImpl ret = new RectangleImpl(0, 0);
        GraphicsAlgorithm parentGa = anchor.getParent().getGraphicsAlgorithm();
        if (parentGa != null) {
            if (anchor.getReferencedGraphicsAlgorithm() != null) {
                GraphicsAlgorithm referencedGa = anchor.getReferencedGraphicsAlgorithm();
                int relX = this.getRelativeX(referencedGa, parentGa);
                int relY = this.getRelativeY(referencedGa, parentGa);
                ret = new RectangleImpl(relX, relY, referencedGa.getWidth(), referencedGa.getHeight());
            } else {
                ret = new RectangleImpl(0, 0, parentGa.getWidth(), parentGa.getHeight());
            }
        }
        return ret;
    }

    private int getRelativeX(GraphicsAlgorithm ga, GraphicsAlgorithm referenceGA) {
        if (referenceGA == null || ga == null) {
            throw new IllegalArgumentException("ga and referenceGa must not be null, and ga must be a child of referenceGA");
        }
        if (ga.equals(referenceGA)) {
            return 0;
        }
        int ret = ga.getX();
        GraphicsAlgorithm parent = ga.getParentGraphicsAlgorithm();
        return ret += this.getRelativeX(parent, referenceGA);
    }

    private int getRelativeY(GraphicsAlgorithm ga, GraphicsAlgorithm referenceGA) {
        if (referenceGA == null || ga == null) {
            throw new IllegalArgumentException("ga and referenceGa must not be null, and ga must be a child of referenceGA");
        }
        if (ga.equals(referenceGA)) {
            return 0;
        }
        int ret = ga.getY();
        GraphicsAlgorithm parent = ga.getParentGraphicsAlgorithm();
        return ret += this.getRelativeY(parent, referenceGA);
    }

    private static GraphicsAlgorithm getGraphicsAlgorithmForLocation(GraphicsAlgorithm graphicsAlgorithm, int x, int y) {
        if (graphicsAlgorithm == null) {
            return null;
        }
        EList children = graphicsAlgorithm.getGraphicsAlgorithmChildren();
        for (GraphicsAlgorithm childGa : children) {
            int newY;
            int newX;
            GraphicsAlgorithm ga = PeServiceImpl.getGraphicsAlgorithmForLocation(childGa, newX = x - childGa.getX(), newY = y - childGa.getY());
            if (ga == null) continue;
            return ga;
        }
        IDimension size = Graphiti.getGaService().calculateSize(graphicsAlgorithm);
        if (x >= 0 && x < size.getWidth() && y >= 0 && y < size.getHeight()) {
            return graphicsAlgorithm;
        }
        return null;
    }

    private static int getHeightOfPictogramElement(PictogramElement pe) {
        int ret = 0;
        GraphicsAlgorithm ga = pe.getGraphicsAlgorithm();
        if (ga != null) {
            ret = ga.getHeight();
        }
        return ret;
    }

    @Override
    public List<Connection> getIncomingConnections(AnchorContainer anchorContainer) {
        ArrayList<Connection> connections = new ArrayList<Connection>();
        EList anchors = anchorContainer.getAnchors();
        for (Anchor anchor : anchors) {
            connections.addAll((Collection<Connection>)anchor.getIncomingConnections());
        }
        return connections;
    }

    @Override
    public Object[] getLinkedPictogramElements(EObject[] elements, Diagram diagram) {
        String SIGNATURE = "getLinkedPictogramElements(EObject[] elements, Diagram diag)";
        boolean info = T.racer().info();
        if (info) {
            T.racer().entering(PeServiceImpl.class, "getLinkedPictogramElements(EObject[] elements, Diagram diag)", elements, diagram);
        }
        if (diagram == null) {
            throw new IllegalArgumentException("Diagram must not be null");
        }
        HashSet<PictogramElement> linkedPEs = new HashSet<PictogramElement>();
        TreeIterator iterator = diagram.eAllContents();
        while (iterator.hasNext()) {
            PictogramLink link;
            EObject object = (EObject)iterator.next();
            if (!(object instanceof PictogramElement) || (link = ((PictogramElement)object).getLink()) == null) continue;
            EList businessObjects = link.getBusinessObjects();
            for (EObject eObject : businessObjects) {
                int i = 0;
                while (i < elements.length) {
                    if (GraphitiInternal.getEmfService().getDTPForDiagram(diagram).getCurrentToolBehaviorProvider().equalsBusinessObjects(elements[i], eObject)) {
                        linkedPEs.add(link.getPictogramElement());
                    }
                    ++i;
                }
            }
        }
        Object[] result = new Object[linkedPEs.size()];
        result = linkedPEs.toArray(result);
        return result;
    }

    @Override
    public ILocationInfo getLocationInfo(Shape shape, int x, int y) {
        GraphicsAlgorithm ga;
        if (shape instanceof ContainerShape) {
            ContainerShape containerShape = (ContainerShape)shape;
            EList children = containerShape.getChildren();
            int i = children.size() - 1;
            while (i >= 0) {
                int newY;
                int newX;
                ILocationInfo locationInfo;
                Shape childShape = (Shape)children.get(i);
                GraphicsAlgorithm childGa = childShape.getGraphicsAlgorithm();
                if (childGa != null && (locationInfo = this.getLocationInfo(childShape, newX = x - childGa.getX(), newY = y - childGa.getY())) != null) {
                    return locationInfo;
                }
                --i;
            }
        }
        if ((ga = PeServiceImpl.getGraphicsAlgorithmForLocation(shape.getGraphicsAlgorithm(), x, y)) != null) {
            return new LocationInfo(shape, ga);
        }
        return null;
    }

    @Override
    public ILocation getLocationRelativeToDiagram(Anchor anchor) {
        int x = this.getRelativeToDiagramX(anchor);
        int y = this.getRelativeToDiagramY(anchor);
        LocationImpl ret = new LocationImpl(x, y);
        return ret;
    }

    @Override
    public ILocation getLocationRelativeToDiagram(Shape shape) {
        int x = this.getRelativeToDiagramX(shape);
        int y = this.getRelativeToDiagramY(shape);
        LocationImpl ret = new LocationImpl(x, y);
        return ret;
    }

    private static ILocation getMidpoint(int startX, int startY, int endX, int endY, double d) {
        int midX = (int)Math.round((double)startX + d * (double)(endX - startX));
        int midY = (int)Math.round((double)startY + d * (double)(endY - startY));
        return new LocationImpl(midX, midY);
    }

    @Override
    public List<Connection> getOutgoingConnections(AnchorContainer anchorContainer) {
        ArrayList<Connection> connections = new ArrayList<Connection>();
        EList anchors = anchorContainer.getAnchors();
        for (Anchor anchor : anchors) {
            connections.addAll((Collection<Connection>)anchor.getOutgoingConnections());
        }
        return connections;
    }

    @Override
    public Collection<PictogramElement> getPictogramElementChildren(PictogramElement pe) {
        ArrayList<PictogramElement> retList = new ArrayList<PictogramElement>();
        if (pe instanceof Diagram) {
            Diagram diagram = (Diagram)pe;
            retList.addAll((Collection<PictogramElement>)diagram.getConnections());
        }
        if (pe instanceof ContainerShape) {
            ContainerShape containerShape = (ContainerShape)pe;
            retList.addAll((Collection<PictogramElement>)containerShape.getChildren());
        }
        if (pe instanceof Connection) {
            Connection connection = (Connection)pe;
            retList.addAll((Collection<PictogramElement>)connection.getConnectionDecorators());
        }
        if (pe instanceof AnchorContainer) {
            AnchorContainer anchorContainer = (AnchorContainer)pe;
            retList.addAll((Collection<PictogramElement>)anchorContainer.getAnchors());
        }
        return retList;
    }

    @Override
    public PictogramElement getPictogramElementParent(PictogramElement pe) {
        if (pe instanceof ConnectionDecorator) {
            return ((ConnectionDecorator)pe).getConnection();
        }
        if (pe instanceof Shape) {
            return ((Shape)pe).getContainer();
        }
        if (pe instanceof Connection) {
            return ((Connection)pe).getParent();
        }
        if (pe instanceof Anchor) {
            return ((Anchor)pe).getParent();
        }
        return null;
    }

    @Override
    public Property getProperty(PropertyContainer propertyContainer, String key) {
        if (propertyContainer == null || key == null || !GraphitiInternal.getEmfService().isObjectAlive((EObject)propertyContainer)) {
            return null;
        }
        EList collection = propertyContainer.getProperties();
        for (Property property : collection) {
            if (!key.equals(property.getKey())) continue;
            return property;
        }
        return null;
    }

    @Override
    public String getPropertyValue(PropertyContainer propertyContainer, String key) {
        Property property = this.getProperty(propertyContainer, key);
        if (property != null) {
            return property.getValue();
        }
        return null;
    }

    private int getRelativeToDiagramX(Anchor anchor) {
        AnchorContainer anchorContainer;
        IRectangle gaBoundsForAnchor;
        int ret = 0;
        if (anchor == null) {
            return ret;
        }
        if (anchor instanceof FixPointAnchor) {
            FixPointAnchor fpa = (FixPointAnchor)anchor;
            gaBoundsForAnchor = this.getGaBoundsForAnchor(anchor);
            ret = gaBoundsForAnchor.getX() + fpa.getLocation().getX();
        } else if (anchor instanceof BoxRelativeAnchor) {
            BoxRelativeAnchor bra = (BoxRelativeAnchor)anchor;
            gaBoundsForAnchor = this.getGaBoundsForAnchor(anchor);
            ret = gaBoundsForAnchor.getX() + (int)Math.round((double)gaBoundsForAnchor.getWidth() * bra.getRelativeWidth());
        } else if (anchor instanceof ChopboxAnchor) {
            ret = Math.round(PeServiceImpl.getWidthOfPictogramElement((PictogramElement)anchor.getParent()) / 2);
        }
        if (anchor != null && (anchorContainer = anchor.getParent()) instanceof Shape) {
            Shape shape = (Shape)anchorContainer;
            ret += this.getRelativeToDiagramX(shape);
        }
        return ret;
    }

    private int getRelativeToDiagramX(Shape shape) {
        Shape initialShape = shape;
        int ret = 0;
        if (!(shape instanceof ConnectionDecorator)) {
            while (shape != null && !(shape instanceof Diagram)) {
                if (initialShape == shape || shape.isActive()) {
                    ret += PeServiceImpl.getXOfPictogramElement((PictogramElement)shape);
                }
                shape = shape.getContainer();
            }
        } else {
            ConnectionDecorator decorator = (ConnectionDecorator)shape;
            ILocation midpoint = this.getConnectionMidpoint(decorator.getConnection(), decorator.getLocation());
            ret = decorator.getGraphicsAlgorithm().getX() + midpoint.getX();
        }
        return ret;
    }

    private int getRelativeToDiagramY(Anchor anchor) {
        IRectangle gaBoundsForAnchor;
        int ret = 0;
        if (anchor == null) {
            return ret;
        }
        if (anchor instanceof FixPointAnchor) {
            FixPointAnchor fpa = (FixPointAnchor)anchor;
            gaBoundsForAnchor = this.getGaBoundsForAnchor(anchor);
            ret = gaBoundsForAnchor.getY() + fpa.getLocation().getY();
        } else if (anchor instanceof BoxRelativeAnchor) {
            BoxRelativeAnchor bra = (BoxRelativeAnchor)anchor;
            gaBoundsForAnchor = this.getGaBoundsForAnchor(anchor);
            ret = gaBoundsForAnchor.getY() + (int)Math.round((double)gaBoundsForAnchor.getHeight() * bra.getRelativeHeight());
        } else if (anchor instanceof ChopboxAnchor) {
            ret = Math.round(PeServiceImpl.getHeightOfPictogramElement((PictogramElement)anchor.getParent()) / 2);
        }
        AnchorContainer anchorContainer = anchor.getParent();
        if (anchorContainer instanceof Shape) {
            Shape shape = (Shape)anchorContainer;
            ret += this.getRelativeToDiagramY(shape);
        }
        return ret;
    }

    private int getRelativeToDiagramY(Shape shape) {
        Shape initialShape = shape;
        int ret = 0;
        if (!(shape instanceof ConnectionDecorator)) {
            while (shape != null && !(shape instanceof Diagram)) {
                if (initialShape == shape || shape.isActive()) {
                    ret += PeServiceImpl.getYOfPictogramElement((PictogramElement)shape);
                }
                shape = shape.getContainer();
            }
        } else {
            ConnectionDecorator decorator = (ConnectionDecorator)shape;
            ILocation midpoint = this.getConnectionMidpoint(decorator.getConnection(), decorator.getLocation());
            ret = decorator.getGraphicsAlgorithm().getY() + midpoint.getY();
        }
        return ret;
    }

    private static int getWidthOfPictogramElement(PictogramElement pe) {
        int ret = 0;
        GraphicsAlgorithm ga = pe.getGraphicsAlgorithm();
        if (ga != null) {
            ret = ga.getWidth();
        }
        return ret;
    }

    protected static int getXOfPictogramElement(PictogramElement pe) {
        int ret = 0;
        GraphicsAlgorithm ga = pe.getGraphicsAlgorithm();
        if (ga != null) {
            ret = ga.getX();
        }
        return ret;
    }

    protected static int getYOfPictogramElement(PictogramElement pe) {
        int ret = 0;
        GraphicsAlgorithm ga = pe.getGraphicsAlgorithm();
        if (ga != null) {
            ret = ga.getY();
        }
        return ret;
    }

    @Override
    public void moveBendpoints(IExecutionInfo executionInfo) {
        Object context;
        HashSet<FreeFormConnection> connections = new HashSet<FreeFormConnection>();
        HashSet<AnchorContainer> anchorContainers = new HashSet<AnchorContainer>();
        IFeatureAndContext[] featureAndContexts = executionInfo.getExecutionList();
        int deltaX = 0;
        int deltaY = 0;
        IFeatureAndContext[] iFeatureAndContextArray = featureAndContexts;
        int n = featureAndContexts.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureAndContext iFeatureAndContext = iFeatureAndContextArray[n2];
            context = iFeatureAndContext.getContext();
            if (context instanceof MoveShapeContext) {
                deltaX = ((MoveShapeContext)context).getDeltaX();
                deltaY = ((MoveShapeContext)context).getDeltaY();
                break;
            }
            ++n2;
        }
        if (deltaX == 0 && deltaY == 0) {
            return;
        }
        iFeatureAndContextArray = featureAndContexts;
        n = featureAndContexts.length;
        n2 = 0;
        while (n2 < n) {
            PictogramElement pe;
            IFeatureAndContext iFeatureAndContext = iFeatureAndContextArray[n2];
            context = iFeatureAndContext.getContext();
            if (context instanceof MoveShapeContext && (pe = ((MoveShapeContext)context).getPictogramElement()) instanceof AnchorContainer) {
                anchorContainers.add((AnchorContainer)pe);
            }
            ++n2;
        }
        for (AnchorContainer anchorContainer : anchorContainers) {
            List<Connection> outgoingConnections = this.getOutgoingConnections(anchorContainer);
            for (Connection outgoingConnection : outgoingConnections) {
                if (!(outgoingConnection instanceof FreeFormConnection)) continue;
                for (AnchorContainer anchorContainer2 : anchorContainers) {
                    List<Connection> incomingConnections;
                    if (anchorContainer == anchorContainer2 || !(incomingConnections = this.getIncomingConnections(anchorContainer2)).contains(outgoingConnection)) continue;
                    connections.add((FreeFormConnection)outgoingConnection);
                }
            }
        }
        for (Connection connection : connections) {
            if (!(connection instanceof FreeFormConnection)) continue;
            FreeFormConnection freeFormConnection = (FreeFormConnection)connection;
            EList bendPoints = freeFormConnection.getBendpoints();
            int i = 0;
            while (i < bendPoints.size()) {
                org.eclipse.graphiti.mm.algorithms.styles.Point oldPoint = (org.eclipse.graphiti.mm.algorithms.styles.Point)bendPoints.get(i);
                org.eclipse.graphiti.mm.algorithms.styles.Point newPoint = Graphiti.getGaCreateService().createPoint(oldPoint.getX() + deltaX, oldPoint.getY() + deltaY);
                bendPoints.set(i, newPoint);
                ++i;
            }
        }
    }

    @Override
    public boolean removeProperty(PropertyContainer propertyContainer, String key) {
        Property property = this.getProperty(propertyContainer, key);
        if (property != null) {
            propertyContainer.getProperties().remove((Object)property);
            return true;
        }
        return false;
    }

    @Override
    public void sendToBack(Shape shape) {
        ContainerShape parentContainerShape = shape.getContainer();
        EList brotherAndSisterList = parentContainerShape.getChildren();
        brotherAndSisterList.remove(shape);
        brotherAndSisterList.add(0, shape);
    }

    @Override
    public void sendToFront(Shape shape) {
        ContainerShape parentContainerShape = shape.getContainer();
        EList brotherAndSisterList = parentContainerShape.getChildren();
        brotherAndSisterList.remove(shape);
        brotherAndSisterList.add(shape);
    }

    @Override
    public void setPropertyValue(PropertyContainer propertyContainer, String key, String value) {
        if (propertyContainer == null) {
            throw new InvalidParameterException("propertyContainer must not be null");
        }
        Property property = this.getProperty(propertyContainer, key);
        if (property != null) {
            this.removeProperty(propertyContainer, key);
        }
        property = MmFactory.eINSTANCE.createProperty();
        property.setKey(key);
        property.setValue(value);
        propertyContainer.getProperties().add((Object)property);
    }
}

