/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.figures;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.ui.internal.figures.BezierPoint;
import org.eclipse.graphiti.ui.internal.figures.GFAbstractPointListShape;
import org.eclipse.graphiti.ui.internal.figures.GFFigureUtil;
import org.eclipse.graphiti.ui.internal.parts.IPictogramElementDelegate;
import org.eclipse.swt.graphics.Path;

public class GFPolyline
extends GFAbstractPointListShape {
    private int minimumSelectionLineWidth = 5;
    private boolean suppressFilling = false;
    private int generalBezierDistance = 0;
    private int[] specificBezierDistances = null;
    private PointList adjustedPointsWithoutZoom = new PointList();

    public GFPolyline(IPictogramElementDelegate pictogramElementDelegate, GraphicsAlgorithm graphicsAlgorithm) {
        super(pictogramElementDelegate, graphicsAlgorithm);
        if (graphicsAlgorithm instanceof Polyline) {
            this.minimumSelectionLineWidth = pictogramElementDelegate.getConfigurationProvider().getDiagramTypeProvider().getCurrentToolBehaviorProvider().getLineSelectionWidth((Polyline)graphicsAlgorithm);
        }
        this.setSuppressFilling(true);
    }

    public void setMinimumSelectionLineWidth(int minimumSelectionLineWidth) {
        this.minimumSelectionLineWidth = minimumSelectionLineWidth;
    }

    public void setSuppressFilling(boolean suppressFilling) {
        this.suppressFilling = suppressFilling;
    }

    public void setGeneralBezierDistance(int bezierDistance) {
        this.generalBezierDistance = bezierDistance;
    }

    protected int getGeneralBezierDistance() {
        return this.generalBezierDistance;
    }

    public void setSpecificBezierDistances(int[] bezierDistances) {
        this.specificBezierDistances = bezierDistances;
    }

    protected int[] getSpecificBezierDistances() {
        return this.specificBezierDistances;
    }

    protected PointList getAdjustedPointListWithoutZoom() {
        this.getBounds();
        return this.adjustedPointsWithoutZoom;
    }

    protected PointList getAdjustedPointList(PointList points, double zoom, double lw) {
        return GFFigureUtil.getAdjustedPointList(points, zoom, lw);
    }

    public Rectangle getBounds() {
        int lw;
        boolean boundsChanged = false;
        if (this.bounds == null) {
            boundsChanged = true;
            this.bounds = this.getPoints().getBounds().getCopy();
            lw = this.getLineWidth();
            this.adjustedPointsWithoutZoom = this.getAdjustedPointList(this.getPoints(), 1.0, lw);
        }
        if (this.bounds.height < (lw = this.getLineWidth())) {
            boundsChanged = true;
            this.bounds.y -= (lw - this.bounds.height + 1) / 2;
            this.bounds.height = lw + 1;
        }
        if (this.bounds.width < lw) {
            boundsChanged = true;
            this.bounds.x -= (lw - this.bounds.width + 1) / 2;
            this.bounds.width = lw + 1;
        }
        if (boundsChanged) {
            this.invalidate();
            this.fireFigureMoved();
            this.repaint();
        }
        return this.bounds;
    }

    public void setLineWidth(int lw) {
        if (this.getLineWidth() == lw) {
            return;
        }
        if (lw < this.getLineWidth()) {
            this.erase();
        }
        this.bounds = null;
        super.setLineWidth(lw);
    }

    @Override
    public boolean containsPointInFigure(int x, int y) {
        int tolerance = Math.max(this.getLineWidth(), this.minimumSelectionLineWidth);
        Boolean inFigure = GFFigureUtil.containsPointInPolyline(this.getAdjustedPointListWithoutZoom(), x, y, tolerance);
        if (inFigure != null) {
            return inFigure;
        }
        List children = this.getChildren();
        int i = 0;
        while (i < children.size()) {
            if (((IFigure)children.get(i)).containsPoint(x, y)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void primTranslate(int dx, int dy) {
        this.setPoints(GFFigureUtil.getTranslatedPointList(this.getPoints(), dx, dy));
        if (this.useLocalCoordinates()) {
            this.fireCoordinateSystemChanged();
            return;
        }
        int i = 0;
        while (i < this.getChildren().size()) {
            ((IFigure)this.getChildren().get(i)).translate(dx, dy);
            ++i;
        }
    }

    @Override
    protected void fillShape(Graphics graphics) {
        if (!this.suppressFilling) {
            super.fillShape(graphics);
        }
    }

    @Override
    protected Path createPath(Rectangle outerBoundss, Graphics graphics, boolean isFill) {
        double zoom = this.getZoomLevel(graphics);
        double lw = this.getLineWidth(graphics);
        PointList points = this.getAdjustedPointList(this.getPoints(), zoom, lw);
        List<BezierPoint> bezierPoints = this.getBezierPoints(points, zoom);
        boolean isClosed = bezierPoints.get(0).equals(bezierPoints.get(bezierPoints.size() - 1));
        Path path = GFFigureUtil.getBezierPath(bezierPoints, isClosed);
        return path;
    }

    protected List<BezierPoint> getBezierPoints(PointList points, double zoom) {
        ArrayList<BezierPoint> ret = new ArrayList<BezierPoint>(points.size());
        if (this.specificBezierDistances != null) {
            int i = 0;
            while (i < points.size()) {
                int bezierDistanceBefore = (int)((double)this.getSpecificBezierDistances()[2 * i] * zoom);
                int bezierDistanceAfter = (int)((double)this.getSpecificBezierDistances()[2 * i + 1] * zoom);
                Point point = points.getPoint(i);
                ret.add(new BezierPoint(point.x, point.y, bezierDistanceBefore, bezierDistanceAfter));
                ++i;
            }
        } else {
            int i = 0;
            while (i < points.size()) {
                int bezierDistance = (int)((double)this.getGeneralBezierDistance() * zoom);
                Point point = points.getPoint(i);
                ret.add(new BezierPoint(point.x, point.y, bezierDistance, bezierDistance));
                ++i;
            }
        }
        return ret;
    }
}

