/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.features.impl;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.graphiti.features.ICustomAbortableUndoRedoFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.features.impl.AbstractUpdateFeature;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;

public class DefaultUpdateDiagramFeature
extends AbstractUpdateFeature
implements ICustomAbortableUndoRedoFeature {
    private boolean hasDoneChanges = false;

    public DefaultUpdateDiagramFeature(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    public boolean canUpdate(IUpdateContext context) {
        return context.getPictogramElement() instanceof Diagram;
    }

    @Override
    public boolean update(IUpdateContext context) {
        PictogramElement pe = context.getPictogramElement();
        Map<IUpdateFeature, IUpdateContext> connToUpdate = this.findFeaturesToUpdateChildren(pe, true);
        this.hasDoneChanges = false;
        for (IUpdateFeature feature : connToUpdate.keySet()) {
            if (feature instanceof ICustomAbortableUndoRedoFeature && ((ICustomAbortableUndoRedoFeature)((Object)feature)).isAbort()) break;
            feature.update(connToUpdate.get(feature));
            if (!feature.hasDoneChanges()) continue;
            this.hasDoneChanges = true;
        }
        return true;
    }

    @Override
    public IReason updateNeeded(IUpdateContext context) {
        PictogramElement pe = context.getPictogramElement();
        if (pe instanceof Diagram) {
            Diagram d = (Diagram)pe;
            EList children = d.getChildren();
            for (Shape shape : children) {
                UpdateContext updateContext = new UpdateContext((PictogramElement)shape);
                IUpdateFeature updateFeature = this.getFeatureProvider().getUpdateFeature(updateContext);
                if (updateFeature == null || !updateFeature.updateNeeded(updateContext).toBoolean()) continue;
                return Reason.createTrueReason();
            }
            EList connections = d.getConnections();
            for (Connection connection : connections) {
                UpdateContext updateContext = new UpdateContext((PictogramElement)connection);
                IUpdateFeature updateFeature = this.getFeatureProvider().getUpdateFeature(updateContext);
                if (updateFeature == null || !updateFeature.updateNeeded(updateContext).toBoolean()) continue;
                return Reason.createTrueReason();
            }
        }
        return Reason.createFalseReason();
    }

    @Override
    public boolean hasDoneChanges() {
        return this.hasDoneChanges;
    }

    @Override
    public boolean canUndo(IContext context) {
        PictogramElement pe = ((IUpdateContext)context).getPictogramElement();
        Map<IUpdateFeature, IUpdateContext> connToUpdate = this.findFeaturesToUpdateChildren(pe, false);
        for (IUpdateFeature feature : connToUpdate.keySet()) {
            ICustomAbortableUndoRedoFeature abortableFeature;
            if (!(feature instanceof ICustomAbortableUndoRedoFeature) || (abortableFeature = (ICustomAbortableUndoRedoFeature)((Object)feature)).canUndo(context)) continue;
            return false;
        }
        return super.canUndo(context);
    }

    @Override
    public void preUndo(IContext context) {
        PictogramElement pe = ((IUpdateContext)context).getPictogramElement();
        Map<IUpdateFeature, IUpdateContext> connToUpdate = this.findFeaturesToUpdateChildren(pe, false);
        this.hasDoneChanges = false;
        for (IUpdateFeature feature : connToUpdate.keySet()) {
            if (!(feature instanceof ICustomAbortableUndoRedoFeature)) continue;
            ICustomAbortableUndoRedoFeature abortableFeature = (ICustomAbortableUndoRedoFeature)((Object)feature);
            if (abortableFeature.isAbort()) break;
            abortableFeature.preUndo(connToUpdate.get(feature));
            if (!feature.hasDoneChanges()) continue;
            this.hasDoneChanges = true;
        }
    }

    @Override
    public void postUndo(IContext context) {
        PictogramElement pe = ((IUpdateContext)context).getPictogramElement();
        Map<IUpdateFeature, IUpdateContext> connToUpdate = this.findFeaturesToUpdateChildren(pe, false);
        for (IUpdateFeature feature : connToUpdate.keySet()) {
            if (!(feature instanceof ICustomAbortableUndoRedoFeature)) continue;
            ICustomAbortableUndoRedoFeature abortableFeature = (ICustomAbortableUndoRedoFeature)((Object)feature);
            if (abortableFeature.isAbort()) break;
            abortableFeature.postUndo(connToUpdate.get(feature));
            if (!feature.hasDoneChanges()) continue;
            this.hasDoneChanges = true;
        }
    }

    @Override
    public boolean canRedo(IContext context) {
        PictogramElement pe = ((IUpdateContext)context).getPictogramElement();
        Map<IUpdateFeature, IUpdateContext> connToUpdate = this.findFeaturesToUpdateChildren(pe, false);
        for (IUpdateFeature feature : connToUpdate.keySet()) {
            ICustomAbortableUndoRedoFeature abortableFeature;
            if (!(feature instanceof ICustomAbortableUndoRedoFeature) || (abortableFeature = (ICustomAbortableUndoRedoFeature)((Object)feature)).canRedo(context)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void preRedo(IContext context) {
        PictogramElement pe = ((IUpdateContext)context).getPictogramElement();
        Map<IUpdateFeature, IUpdateContext> connToUpdate = this.findFeaturesToUpdateChildren(pe, false);
        this.hasDoneChanges = false;
        for (IUpdateFeature feature : connToUpdate.keySet()) {
            if (!(feature instanceof ICustomAbortableUndoRedoFeature)) continue;
            ICustomAbortableUndoRedoFeature abortableFeature = (ICustomAbortableUndoRedoFeature)((Object)feature);
            if (abortableFeature.isAbort()) break;
            abortableFeature.preRedo(connToUpdate.get(feature));
            if (!feature.hasDoneChanges()) continue;
            this.hasDoneChanges = true;
        }
    }

    @Override
    public void postRedo(IContext context) {
        PictogramElement pe = ((IUpdateContext)context).getPictogramElement();
        Map<IUpdateFeature, IUpdateContext> connToUpdate = this.findFeaturesToUpdateChildren(pe, false);
        for (IUpdateFeature feature : connToUpdate.keySet()) {
            if (!(feature instanceof ICustomAbortableUndoRedoFeature)) continue;
            ICustomAbortableUndoRedoFeature abortableFeature = (ICustomAbortableUndoRedoFeature)((Object)feature);
            if (abortableFeature.isAbort()) break;
            abortableFeature.postRedo(connToUpdate.get(feature));
            if (!feature.hasDoneChanges()) continue;
            this.hasDoneChanges = true;
        }
    }

    @Override
    public boolean isAbort() {
        return false;
    }

    protected Map<IUpdateFeature, IUpdateContext> findFeaturesToUpdateChildren(PictogramElement pe, boolean checkUpdateNeeded) {
        HashMap<IUpdateFeature, IUpdateContext> connToUpdate = new HashMap<IUpdateFeature, IUpdateContext>();
        if (pe instanceof Diagram) {
            Diagram d = (Diagram)pe;
            EList children = d.getChildren();
            for (Shape shape : children) {
                UpdateContext updateContext = new UpdateContext((PictogramElement)shape);
                IUpdateFeature updateFeature = this.getFeatureProvider().getUpdateFeature(updateContext);
                if (updateFeature == null || !updateFeature.canUpdate(updateContext) || checkUpdateNeeded && !updateFeature.updateNeeded(updateContext).toBoolean()) continue;
                connToUpdate.put(updateFeature, updateContext);
            }
        }
        return connToUpdate;
    }
}

